/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.UnsupportedEncodingException;
import net.jxta.endpoint.EndpointAddress;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Address
implements EndpointAddress {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$Address == null ? (class$net$jxta$impl$endpoint$Address = Address.class$("net.jxta.impl.endpoint.Address")) : class$net$jxta$impl$endpoint$Address).getName());
    String protocol;
    String protocolAddress;
    String service;
    String serviceParam;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$Address;

    public Address() {
        this.protocol = null;
        this.protocolAddress = null;
        this.service = null;
        this.serviceParam = null;
    }

    public Address(String string) {
        this.parse(string);
    }

    public Address(byte[] byArray) {
        try {
            this.parse(new String(byArray, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    public Object clone() {
        Address address = new Address();
        address.protocol = this.protocol;
        address.protocolAddress = this.protocolAddress;
        address.service = this.service;
        address.serviceParam = this.serviceParam;
        return address;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Address) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public synchronized String toString() {
        if (this.service == null) {
            return this.protocol + "://" + this.protocolAddress + "/";
        }
        if (this.serviceParam != null) {
            return this.protocol + "://" + this.protocolAddress + "/" + this.service + "/" + this.serviceParam;
        }
        return this.protocol + "://" + this.protocolAddress + "/" + this.service;
    }

    public synchronized byte[] getBytes() {
        return this.toString().getBytes();
    }

    public synchronized String getProtocolName() {
        return this.protocol;
    }

    public synchronized String getProtocolAddress() {
        return this.protocolAddress;
    }

    public synchronized String getServiceName() {
        return this.service;
    }

    public synchronized String getServiceParameter() {
        return this.serviceParam;
    }

    public synchronized void setProtocolName(String string) {
        this.protocol = string;
    }

    public synchronized void setProtocolAddress(String string) {
        this.protocolAddress = string;
    }

    public synchronized void setServiceName(String string) {
        this.service = string;
    }

    public synchronized void setServiceParameter(String string) {
        this.serviceParam = string;
    }

    private void parse(String string) {
        int n = string.indexOf("://");
        String string2 = null;
        if (n == -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Address is not in absolute form");
            }
            throw new IllegalArgumentException("Address is not in absolute form");
        }
        try {
            this.protocol = string.substring(0, n);
            string2 = string.substring(n + 3);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Protocol address is missing");
            }
            throw new IllegalArgumentException("Protocol address is missing");
        }
        n = string2.indexOf("/");
        if (n == -1) {
            this.protocolAddress = string2;
            return;
        }
        try {
            this.protocolAddress = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        catch (Exception exception) {
            return;
        }
        n = string2.indexOf("/");
        if (n == -1) {
            this.service = string2;
            return;
        }
        try {
            this.service = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        catch (Exception exception) {
            return;
        }
        this.serviceParam = string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

