/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.TextElementCommon;

public class LiteXMLElement
extends TextElementCommon
implements Attributable {
    protected LiteXMLDocument doc;
    protected Element parent;
    protected tagRange loc;
    private StringBuffer uninserted = null;
    private Vector children = new Vector();

    protected LiteXMLElement(LiteXMLDocument liteXMLDocument, String string) {
        this(liteXMLDocument, string, null);
    }

    protected LiteXMLElement(LiteXMLDocument liteXMLDocument, String string, String string2) {
        this(liteXMLDocument, (tagRange)null);
        this.loc = new tagRange();
        if (null == string2) {
            this.uninserted = new StringBuffer();
        } else {
            this.uninserted = new StringBuffer(string2);
            this.encodeEscaped(this.uninserted);
        }
        this.uninserted.insert(0, "<" + string + ">");
        this.uninserted.append("</" + string + ">");
    }

    protected LiteXMLElement(LiteXMLDocument liteXMLDocument, tagRange tagRange2) {
        this.doc = liteXMLDocument;
        this.loc = tagRange2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LiteXMLElement)) {
            return false;
        }
        LiteXMLElement liteXMLElement = (LiteXMLElement)object;
        if (this.doc != liteXMLElement.doc) {
            return false;
        }
        if (!this.getName().equals(liteXMLElement.getName())) {
            return false;
        }
        String string = null != this.uninserted ? this.uninserted.toString() : this.getTextValue();
        String string2 = liteXMLElement.getTextValue();
        if (null == string && null == string2) {
            return true;
        }
        if (null == string || null == string2) {
            return false;
        }
        return string.equals(string2);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.doc = null;
        this.parent = null;
        this.children = null;
        this.uninserted = null;
        this.loc = null;
    }

    public StructuredDocument getRoot() {
        return this.doc;
    }

    public Element getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        return this.children.elements();
    }

    public String getName() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int n = this.loc.startTag.start + 1;
        while (n < this.loc.startTag.end) {
            if (-1 != "\n\r\t />".indexOf(this.doc.docContent.charAt(n))) break;
            ++n;
        }
        return this.doc.docContent.substring(this.loc.startTag.start + 1, n);
    }

    public String getTextValue() {
        return this.getTextValue(false);
    }

    public void appendChild(TextElement textElement) {
        if (!(textElement instanceof LiteXMLElement)) {
            throw new IllegalArgumentException("Element type not supported.");
        }
        LiteXMLElement liteXMLElement = (LiteXMLElement)textElement;
        if (liteXMLElement.doc != this.doc) {
            throw new IllegalArgumentException("Wrong document");
        }
        if (null != liteXMLElement.parent) {
            throw new IllegalArgumentException("New element is already in document");
        }
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null != liteXMLElement.uninserted) {
            this.doc.docContent = this.doc.docContent.substring(0, this.loc.endTag.start) + liteXMLElement.uninserted + this.doc.docContent.substring(this.loc.endTag.start);
            liteXMLElement.loc.startTag.start = this.loc.endTag.start;
            liteXMLElement.loc.startTag.end = this.doc.docContent.indexOf(62, liteXMLElement.loc.startTag.start);
            liteXMLElement.loc.body.start = liteXMLElement.loc.startTag.end + 1;
            liteXMLElement.loc.endTag.end = liteXMLElement.loc.startTag.start + liteXMLElement.uninserted.length() - 1;
            liteXMLElement.loc.endTag.start = this.doc.docContent.lastIndexOf(60, liteXMLElement.loc.endTag.end);
            liteXMLElement.loc.body.end = liteXMLElement.loc.endTag.start - 1;
            if (0 != this.loc.body.length()) {
                this.doc.adjustLocations(this.loc.endTag.start, liteXMLElement.uninserted.length());
            } else {
                --this.loc.body.start;
                this.doc.adjustLocations(this.loc.endTag.start, liteXMLElement.uninserted.length());
                ++this.loc.body.start;
            }
            this.loc.body.end += liteXMLElement.uninserted.length();
            liteXMLElement.uninserted = null;
        }
        if (!this.loc.body.contains(liteXMLElement.loc)) {
            throw new IllegalStateException("Element is not contained by parent");
        }
        liteXMLElement.parent = this;
        this.children.addElement(liteXMLElement);
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    public Enumeration getChildren(String string) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        Vector<TextElement> vector = new Vector<TextElement>();
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TextElement textElement = (TextElement)enumeration.nextElement();
            if (!string.equals(textElement.getName())) continue;
            vector.addElement(textElement);
        }
        return vector.elements();
    }

    protected String getTextValue(boolean bl) {
        String string;
        Object object;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Corrupted Node");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            LiteXMLElement liteXMLElement = (LiteXMLElement)enumeration.nextElement();
            object = new charRange(liteXMLElement.loc.startTag.start, liteXMLElement.loc.endTag.end);
            int n = 0;
            while (n < vector.size()) {
                charRange charRange2 = (charRange)vector.elementAt(n);
                if (1 == charRange2.compareTo(object)) {
                    vector.setElementAt(object, n);
                    object = charRange2;
                }
                ++n;
            }
            vector.addElement(object);
        }
        int n = this.loc.body.start;
        object = vector.elements();
        while (object.hasMoreElements()) {
            charRange charRange3 = (charRange)object.nextElement();
            stringBuffer.append(this.doc.docContent.substring(n, charRange3.start));
            n = charRange3.end + 1;
        }
        stringBuffer.append(this.doc.docContent.substring(n, this.loc.endTag.start));
        if (!bl) {
            stringBuffer = this.decodeEscaped(stringBuffer);
        }
        if (0 == (string = stringBuffer.toString().trim()).length()) {
            return null;
        }
        return string;
    }

    protected void printNice(Writer writer, int n, boolean bl) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        try {
            int n2 = 0;
            while (n2 < n) {
                writer.write("\t");
                ++n2;
            }
            writer.write(this.doc.docContent.substring(this.loc.startTag.start, this.loc.startTag.end + 1) + "\n");
            String string = this.getTextValue(true);
            if (null != string) {
                int n3 = 0;
                while (n3 < n + 1) {
                    writer.write("\t");
                    ++n3;
                }
                writer.write(string + "\n");
            }
            if (bl) {
                Enumeration enumeration = this.getChildren();
                while (enumeration.hasMoreElements()) {
                    ((LiteXMLElement)enumeration.nextElement()).printNice(writer, n + 1, bl);
                }
            }
            int n4 = 0;
            while (n4 < n) {
                writer.write("\t");
                ++n4;
            }
            writer.write(this.doc.docContent.substring(this.loc.endTag.start, this.loc.endTag.end + 1) + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected tagRange getTagRanges(String var1_1, String var2_2, charRange var3_3) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        var4_4 = new tagRange();
        var5_5 = var3_3.start;
        var6_6 = var1_1.length() - 1;
        var8_7 = false;
        var9_8 = false;
        v0 = var10_9 = null == var2_2 || "".equals(var2_2) != false;
        if (-1 == var5_5 || var5_5 >= var6_6) {
            return var4_4;
        }
        if (-1 != var3_3.end && var6_6 > var3_3.end) {
            var6_6 = var3_3.end;
        }
        if (null == var2_2) {
            var2_2 = "";
        }
        var7_10 = var5_5;
        if (!var10_9) ** GOTO lbl43
        var11_11 = var1_1.indexOf(60, var7_10);
        if (-1 == var11_11) {
            return var4_4;
        }
        for (var12_13 = ++var11_11; var12_13 <= var6_6; ++var12_13) {
            if (-1 == " \t\n\r/>".indexOf(var1_1.charAt(var12_13))) {
                continue;
            }
            var2_2 = var1_1.substring(var11_11, var12_13);
            var10_9 = null == var2_2 || "".equals(var2_2) != false;
            break;
        }
        if (!var10_9) ** GOTO lbl43
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var11_11 = var1_1.indexOf(var2_2, var7_10 + 1);
            var14_16 = var11_11 + var2_2.length();
            if (-1 == var11_11 || var14_16 > var6_6) {
                return var4_4;
            }
            if ('<' != var1_1.charAt(var11_11 - 1) || -1 == " \t\n\r/>".indexOf(var1_1.charAt(var14_16))) {
                var7_10 = var14_16;
                continue;
            }
            var12_13 = var1_1.indexOf(62, var14_16);
            var13_15 = var1_1.indexOf(60, var14_16 + 1);
            if (-1 == var12_13 || var12_13 > var6_6 || -1 != var13_15 && var13_15 < var12_13) {
                var7_10 = var14_16;
                continue;
            }
            var8_7 = true;
            var4_4.startTag.start = var11_11 - 1;
            var4_4.startTag.end = var12_13;
lbl43:
            // 5 sources

            ** while (!var8_7 && var7_10 < var6_6)
        }
lbl44:
        // 1 sources

        if (!var8_7) {
            return var4_4;
        }
        if ('/' == var1_1.charAt(var4_4.startTag.end - 1)) {
            var4_4.endTag = var4_4.startTag;
            return var4_4;
        }
        var7_10 = var4_4.startTag.end + 1;
        var11_12 = null;
        if (var7_10 >= var6_6) {
            return var4_4;
        }
        var12_14 = "</" + var2_2 + ">";
        while (!var9_8 && var7_10 < var6_6) {
            var13_15 = var1_1.indexOf(var12_14, var7_10);
            if (-1 == var13_15 || var13_15 + var12_14.length() - 1 > var6_6) break;
            var11_12 = this.getTagRanges(var1_1, var2_2, new charRange(var7_10, var13_15 - 1));
            if (var11_12.startTag.isValid()) {
                var7_10 = var13_15 + var12_14.length();
                continue;
            }
            var9_8 = true;
            var4_4.endTag.start = var13_15;
            var4_4.endTag.end = var13_15 + var12_14.length() - 1;
        }
        var4_4.body.start = var4_4.startTag.end + 1;
        var4_4.body.end = var9_8 != false ? var4_4.endTag.start - 1 : var6_6;
        return var4_4;
    }

    protected void addChildTags(charRange charRange2, LiteXMLElement liteXMLElement) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int n = charRange2.start;
        do {
            tagRange tagRange2;
            if ((tagRange2 = this.getTagRanges(this.doc.docContent, null, new charRange(n, charRange2.end))).isValid()) {
                LiteXMLElement liteXMLElement2 = (LiteXMLElement)this.doc.createElement(tagRange2);
                liteXMLElement.appendChild(liteXMLElement2);
                this.addChildTags(tagRange2.body, liteXMLElement2);
                n = tagRange2.endTag.end + 1;
                continue;
            }
            n = -1;
        } while (-1 != n && n < charRange2.end);
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    protected void adjustLocations(int n, int n2) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (this.loc.startTag.end >= n || this.loc.startTag.start >= n && this.loc.startTag.end + 1 == this.loc.startTag.start) {
            this.loc.startTag.end += n2;
        }
        if (this.loc.startTag.start >= n) {
            this.loc.startTag.start += n2;
        }
        if (this.loc.body.end >= n || this.loc.body.start >= n && this.loc.body.end + 1 == this.loc.body.start) {
            this.loc.body.end += n2;
        }
        if (this.loc.body.start >= n) {
            this.loc.body.start += n2;
        }
        if (this.loc.endTag.end >= n || this.loc.endTag.start >= n && this.loc.endTag.end + 1 == this.loc.endTag.start) {
            this.loc.endTag.end += n2;
        }
        if (this.loc.endTag.start >= n) {
            this.loc.endTag.start += n2;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            LiteXMLElement liteXMLElement = (LiteXMLElement)enumeration.nextElement();
            liteXMLElement.adjustLocations(n, n2);
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
    }

    protected StringBuffer decodeEscaped(StringBuffer stringBuffer) {
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n < stringBuffer.length()) {
            if ('&' != stringBuffer.charAt(n)) {
                stringBuffer2.append(stringBuffer.charAt(n));
                ++n;
                continue;
            }
            int n2 = n + 1;
            while (n2 < stringBuffer.length() && n2 - n < 6 && ';' != stringBuffer.charAt(n2)) {
                ++n2;
            }
            if (';' != stringBuffer.charAt(n2)) {
                stringBuffer2.append(stringBuffer.charAt(n));
                ++n;
                continue;
            }
            char[] cArray = new char[n2 - n + 1];
            stringBuffer.getChars(n, n2 + 1, cArray, 0);
            String string = new String(cArray);
            if ("&amp;".equals(string)) {
                stringBuffer2.append('&');
                n += 4;
            } else if ("&#38;".equals(string)) {
                stringBuffer2.append('<');
                n += 3;
            } else if ("&lt;".equals(string)) {
                stringBuffer2.append('<');
                n += 3;
            } else if ("&#60;".equals(string)) {
                stringBuffer2.append('<');
                n += 3;
            } else if ("&gt;".equals(string)) {
                stringBuffer2.append('>');
                n += 3;
            } else {
                stringBuffer2.append(stringBuffer.charAt(n));
                ++n;
                continue;
            }
            ++n;
        }
        return stringBuffer2;
    }

    protected void encodeEscaped(StringBuffer stringBuffer) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if ('&' == stringBuffer.charAt(n)) {
                stringBuffer.insert(n + 1, "amp;");
                n += 5;
                continue;
            }
            if ('<' == stringBuffer.charAt(n)) {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "lt;");
                n += 4;
                continue;
            }
            ++n;
        }
    }

    public Enumeration getAttributes() {
        Vector<Attribute> vector = new Vector<Attribute>();
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int n = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(n))) {
            ++n;
        }
        while (n < this.loc.startTag.end) {
            tagRange tagRange2 = this.getAttributeLoc(null, new charRange(n, this.loc.startTag.end));
            if (!tagRange2.isValid()) break;
            vector.add(new Attribute(this, this.doc.docContent.substring(tagRange2.startTag.start, tagRange2.startTag.end + 1), this.doc.docContent.substring(tagRange2.body.start, tagRange2.body.end + 1)));
            n = tagRange2.endTag.end + 1;
        }
        return vector.elements();
    }

    private tagRange getAttributeLoc(String string, charRange charRange2) {
        tagRange tagRange2 = new tagRange();
        int n = charRange2.start;
        while (true) {
            if (-1 != "\n\r\t >".indexOf(this.doc.docContent.charAt(n))) {
                ++n;
                continue;
            }
            int n2 = this.doc.docContent.indexOf(61, n);
            if (-1 == n2 || n2 >= charRange2.end) {
                return tagRange2;
            }
            tagRange2.startTag.start = n;
            tagRange2.startTag.end = n2 - 1;
            char c = this.doc.docContent.charAt(n2 + 1);
            if ('\'' != c && '\"' != c) {
                return tagRange2;
            }
            int n3 = this.doc.docContent.indexOf(c, n2 + 2);
            if (-1 == n3 || n3 >= charRange2.end) {
                return tagRange2;
            }
            tagRange2.body.start = n2 + 2;
            tagRange2.body.end = n3 - 1;
            tagRange2.endTag.start = n3;
            tagRange2.endTag.end = n3;
            if (null != string && !string.equals(this.doc.docContent.substring(tagRange2.startTag.start, tagRange2.startTag.end + 1))) {
                tagRange2.startTag.start = -1;
            }
            if ((n = n3 + 1) >= charRange2.end || tagRange2.isValid()) break;
        }
        return tagRange2;
    }

    public String addAttribute(String string, String string2) {
        char c;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == string) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (null == string2) {
            throw new IllegalArgumentException("value must not be null");
        }
        int n = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(n))) {
            ++n;
        }
        tagRange tagRange2 = this.getAttributeLoc(string, new charRange(n, this.loc.startTag.end));
        String string3 = null;
        char c2 = c = -1 != string2.indexOf(34) ? (char)'\'' : '\"';
        if (-1 != string2.indexOf(39)) {
            throw new IllegalArgumentException("Value contains both \" and '");
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(c);
        stringBuffer.append(string2);
        stringBuffer.append(c);
        if (!tagRange2.isValid()) {
            this.doc.docContent = this.doc.docContent.substring(0, this.loc.startTag.end) + stringBuffer + this.doc.docContent.substring(this.loc.startTag.end);
            this.doc.adjustLocations(this.loc.body.start, stringBuffer.length());
            this.loc.startTag.end += stringBuffer.length();
        } else {
            string3 = this.doc.docContent.substring(tagRange2.body.start, tagRange2.body.end + 1);
            this.doc.docContent = this.doc.docContent.substring(0, tagRange2.startTag.start) + stringBuffer + this.doc.docContent.substring(tagRange2.endTag.end + 1);
            int n2 = stringBuffer.length() - (tagRange2.endTag.end - tagRange2.startTag.start + 1);
            this.doc.adjustLocations(this.loc.body.start, n2);
            this.loc.startTag.end = this.loc.body.start - 1;
        }
        if (!this.loc.isValid()) {
            throw new IllegalStateException("Document is damaged");
        }
        return string3;
    }

    public String addAttribute(Attribute attribute) {
        return this.addAttribute(attribute.getName(), attribute.getValue());
    }

    public Attribute getAttribute(String string) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        int n = this.loc.startTag.start + 1;
        while (-1 == "\n\r\t />".indexOf(this.doc.docContent.charAt(n))) {
            ++n;
        }
        tagRange tagRange2 = this.getAttributeLoc(string, new charRange(n, this.loc.startTag.end));
        if (!tagRange2.isValid()) {
            return null;
        }
        return new Attribute(this, this.doc.docContent.substring(tagRange2.startTag.start, tagRange2.startTag.end + 1), this.doc.docContent.substring(tagRange2.body.start, tagRange2.body.end + 1));
    }

    protected static class tagRange
    implements Comparable {
        public charRange startTag = null;
        public charRange body = null;
        public charRange endTag = null;

        public tagRange() {
            this.startTag = new charRange();
            this.body = new charRange();
            this.endTag = new charRange();
        }

        public tagRange(charRange charRange2, charRange charRange3, charRange charRange4) {
            this.startTag = charRange2;
            this.body = charRange3;
            this.endTag = charRange4;
        }

        public boolean isValid() {
            return null != this.startTag && null != this.body && null != this.endTag && this.startTag.isValid() && this.body.isValid() && this.endTag.isValid();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof tagRange)) {
                return false;
            }
            tagRange tagRange2 = (tagRange)object;
            return this.startTag.equals(tagRange2.startTag) && this.body.equals(tagRange2.body) && this.endTag.equals(tagRange2.endTag);
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (!(object instanceof tagRange)) {
                throw new ClassCastException("type mismatch error");
            }
            tagRange tagRange2 = (tagRange)object;
            int n = this.startTag.compareTo(tagRange2.startTag);
            if (0 != n) {
                return n;
            }
            return this.endTag.compareTo(tagRange2.endTag);
        }

        public boolean contains(tagRange tagRange2) {
            return this.isValid() && tagRange2.isValid() && this.body.start <= tagRange2.startTag.start && this.body.end >= tagRange2.endTag.end;
        }

        public boolean contains(charRange charRange2) {
            return this.isValid() && charRange2.isValid() && this.body.start <= charRange2.start && this.body.end >= charRange2.end;
        }
    }

    protected static class charRange
    implements Comparable {
        public int start;
        public int end;

        public charRange() {
            this.start = -1;
            this.end = -1;
        }

        public charRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int length() {
            if (-1 == this.start || -1 == this.end) {
                return -1;
            }
            return this.end - this.start + 1;
        }

        public boolean isValid() {
            return this.length() >= 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof charRange)) {
                return false;
            }
            charRange charRange2 = (charRange)object;
            return this.start == charRange2.start && this.end == charRange2.end;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (!(object instanceof charRange)) {
                throw new ClassCastException("type mismatch error");
            }
            charRange charRange2 = (charRange)object;
            if (this.start < charRange2.start) {
                return -1;
            }
            if (this.start > charRange2.start) {
                return 1;
            }
            if (this.end < charRange2.end) {
                return -1;
            }
            if (this.end > charRange2.end) {
                return 1;
            }
            return 0;
        }

        public boolean contains(charRange charRange2) {
            return this.isValid() && charRange2.isValid() && this.start <= charRange2.start && this.end >= charRange2.end;
        }

        public boolean contains(tagRange tagRange2) {
            return this.isValid() && tagRange2.isValid() && this.start <= tagRange2.startTag.start && this.end >= tagRange2.endTag.end;
        }

        public boolean contains(int n) {
            return this.isValid() && n >= 0 && this.start <= n && this.end >= n;
        }
    }
}

