/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.document.TextDocumentCommon;

public class LiteXMLDocument
extends LiteXMLElement
implements TextDocumentCommon {
    private static final String JXTA_NAMESPACE = "http://jxta.org";
    public static final Instantiator INSTANTIATOR = new Instantiator();
    String docContent = null;
    private MimeMediaType mimeType = null;
    static /* synthetic */ Class class$java$lang$String;

    public LiteXMLDocument(MimeMediaType mimeMediaType, String string) {
        super(null, (LiteXMLElement.tagRange)null);
        String[] stringArray = MessageElement.parseName(string);
        String string2 = "";
        if (!stringArray[0].equals("")) {
            string2 = " xmlns:" + stringArray[0] + "=\"" + JXTA_NAMESPACE + "\"";
        }
        this.init(mimeMediaType, new InputStreamReader(new ByteArrayInputStream(("<?xml version=\"1.0\"?>\n\n<!DOCTYPE " + string + ">\n\n" + "<" + string + string2 + ">\n" + "</" + string + ">\n").getBytes())));
    }

    public LiteXMLDocument(MimeMediaType mimeMediaType, String string, String string2) {
        super(null, (LiteXMLElement.tagRange)null);
        String[] stringArray = MessageElement.parseName(string);
        String string3 = "";
        if (!stringArray[0].equals("")) {
            string3 = " xmlns:" + stringArray[0] + "=\"" + JXTA_NAMESPACE + "\"";
        }
        this.init(mimeMediaType, new InputStreamReader(new ByteArrayInputStream(new String("<?xml version=\"1.0\"?>\n\n<!DOCTYPE " + string + ">\n\n" + "<" + string + string3 + ">\n" + string2 + "</" + string + ">\n").getBytes())));
    }

    public LiteXMLDocument(MimeMediaType mimeMediaType, InputStream inputStream) {
        super(null, (LiteXMLElement.tagRange)null);
        this.init(mimeMediaType, new InputStreamReader(inputStream));
    }

    public LiteXMLDocument(MimeMediaType mimeMediaType, Reader reader) {
        super(null, (LiteXMLElement.tagRange)null);
        this.init(mimeMediaType, reader);
    }

    private void init(MimeMediaType mimeMediaType, Reader reader) {
        this.loc = new LiteXMLElement.tagRange();
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeMediaType;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[512];
        try {
            int n;
            do {
                if ((n = reader.read(cArray)) <= 0) continue;
                stringBuffer.append(cArray, 0, n);
            } while (n >= 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.docContent = new String(stringBuffer);
        stringBuffer = null;
        this.loc.startTag.start = 0;
        this.loc.startTag.end = this.docContent.indexOf(62);
        this.loc.body.start = this.loc.startTag.end + 1;
        this.loc.endTag.start = this.loc.body.end = this.docContent.length() - 1;
        this.loc.endTag.end = this.loc.body.end;
        LiteXMLElement.charRange charRange2 = this.getDocType(this.doc.docContent, false);
        this.loc = charRange2.isValid() ? this.getTagRanges(this.doc.docContent, this.docContent.substring(charRange2.start, charRange2.end + 1), this.loc.body) : this.getTagRanges(this.doc.docContent, null, this.loc.body);
        if (!this.loc.isValid()) {
            throw new RuntimeException("Parsing error in source document. could not find end of document");
        }
        this.addChildTags(this.loc.body, this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.docContent = null;
        this.mimeType = null;
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public Element createElement(Object object) {
        return this.createElement(object, null);
    }

    public Element createElement(Object object, Object object2) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(object.getClass())) {
            throw new ClassCastException(object.getClass().getName() + " not supported by createElement as key.");
        }
        if (null != object2 && !(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(object2.getClass())) {
            throw new ClassCastException(object2.getClass().getName() + " not supported by createElement as value.");
        }
        return this.createElement((String)object, (String)object2);
    }

    public TextElement createElement(String string) {
        return new LiteXMLElement(this, string);
    }

    public TextElement createElement(String string, String string2) {
        return new LiteXMLElement(this, string, string2);
    }

    protected TextElement createElement(LiteXMLElement.tagRange tagRange2) {
        return new LiteXMLElement(this, tagRange2);
    }

    public Reader getReader() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange charRange2 = this.getDocType(this.docContent, true);
        if (charRange2.isValid()) {
            stringWriter.write(this.docContent.substring(charRange2.start, charRange2.end + 1) + "\n\n");
        }
        this.printNice(stringWriter, 0, true);
        String string = stringWriter.toString();
        return new StringReader(string);
    }

    public InputStream getStream() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange charRange2 = this.getDocType(this.docContent, true);
        if (charRange2.isValid()) {
            stringWriter.write(this.docContent.substring(charRange2.start, charRange2.end + 1) + "\n\n");
        }
        this.printNice(stringWriter, 0, true);
        String string = stringWriter.toString();
        return new ByteArrayInputStream(string.getBytes());
    }

    public void sendToWriter(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\"?>\n\n");
        LiteXMLElement.charRange charRange2 = this.getDocType(this.docContent, true);
        if (charRange2.isValid()) {
            writer.write(this.docContent.substring(charRange2.start, charRange2.end + 1) + "\n\n");
        }
        this.printNice(writer, 0, true);
    }

    public void sendToStream(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.sendToWriter(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    protected LiteXMLElement.charRange getDocType(String string, boolean bl) {
        LiteXMLElement.charRange charRange2 = new LiteXMLElement.charRange();
        int n = 0;
        int n2 = this.doc.docContent.length() - 1;
        LiteXMLElement.tagRange tagRange2 = this.getTagRanges(string, "!DOCTYPE", new LiteXMLElement.charRange(n, n2));
        if (-1 == n) {
            return charRange2;
        }
        if (!tagRange2.startTag.isValid()) {
            return charRange2;
        }
        if (bl) {
            charRange2 = tagRange2.startTag;
        } else {
            charRange2.start = tagRange2.startTag.start + 1 + "!DOCTYPE".length() - 1 + 1;
            while (charRange2.start < n2 && -1 != " \t\n\r".indexOf(string.charAt(charRange2.start))) {
                ++charRange2.start;
            }
            charRange2.end = charRange2.start;
            while (charRange2.end + 1 < n2 && -1 == " \t\n\r/>".indexOf(string.charAt(charRange2.end + 1))) {
                ++charRange2.end;
            }
        }
        return charRange2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements StructuredDocumentFactory.Instantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{new MimeMediaType("Text", "Xml"), new MimeMediaType("Text", "x-Xml"), new MimeMediaType("Application", "Xml"), new MimeMediaType("Application", "x-Xml")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, String string) {
            return new LiteXMLDocument(mimeMediaType, string);
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, String string, String string2) {
            return new LiteXMLDocument(mimeMediaType, string, string2);
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, InputStream inputStream) throws IOException {
            return new LiteXMLDocument(mimeMediaType, inputStream);
        }
    }
}

