/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.cm.CmCache;
import net.jxta.impl.cm.CmIndexerThread;
import net.jxta.impl.cm.FileExpirationService;
import net.jxta.impl.cm.SchedulerService;
import net.jxta.impl.index.IndexServiceImpl;
import net.jxta.index.IndexService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Cm {
    public static final String RootDirBase = "cm";
    public static final String PublicDirName = "public";
    public static final String PrivateDirName = "private";
    public static final String TmpDirName = "tmp";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$Cm == null ? (class$net$jxta$impl$cm$Cm = Cm.class$("net.jxta.impl.cm.Cm")) : class$net$jxta$impl$cm$Cm).getName());
    private static final Random random = new Random();
    protected static final IndexService indexService = new IndexServiceImpl();
    protected static final SchedulerService schedulerService = new SchedulerService();
    protected Hashtable indexes;
    protected Hashtable caches;
    protected File rootDir;
    private FileExpirationService expirer;
    private String indexFilename;
    private static final int RAW = 0;
    private static final int CACHE = 1;
    private static final int INDEX = 2;
    private int searchMethod;
    private String[] searchType;
    static /* synthetic */ Class class$net$jxta$impl$cm$Cm;

    public Cm(String string, boolean bl) {
        this(string, null, bl);
    }

    public Cm(String string, ExpirationListener expirationListener, boolean bl) {
        block15: {
            File[] fileArray;
            Object object;
            block14: {
                this.indexes = new Hashtable(4);
                this.caches = new Hashtable(4);
                this.indexFilename = "cm.idx";
                this.searchMethod = 0;
                this.searchType = new String[]{"RAW", "CACHE", "INDEX"};
                try {
                    object = ResourceBundle.getBundle("net.jxta.user");
                    fileArray = ((ResourceBundle)object).getString("impl.cm.searchMethod").trim();
                    if (fileArray.equals("RAW")) {
                        this.searchMethod = 0;
                    } else if (fileArray.equals("CACHE")) {
                        this.searchMethod = 1;
                    } else if (fileArray.equals("INDEX")) {
                        this.searchMethod = 2;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)(" Search Method " + this.searchType[this.searchMethod]));
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block14;
                    LOG.warn((Object)"cm search method preference resource not found", (Throwable)missingResourceException);
                }
            }
            try {
                object = new File(RootDirBase);
                fileArray = new File[3];
                FileExpirationService.ExpirationListener expirationListener2 = null;
                this.rootDir = new File((File)object, string);
                this.rootDir = new File(this.rootDir.getCanonicalPath());
                if (this.searchMethod == 2 && bl) {
                    expirationListener2 = new FileExpirationService.ExpirationListener(){

                        /*
                         * Loose catch block
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void expiredAndRemove(File file) {
                            FileInputStream fileInputStream;
                            block19: {
                                IndexService.Index index = (IndexService.Index)Cm.this.indexes.get(new File(file.getParent()).getName());
                                fileInputStream = null;
                                fileInputStream = new FileInputStream(file);
                                if (index != null) {
                                    index.remove(file.getName(), fileInputStream);
                                }
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block19;
                                LOG.debug((Object)(" removing " + file + " from index."));
                            }
                            Object var9_4 = null;
                            if (fileInputStream == null) return;
                            try {
                                ((InputStream)fileInputStream).close();
                                return;
                            }
                            catch (IOException iOException) {}
                            return;
                            {
                                catch (NullPointerException nullPointerException) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"NPE ", (Throwable)nullPointerException);
                                    }
                                    Object var9_5 = null;
                                    if (fileInputStream == null) return;
                                    try {
                                        ((InputStream)fileInputStream).close();
                                        return;
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                                catch (IOException iOException) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"IO Exception ", (Throwable)iOException);
                                    }
                                    Object var9_6 = null;
                                    if (fileInputStream == null) return;
                                    try {
                                        ((InputStream)fileInputStream).close();
                                        return;
                                    }
                                    catch (IOException iOException2) {}
                                    return;
                                }
                                catch (IndexService.BadDocumentException badDocumentException) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"bad doc ", (Throwable)badDocumentException);
                                    }
                                    Object var9_7 = null;
                                    if (fileInputStream == null) return;
                                    try {
                                        ((InputStream)fileInputStream).close();
                                        return;
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                                catch (IndexService.IndexException indexException) {
                                    if (LOG.isEnabledFor(Priority.WARN)) {
                                        LOG.warn((Object)"Index Error ", (Throwable)indexException);
                                    }
                                    Object var9_8 = null;
                                    if (fileInputStream == null) return;
                                    try {
                                        ((InputStream)fileInputStream).close();
                                        return;
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_9 = null;
                                if (fileInputStream == null) throw throwable;
                                try {
                                    ((InputStream)fileInputStream).close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    };
                } else if (this.searchMethod == 1 && bl) {
                    expirationListener2 = new FileExpirationService.ExpirationListener(){

                        public void expiredAndRemove(File file) {
                            CmCache cmCache = (CmCache)Cm.this.caches.get(new File(file.getParent()).getName());
                            cmCache.remove(file.getName());
                        }
                    };
                }
                fileArray[0] = this.initDir(TmpDirName);
                fileArray[1] = this.initDir(PrivateDirName);
                fileArray[2] = this.initDir(PublicDirName);
                this.expirer = new FileExpirationService(schedulerService, this.rootDir, fileArray, expirationListener2);
                if (this.searchMethod == 2 && bl) {
                    new Thread((Runnable)new CmIndexerThread(fileArray, new IndexService.Index[]{(IndexService.Index)this.indexes.get(TmpDirName), (IndexService.Index)this.indexes.get(PrivateDirName), (IndexService.Index)this.indexes.get(PublicDirName)}), "CmIndexerThread :" + string).start();
                }
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block15;
                LOG.warn((Object)"Unable to create Cm", (Throwable)iOException);
            }
        }
    }

    public static String createTmpName(StructuredDocument structuredDocument) {
        int n = 0;
        try {
            StringWriter stringWriter = new StringWriter();
            ((StructuredTextDocument)structuredDocument).sendToWriter(stringWriter);
            n = stringWriter.toString().hashCode();
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RootDirBase + Integer.toString(n);
    }

    public long getExpirationTime(String string, String string2) {
        File file = this.getFile(string, string2);
        long l = this.expirer.getExpirationTime(file);
        if (l == -1L) {
            return 0L;
        }
        return l - System.currentTimeMillis();
    }

    public String[] getFileNames(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(this.rootDir, string);
        return file.list();
    }

    public String getOldestFile(String string) {
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"nul directory name");
            }
            return null;
        }
        try {
            File file = new File(this.rootDir, string);
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no files in folder");
                }
                return null;
            }
            long l = fileArray[0].lastModified();
            File file2 = fileArray[0];
            File file3 = null;
            long l2 = 0L;
            int n = 1;
            while (n < fileArray.length) {
                file3 = fileArray[n];
                l2 = file3.lastModified();
                if (l2 < l) {
                    file2 = fileArray[n];
                    l = l2;
                }
                ++n;
            }
            return file2.getName();
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.debug((Object)"Failure determining oldest file", (Throwable)exception);
            }
            return null;
        }
    }

    public boolean isFolder(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(this.rootDir, string);
        return file.exists() && file.isDirectory();
    }

    public FileInputStream getInputStream(String string, String string2) throws IOException {
        return new FileInputStream(this.getFile(string, string2));
    }

    public void createFolder(String string) throws IOException {
        this.createFolder(string, null);
    }

    public synchronized void createFolder(String string, String[] stringArray) throws IOException {
        File file = this.initDir(string);
        this.expirer.addDocDir(file);
        switch (this.searchMethod) {
            case 0: {
                break;
            }
            case 2: {
                if (this.indexes.get(string) != null) break;
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Creating indexer threads with null index");
                }
                new Thread((Runnable)new CmIndexerThread(new File[]{file}, new IndexService.Index[]{(IndexService.Index)this.indexes.get(string)}), "CmIndexerThread: " + string).start();
                break;
            }
            case 1: {
                if (stringArray == null || this.caches.get(string) != null) break;
                CmCache cmCache = new CmCache(stringArray, file);
                this.caches.put(string, cmCache);
                new Thread((Runnable)cmCache, string + " CmCache ").start();
                break;
            }
        }
    }

    public String createTmpName(String string) {
        String string2;
        File file = new File(this.rootDir, string);
        while (new File(file, string2 = RootDirBase + Integer.toString(random.nextInt())).exists()) {
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public void remove(String var1_1, String var2_2) throws IOException {
        var3_3 = this.getFile(var1_1, var2_2);
        try {
            block22: {
                this.expirer.cancelFileExpiration(var3_3);
                if (this.searchMethod == 2) {
                    var4_4 = null;
                    try {
                        var4_4 = new FileInputStream(var3_3);
                        ((IndexService.Index)this.indexes.get(var1_1)).remove(var2_2, var4_4);
                        var8_5 = null;
                        ** if (var4_4 == null) goto lbl-1000
                    }
                    catch (Throwable var7_15) {
                        var8_8 = null;
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var9_12) {
                                // empty catch block
                            }
                        }
                        throw var7_15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var4_4.close();
                        }
                        catch (IOException var9_9) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                        catch (IndexService.BadDocumentException var5_13) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"bad file ", (Throwable)var5_13);
                            }
                            var8_6 = null;
                            if (var4_4 != null) {
                                try {
                                    var4_4.close();
                                }
                                catch (IOException var9_10) {}
                            }
                            break block22;
                        }
                        catch (IndexService.IndexException var6_14) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index Exception", (Throwable)var6_14);
                            }
                            var8_7 = null;
                            if (var4_4 != null) {
                                try {
                                    var4_4.close();
                                }
                                catch (IOException var9_11) {}
                            }
                            break block22;
                        }
                    }
                }
                if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(var1_1)).remove(var2_2);
                }
            }
            var11_16 = null;
            ** if (var3_3.delete()) goto lbl-1000
        }
        catch (Throwable var10_18) {
            var11_17 = null;
            if (!var3_3.delete()) {
                throw new IOException("Cm cannot remove the file " + var3_3);
            }
            throw var10_18;
        }
lbl-1000:
        // 1 sources

        {
            throw new IOException("Cm cannot remove the file " + var3_3);
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public boolean exists(String string, String string2) throws IOException {
        File file = this.getFile(string, string2);
        return file.exists();
    }

    public StructuredDocument restore(String string, String string2) throws IOException {
        File file = this.getFile(string, string2);
        return this.restoreFile(file);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] restoreBytes(String var1_1, String var2_2) throws IOException {
        block9: {
            var3_3 = this.getFile(var1_1, var2_2);
            var4_4 = null;
            var5_5 = null;
            try {
                var4_4 = new FileInputStream(var3_3);
                var6_6 = (int)var3_3.length();
                var5_5 = new byte[var6_6];
                var7_7 = 0;
                while (true) {
                    if (var7_7 >= var6_6) {
                        break block9;
                    }
                    var8_8 = var4_4.read(var5_5, var7_7, var6_6 - var7_7);
                    if (-1 == var8_8) {
                        var4_4.close();
                        var9_9 = null;
                        var11_10 = null;
                        if (var4_4 == null) return var9_9;
                        break;
                    }
                    var7_7 += var8_8;
                }
            }
            catch (Throwable var10_16) {
                var11_12 = null;
                if (var4_4 == null) throw var10_16;
                try {
                    var4_4.close();
                    throw var10_16;
                }
                catch (IOException var12_15) {
                    // empty catch block
                }
                throw var10_16;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 113->121)] { 
lbl35:
            // 1 sources

            var4_4.close();
            return var9_9;
lbl37:
            // 1 sources

            catch (IOException var12_13) {
                // empty catch block
            }
            return var9_9;
        }
        var11_11 = null;
        if (var4_4 == null) return var5_5;
        try {}
        catch (IOException var12_14) {
            return var5_5;
        }
        var4_4.close();
        return var5_5;
    }

    public void save(String string, String string2, StructuredDocument structuredDocument) throws IOException {
        this.save(string, string2, structuredDocument, 1471228928L, 0x6DDD00L);
    }

    /*
     * Unable to fully structure code
     */
    public void save(String var1_1, String var2_2, StructuredDocument var3_3, long var4_4, long var6_5) throws IOException {
        block37: {
            block36: {
                var8_6 = this.getFile(var1_1, var2_2);
                if (this.searchMethod == 2 && var8_6.exists()) {
                    var9_7 = null;
                    try {
                        var9_7 = new FileInputStream(var8_6);
                        ((IndexService.Index)this.indexes.get(var1_1)).remove(var2_2, (InputStream)var9_7);
                        var13_8 = null;
                        ** if (var9_7 == null) goto lbl-1000
                    }
                    catch (Throwable var12_22) {
                        var13_11 = null;
                        if (var9_7 != null) {
                            try {
                                var9_7.close();
                            }
                            catch (IOException var14_15) {
                                // empty catch block
                            }
                        }
                        throw var12_22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var9_7.close();
                        }
                        catch (IOException var14_12) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block36;
                        catch (IndexService.BadDocumentException var10_16) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Bad Document", (Throwable)var10_16);
                            }
                            var13_9 = null;
                            if (var9_7 != null) {
                                try {
                                    var9_7.close();
                                }
                                catch (IOException var14_13) {}
                            }
                            break block36;
                        }
                        catch (IndexService.IndexException var11_20) {
                            if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                                Cm.LOG.warn((Object)"Index : Index Exception", (Throwable)var11_20);
                            }
                            var13_10 = null;
                            if (var9_7 != null) {
                                try {
                                    var9_7.close();
                                }
                                catch (IOException var14_14) {}
                            }
                        }
                    }
                }
            }
            var9_7 = null;
            try {
                var9_7 = new FileOutputStream(var8_6);
                var3_3.sendToStream((OutputStream)var9_7);
                var9_7.close();
                var9_7 = null;
                if (this.searchMethod == 2) {
                    try {
                        if (Cm.LOG.isDebugEnabled() && Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                            Cm.LOG.debug((Object)("indexing " + var8_6 + ": " + var1_1 + " " + var2_2));
                        }
                        ((IndexService.Index)this.indexes.get(var1_1)).add(var2_2, var3_3.getStream());
                    }
                    catch (IOException var10_17) {
                        if (Cm.LOG.isEnabledFor(Priority.WARN)) {
                            Cm.LOG.warn((Object)"Index : IO Exception", (Throwable)var10_17);
                        }
                        throw var10_17;
                    }
                    catch (IndexService.BadDocumentException var11_21) {
                        if (!Cm.LOG.isEnabledFor(Priority.WARN)) ** GOTO lbl76
                        Cm.LOG.warn((Object)"Save failed", (Throwable)var11_21);
                    }
                    catch (IndexService.IndexException var12_23) {
                        if (!Cm.LOG.isEnabledFor(Priority.WARN)) ** GOTO lbl76
                        Cm.LOG.warn((Object)"Save failed", (Throwable)var12_23);
                    }
                } else if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(var1_1)).add(var2_2, var3_3);
                }
lbl76:
                // 8 sources

                var10_18 = System.currentTimeMillis();
                this.expirer.scheduleFileExpiration(var8_6, var10_18 + var4_4, var6_5);
                var16_24 = null;
                ** if (var9_7 == null) goto lbl-1000
            }
            catch (Throwable var15_28) {
                var16_25 = null;
                if (var9_7 != null) {
                    try {
                        var9_7.close();
                    }
                    catch (IOException var17_27) {
                        // empty catch block
                    }
                }
                throw var15_28;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var9_7.close();
                }
                catch (IOException var17_26) {}
            }
lbl-1000:
            // 2 sources

            {
                break block37;
                catch (IOException var10_19) {
                    if (Cm.LOG.isEnabledFor(Priority.DEBUG)) {
                        Cm.LOG.debug((Object)"Cm cannot write doc", (Throwable)var10_19);
                    }
                    throw var10_19;
                }
            }
        }
    }

    public void saveBytes(String string, String string2, byte[] byArray) throws IOException {
        this.saveBytes(string, string2, byArray, -1L, -1L);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveBytes(String string, String string2, byte[] byArray, long l, long l2) throws IOException {
        FileOutputStream fileOutputStream;
        block16: {
            File file = this.getFile(string, string2);
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            if (this.searchMethod == 2) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    ((IndexService.Index)this.indexes.get(string)).add(string2, byteArrayInputStream);
                }
                catch (IOException iOException) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Index : IO Exception", (Throwable)iOException);
                    }
                }
                catch (IndexService.BadDocumentException badDocumentException) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Index : Bad Document", (Throwable)badDocumentException);
                    }
                }
                catch (IndexService.IndexException indexException) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block16;
                    LOG.warn((Object)"Index : Index Exception", (Throwable)indexException);
                }
            }
        }
        Object var15_13 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cm cannot write doc");
                }
                Object var15_14 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void saveBytes(String string, String string2, InputStream inputStream) throws IOException {
        this.saveBytes(string, string2, inputStream, -1L, -1L);
    }

    /*
     * Loose catch block
     */
    public void saveBytes(String string, String string2, InputStream inputStream, long l, long l2) throws IOException {
        block32: {
            IOException iOException3222;
            FileOutputStream fileOutputStream;
            block30: {
                File file;
                block29: {
                    file = this.getFile(string, string2);
                    fileOutputStream = null;
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[4096];
                    while (true) {
                        int n;
                        if ((n = inputStream.read(byArray)) == 0) {
                            continue;
                        }
                        if (n == -1) break;
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                    inputStream.close();
                    inputStream = new FileInputStream(file);
                    if (this.searchMethod == 2) {
                        try {
                            ((IndexService.Index)this.indexes.get(string)).add(string2, inputStream);
                        }
                        catch (IOException iOException2) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : IO Exception", (Throwable)iOException2);
                            }
                            break block29;
                        }
                        catch (IndexService.BadDocumentException badDocumentException) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Bad Document", (Throwable)badDocumentException);
                            }
                            break block29;
                        }
                        catch (IndexService.IndexException indexException) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Index : Index Error", (Throwable)indexException);
                            }
                            break block29;
                        }
                    }
                    if (this.searchMethod == 1) {
                        ((CmCache)this.caches.get(string)).add(string2);
                    }
                }
                this.expirer.scheduleFileExpiration(file, System.currentTimeMillis() + l, l2);
                Object var15_14 = null;
                if (inputStream == null) break block30;
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (IOException iOException3222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (IOException iOException3222) {}
            }
            break block32;
            {
                catch (IOException iOException4) {
                    IOException iOException52222;
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Cm cannot write doc", (Throwable)iOException4);
                    }
                    Object var15_15 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                            inputStream = null;
                        }
                        catch (IOException iOException52222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                            fileOutputStream = null;
                        }
                        catch (IOException iOException52222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException62222;
                Object var15_16 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException62222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void cleanupFolder(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)(" cleaning up " + string));
        }
        File file = new File(this.rootDir, string);
        String[] stringArray = this.getFileNames(string);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (!file2.delete() && LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("  failed removing " + stringArray[n]));
            }
            ++n;
        }
    }

    public Enumeration search(String string, String string2, String string3) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        if (this.searchMethod == 2 && string3.indexOf("*") == -1) {
            object = this.searchIndex(string, string2, string3);
            if (object == null) {
                return vector.elements();
            }
            if (((Object)object).length > 0) {
                int n = 0;
                while (n < ((Object)object).length) {
                    if (null != object[n]) {
                        vector.addElement(object[n]);
                    } else if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"There was a null element in the index results");
                    }
                    ++n;
                }
                return vector.elements();
            }
        } else if (this.searchMethod == 1 && ((CmCache)(object = (CmCache)this.caches.get(string))).containsKey(string2)) {
            return ((CmCache)object).query(string2, string3);
        }
        if ((object = this.getFileNames(string)) == null) {
            return vector.elements();
        }
        int n = 0;
        while (n < ((Object)object).length) {
            if (this.searchFile(string, (String)object[n], string2, string3)) {
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("found a hit " + (String)object[n]));
                }
                vector.addElement(object[n]);
            }
            ++n;
        }
        return vector.elements();
    }

    File getFile(String string, String string2) {
        File file = new File(this.rootDir, string);
        if (!file.exists()) {
            file.mkdirs();
            this.expirer.addDocDir(file);
        }
        return new File(file, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StructuredDocument restoreFile(File file) throws IOException {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("restore document from " + file));
        }
        FileInputStream fileInputStream = null;
        StructuredDocument structuredDocument = null;
        try {
            fileInputStream = new FileInputStream(file);
            structuredDocument = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), fileInputStream);
            Object var5_4 = null;
            if (fileInputStream == null) return structuredDocument;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
            return structuredDocument;
        }
        catch (IOException iOException) {}
        return structuredDocument;
    }

    private File initDir(String string) throws IOException {
        File file;
        block5: {
            file = new File(this.rootDir, string);
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Cm cannot create directory " + file);
            }
            if (this.searchMethod == 2 && !this.indexes.containsKey(string)) {
                try {
                    this.indexes.put(string, indexService.getIndex(new File(file.getAbsolutePath(), this.indexFilename)));
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Creating index " + string));
                    }
                }
                catch (IOException iOException) {
                    if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.WARN)) break block5;
                    LOG.warn((Object)("Failed to create index " + iOException));
                }
            }
        }
        return file;
    }

    private String[] searchIndex(String string, String string2, String string3) {
        block6: {
            if (this.searchMethod != 2) {
                return null;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Looking for " + string2 + " = " + string3 + " in " + string + "Rootdir = " + this.rootDir.toString()));
            }
            String string4 = "//[" + string2 + "='" + string3 + "']";
            try {
                IndexService.Index index = (IndexService.Index)this.indexes.get(string);
                String[] stringArray = index.query(string4);
                return stringArray;
            }
            catch (IndexService.BadQueryException badQueryException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"bad query expression ", (Throwable)badQueryException);
                }
            }
            catch (IndexService.IndexException indexException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                LOG.warn((Object)"bad index", (Throwable)indexException);
            }
        }
        return null;
    }

    private synchronized void indexFile(String string, String string2, StructuredDocument structuredDocument) {
        block7: {
            if (this.searchMethod != 2) {
                return;
            }
            try {
                ((IndexService.Index)this.indexes.get(string)).add(string2, structuredDocument.getStream());
            }
            catch (IndexService.BadDocumentException badDocumentException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Bad Document", (Throwable)badDocumentException);
                }
            }
            catch (IndexService.IndexException indexException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Index : Index Exception", (Throwable)indexException);
                }
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block7;
                LOG.warn((Object)"Index : IO Failure", (Throwable)iOException);
            }
        }
    }

    private boolean searchFile(String string, String string2, String string3, String string4) {
        boolean bl = false;
        boolean bl2 = false;
        StructuredDocument structuredDocument = null;
        try {
            structuredDocument = this.restore(string, string2);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("searchFile failed restoring doc: " + exception));
            }
            return false;
        }
        if (structuredDocument == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"searchFile failed restoring doc: doc is null");
            }
            return false;
        }
        try {
            Element element = null;
            Enumeration enumeration = structuredDocument.getChildren();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"searchFile failed restoring doc: doc has no element");
                }
                return false;
            }
            String string5 = string3.toUpperCase();
            while (enumeration.hasMoreElements()) {
                element = (Element)enumeration.nextElement();
                if (!((String)element.getKey()).toUpperCase().equals(string5)) continue;
                Object object = element.getValue();
                if (!string4.getClass().isInstance(object) || string4.length() < 1) continue;
                if (string4.charAt(0) == '*') {
                    bl2 = true;
                    string4 = string4.substring(1, string4.length());
                }
                if (string4.charAt(string4.length() - 1) == '*') {
                    bl = true;
                    string4 = string4.substring(0, string4.indexOf("*"));
                }
                if (string4.length() == 0) {
                    return false;
                }
                String string6 = ((String)object).toUpperCase();
                String string7 = string4.toUpperCase();
                if (bl && !bl2) {
                    return string6.startsWith(string7);
                }
                if (bl2 && !bl) {
                    return string6.endsWith(string7);
                }
                if (bl && bl2) {
                    return string6.indexOf(string7) >= 0;
                }
                return string6.equals(string7);
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"searchFile has failed: ", (Throwable)exception);
            }
            return false;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        new Thread((Runnable)schedulerService, "SchedulerService").start();
    }

    public static interface ExpirationListener {
        public void expired(String var1, String var2, long var3);
    }
}

