/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.MissingResourceException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.util.ClassFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class StructuredDocumentFactory
extends ClassFactory {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$document$StructuredDocumentFactory == null ? (class$net$jxta$document$StructuredDocumentFactory = StructuredDocumentFactory.class$("net.jxta.document.StructuredDocumentFactory")) : class$net$jxta$document$StructuredDocumentFactory).getName());
    private static StructuredDocumentFactory factory = new StructuredDocumentFactory();
    private Hashtable encodings = new Hashtable();
    private HashMap extToMime = new HashMap();
    private HashMap mimeToExt = new HashMap();
    private boolean loadedProperty = false;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocumentFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocumentFactory$Instantiator;

    private StructuredDocumentFactory() {
    }

    private boolean doLoadProperty() {
        try {
            return this.registerFromResources("net.jxta.impl.config", "StructuredDocumentInstanceTypes");
        }
        catch (MissingResourceException missingResourceException) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Could not find net.jxta.impl.config properties file!");
            }
            return false;
        }
    }

    protected Hashtable getAssocTable() {
        return this.encodings;
    }

    protected Class getClassForKey() {
        return class$java$lang$String == null ? (class$java$lang$String = StructuredDocumentFactory.class$("java.lang.String")) : class$java$lang$String;
    }

    protected Class getClassOfInstantiators() {
        return class$net$jxta$document$StructuredDocumentFactory$Instantiator == null ? (class$net$jxta$document$StructuredDocumentFactory$Instantiator = StructuredDocumentFactory.class$("net.jxta.document.StructuredDocumentFactory$Instantiator")) : class$net$jxta$document$StructuredDocumentFactory$Instantiator;
    }

    protected boolean registerAssoc(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                Class<?> clazz = Class.forName(string);
                Instantiator instantiator = (Instantiator)clazz.getField("INSTANTIATOR").get(null);
                MimeMediaType[] mimeMediaTypeArray = instantiator.getSupportedMimeTypes();
                int n = 0;
                while (n < mimeMediaTypeArray.length) {
                    bl |= StructuredDocumentFactory.registerInstantiator(mimeMediaTypeArray[n], instantiator);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("Failed to register '" + string + "'"), (Throwable)exception);
            }
        }
        return bl;
    }

    public static String getFileExtensionForMimeType(MimeMediaType mimeMediaType) {
        return (String)StructuredDocumentFactory.factory.mimeToExt.get(mimeMediaType.getMimeMediaType());
    }

    public static MimeMediaType getMimeTypeForFileExtension(String string) {
        MimeMediaType mimeMediaType = null;
        String string2 = (String)StructuredDocumentFactory.factory.extToMime.get(string);
        if (null != string2) {
            mimeMediaType = new MimeMediaType(string2);
        }
        return mimeMediaType;
    }

    public static boolean registerInstantiator(MimeMediaType mimeMediaType, Instantiator instantiator) {
        boolean bl = factory.registerAssoc(mimeMediaType.getMimeMediaType(), instantiator);
        if (bl) {
            Instantiator.ExtensionMapping[] extensionMappingArray = instantiator.getSupportedFileExtensions();
            int n = 0;
            while (n < extensionMappingArray.length) {
                if (null != extensionMappingArray[n].getMimeMediaType()) {
                    StructuredDocumentFactory.factory.extToMime.put(extensionMappingArray[n].getExtension(), extensionMappingArray[n].getMimeMediaType().getMimeMediaType());
                    StructuredDocumentFactory.factory.mimeToExt.put(extensionMappingArray[n].getMimeMediaType().getMimeMediaType(), extensionMappingArray[n].getExtension());
                }
                ++n;
            }
        }
        return bl;
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimeMediaType, String string) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimeMediaType.getMimeMediaType());
        return instantiator.newInstance(mimeMediaType, string);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimeMediaType, String string, String string2) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimeMediaType.getMimeMediaType());
        return instantiator.newInstance(mimeMediaType, string, string2);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimeMediaType, InputStream inputStream) throws IOException {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimeMediaType.getMimeMediaType());
        return instantiator.newInstance(mimeMediaType, inputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public ExtensionMapping[] getSupportedFileExtensions();

        public StructuredDocument newInstance(MimeMediaType var1, String var2);

        public StructuredDocument newInstance(MimeMediaType var1, String var2, String var3);

        public StructuredDocument newInstance(MimeMediaType var1, InputStream var2) throws IOException;

        public static class ExtensionMapping {
            String extension;
            MimeMediaType mimetype;

            private ExtensionMapping() {
            }

            public ExtensionMapping(String string, MimeMediaType mimeMediaType) {
                this.extension = string;
                this.mimetype = mimeMediaType;
            }

            protected Object clone() {
                return this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object instanceof ExtensionMapping) {
                    ExtensionMapping extensionMapping = (ExtensionMapping)object;
                    return this.extension.equals(extensionMapping.extension) && this.mimetype.equals(extensionMapping.mimetype);
                }
                return false;
            }

            public int hascode() {
                return this.extension.hashCode() ^ this.mimetype.hashCode();
            }

            public String toString() {
                return this.extension.toString() + " -> " + this.mimetype.toString();
            }

            public String getExtension() {
                return this.extension;
            }

            public MimeMediaType getMimeMediaType() {
                return this.mimetype;
            }
        }
    }
}

