/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.reputation.talon.implementations;

import org.openprivacy.sierra.reputation.talon.components.Payload;
import talon.BaseComponent;
import talon.util.net.URI;

public class OverallMarkupPayload
extends BaseComponent
implements Payload {
    public static final float OPTION_UNRATED = -1.0f;
    public static final float OPTION_TERRIBLE = 0.0f;
    public static final float OPTION_BAD = 1.0f;
    public static final float OPTION_AVERAGE = 2.0f;
    public static final float OPTION_GOOD = 3.0f;
    public static final float OPTION_EXCELLENT = 4.0f;
    public static final URI IDENTIFIER = new URI("http://schemas.openprivacy.org/reputation/markup/overall");
    private URI identifier;
    private float option = -1.0f;

    public void init() {
        this.setIdentifier(IDENTIFIER);
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(URI identifier) {
        this.identifier = identifier;
    }

    public byte[] getCanonicalFormat() {
        return Float.toString(this.getOption()).getBytes();
    }

    public float getOption() {
        return this.option;
    }

    public void setOption(float option) {
        this.option = option;
    }

    public String toString() {
        int value = (int)this.getOption();
        String human = "";
        switch (value) {
            case -1: {
                human = "Unrated";
                break;
            }
            case 0: {
                human = "Terrible";
                break;
            }
            case 1: {
                human = "Bad";
                break;
            }
            case 2: {
                human = "Average";
                break;
            }
            case 3: {
                human = "Good";
                break;
            }
            case 4: {
                human = "Excellent";
                break;
            }
            default: {
                human = "Unknown";
            }
        }
        return human + " ( " + this.getOption() + " )";
    }
}

