/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.security.AccessController;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import tyrex.tm.EnlistedResource;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TransactionImpl;
import tyrex.tm.TyrexPermission;
import tyrex.tm.TyrexTransactionManager;
import tyrex.util.FastThreadLocal;
import tyrex.util.Messages;

final class TransactionManagerImpl
implements TransactionManager,
Status,
TyrexTransactionManager {
    private static FastThreadLocal _txLocal = new FastThreadLocal();
    private TransactionDomain _txDomain;

    TransactionManagerImpl(TransactionDomain transactionDomain) {
        if (transactionDomain == null) {
            throw new IllegalArgumentException("Argument 'txDomain' is null");
        }
        this._txDomain = transactionDomain;
    }

    public void begin() throws NotSupportedException, SystemException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null) {
            threadResources = new ThreadResources();
            _txLocal.set(threadResources);
            threadResources.tx = this._txDomain.createTransaction(null, Thread.currentThread());
        } else {
            if (threadResources.tx != null && threadResources.tx.getStatus() != 3 && threadResources.tx.getStatus() != 4) {
                if (!this._txDomain.getNestedTransactions()) {
                    throw new NotSupportedException(Messages.message("tyrex.tx.noNested"));
                }
                threadResources.tx = this._txDomain.createTransaction(threadResources.tx, null);
                return;
            }
            threadResources.tx = this._txDomain.createTransaction(null, Thread.currentThread());
        }
        this.enlistResources(threadResources.tx, threadResources.xaList);
        this.enlistResources(threadResources.tx, threadResources.enlistedXAList);
        if (threadResources.enlistedList != null) {
            int n = 0;
            while (n < threadResources.enlistedList.length) {
                threadResources.enlistedList[n].enlisted(threadResources.tx);
                ++n;
            }
        }
        try {
            class Tyrex_tm_TransactionManagerImpl$1 {
                /* synthetic */ Tyrex_tm_TransactionManagerImpl$1() {
                }
            }
            threadResources.tx.registerSynchronization(new TransactionManagerSynchronization());
        }
        catch (RollbackException rollbackException) {
            throw new SystemException(rollbackException.toString());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        try {
            threadResources.tx.getTopLevel().commit();
        }
        finally {
            Object var5_2 = null;
            threadResources.tx = null;
        }
    }

    private void delist(ThreadResources threadResources) {
        if (threadResources.enlistedList != null) {
            int n = 0;
            while (n < threadResources.enlistedList.length) {
                try {
                    threadResources.enlistedList[n].delisted();
                }
                catch (Exception exception) {}
                ++n;
            }
            threadResources.enlistedList = null;
            threadResources.enlistedXAList = null;
        }
    }

    public void delistResource(XAResource xAResource) throws SystemException, RollbackException {
        this.delistResource(xAResource, Thread.currentThread());
    }

    public void delistResource(XAResource xAResource, Thread thread) throws SystemException, RollbackException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get(thread);
        if (threadResources != null) {
            threadResources.remove(xAResource);
            if (threadResources.tx != null) {
                threadResources.tx.getTopLevel().delistResource(xAResource, 0x4000000);
            }
        }
    }

    public void delistResource(XAResource xAResource, EnlistedResource enlistedResource) throws SystemException, RollbackException {
        this.delistResource(xAResource, enlistedResource, Thread.currentThread());
    }

    public void delistResource(XAResource xAResource, EnlistedResource enlistedResource, Thread thread) throws SystemException, RollbackException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get(thread);
        if (threadResources != null) {
            if (threadResources.tx != null) {
                threadResources.tx.getTopLevel().delistResource(xAResource, 0x4000000);
            }
            threadResources.remove(xAResource, enlistedResource);
        }
    }

    public void discardResource(XAResource xAResource) {
        block3: {
            ThreadResources threadResources = (ThreadResources)_txLocal.get();
            if (threadResources == null) break block3;
            threadResources.remove(xAResource);
            if (threadResources.tx != null) {
                try {
                    threadResources.tx.getTopLevel().delistResource(xAResource, 0x20000000);
                }
                catch (SystemException systemException) {}
            }
        }
    }

    public void discardResource(XAResource xAResource, EnlistedResource enlistedResource) {
        block5: {
            ThreadResources threadResources = (ThreadResources)_txLocal.get();
            if (threadResources == null) break block5;
            try {
                threadResources.remove(xAResource, enlistedResource);
            }
            catch (SystemException systemException) {}
            if (threadResources.tx != null) {
                try {
                    threadResources.tx.getTopLevel().delistResource(xAResource, 0x20000000);
                }
                catch (SystemException systemException) {}
            }
        }
    }

    public void enlistResource(XAResource xAResource) throws SystemException, RollbackException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null) {
            threadResources = new ThreadResources();
            _txLocal.set(threadResources);
        }
        if (threadResources.tx != null) {
            threadResources.tx.getTopLevel().enlistResource(xAResource);
        }
        threadResources.add(xAResource);
    }

    public void enlistResource(XAResource xAResource, EnlistedResource enlistedResource) throws SystemException, RollbackException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null) {
            threadResources = new ThreadResources();
            _txLocal.set(threadResources);
        }
        if (threadResources.tx != null) {
            threadResources.tx.getTopLevel().enlistResource(xAResource);
        }
        threadResources.add(xAResource, enlistedResource);
        if (threadResources.tx != null) {
            enlistedResource.enlisted(threadResources.tx.getTopLevel());
        }
    }

    private void enlistResources(Transaction transaction, XAResource[] xAResourceArray) throws SystemException {
        if (xAResourceArray != null) {
            try {
                int n = 0;
                while (n < xAResourceArray.length) {
                    transaction.enlistResource(xAResourceArray[n]);
                    ++n;
                }
            }
            catch (Exception exception) {
                try {
                    this.rollback();
                }
                catch (Exception exception2) {}
                if (exception instanceof SystemException) {
                    throw (SystemException)((Object)exception);
                }
                throw new SystemException(exception.toString());
            }
        }
    }

    public int getStatus() {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            return 6;
        }
        return threadResources.tx.getStatus();
    }

    public Transaction getTransaction() {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            return null;
        }
        return threadResources.tx.getTopLevel();
    }

    Transaction getTransaction(Thread thread) {
        ThreadResources threadResources = (ThreadResources)_txLocal.get(thread);
        return threadResources == null ? null : threadResources.tx.getTopLevel();
    }

    void internalResume(TransactionImpl transactionImpl, boolean bl) throws InvalidTransactionException, IllegalStateException, SystemException {
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            if (transactionImpl.getTimedOut()) {
                throw new InvalidTransactionException(Messages.message("tyrex.tx.timedOut"));
            }
            ThreadResources threadResources = (ThreadResources)_txLocal.get();
            if (threadResources != null && threadResources.tx != null) {
                throw new IllegalStateException(Messages.message("tyrex.tx.resumeOverload"));
            }
            if (threadResources == null) {
                threadResources = new ThreadResources();
                _txLocal.set(threadResources);
            }
            threadResources.tx = transactionImpl;
            TransactionImpl transactionImpl3 = threadResources.tx.getTopLevel();
            if (bl) {
                try {
                    transactionImpl3.resumeAndEnlistResources(threadResources.xaList);
                }
                catch (RollbackException rollbackException) {}
            }
            this._txDomain.enlistThread(transactionImpl3, Thread.currentThread());
        }
    }

    public void recycleThread() throws RollbackException {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources != null) {
            TransactionImpl transactionImpl = threadResources.tx;
            if (transactionImpl != null) {
                if ((transactionImpl = transactionImpl.getTopLevel()).getStatus() == 0 || transactionImpl.getStatus() == 1) {
                    try {
                        transactionImpl.rollback();
                    }
                    catch (SystemException systemException) {}
                    _txLocal.set(null);
                    throw new RollbackException(Messages.message("tyrex.tx.recycleThreadRollback"));
                }
                this._txDomain.delistThread(transactionImpl, Thread.currentThread());
            }
            _txLocal.set(null);
        }
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        if (!(transaction instanceof TransactionImpl)) {
            throw new InvalidTransactionException(Messages.message("tyrex.tx.resumeForeign"));
        }
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            int n = transaction.getStatus();
            if (n != 0 && n != 1) {
                throw new InvalidTransactionException(Messages.message("tyrex.tx.inactive"));
            }
            this.internalResume((TransactionImpl)transaction, true);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        try {
            threadResources.tx.getTopLevel().rollback();
        }
        finally {
            Object var5_2 = null;
            threadResources.tx = null;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            throw new IllegalStateException(Messages.message("tyrex.tx.inactive"));
        }
        threadResources.tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.message("tyrex.tx.timeNegative"));
        }
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources != null && threadResources.tx != null) {
            this._txDomain.setTransactionTimeout(threadResources.tx.getTopLevel(), n);
        }
    }

    public Transaction suspend() {
        AccessController.checkPermission(TyrexPermission.Transaction.Manager);
        ThreadResources threadResources = (ThreadResources)_txLocal.get();
        if (threadResources == null || threadResources.tx == null) {
            return null;
        }
        TransactionImpl transactionImpl = threadResources.tx.getTopLevel();
        threadResources.tx = null;
        TransactionImpl transactionImpl2 = transactionImpl;
        synchronized (transactionImpl2) {
            this._txDomain.delistThread(transactionImpl, Thread.currentThread());
            if (transactionImpl.getStatus() == 0 || transactionImpl.getStatus() == 1) {
                try {
                    transactionImpl.suspendResources();
                }
                catch (SystemException systemException) {}
                this.delist(threadResources);
                TransactionImpl transactionImpl3 = transactionImpl;
                Object var6_6 = null;
                return transactionImpl3;
            }
            Transaction transaction = null;
            Object var6_7 = null;
            return transaction;
        }
    }

    private void transactionComplete() {
        ThreadResources threadResources = (ThreadResources)_txLocal.get(Thread.currentThread());
        if (threadResources != null) {
            TransactionImpl transactionImpl = threadResources.tx;
            if (transactionImpl != null) {
                threadResources.tx = transactionImpl.getParent();
            }
            this.delist(threadResources);
        }
    }

    class TransactionManagerSynchronization
    implements Synchronization {
        private TransactionManagerSynchronization() {
        }

        public void afterCompletion(int n) {
            TransactionManagerImpl.this.transactionComplete();
        }

        public void beforeCompletion() {
        }
    }

    static class ThreadResources {
        TransactionImpl tx;
        XAResource[] xaList;
        XAResource[] enlistedXAList;
        EnlistedResource[] enlistedList;

        ThreadResources() {
        }

        void add(XAResource xAResource) {
            if (this.xaList == null) {
                this.xaList = new XAResource[1];
                this.xaList[0] = xAResource;
            } else {
                int n = 0;
                while (n < this.xaList.length) {
                    if (this.xaList[n] == xAResource) {
                        return;
                    }
                    ++n;
                }
                XAResource[] xAResourceArray = new XAResource[this.xaList.length + 1];
                System.arraycopy(this.xaList, 0, xAResourceArray, 0, this.xaList.length);
                xAResourceArray[this.xaList.length] = xAResource;
                this.xaList = xAResourceArray;
            }
        }

        void add(XAResource xAResource, EnlistedResource enlistedResource) throws SystemException {
            if (this.enlistedList == null) {
                this.enlistedList = new EnlistedResource[1];
                this.enlistedXAList = new XAResource[1];
                this.enlistedList[0] = enlistedResource;
                this.enlistedXAList[0] = xAResource;
            } else {
                int n = 0;
                while (n < this.enlistedList.length) {
                    if (this.enlistedList[n] == enlistedResource) {
                        if (this.enlistedXAList[n] != xAResource) {
                            throw new SystemException("The xa resource <" + xAResource + "> does not match the existing xa resource <" + this.enlistedXAList[n] + "> for the enlisted resource <" + enlistedResource + ">.");
                        }
                        return;
                    }
                    ++n;
                }
                EnlistedResource[] enlistedResourceArray = new EnlistedResource[this.enlistedList.length + 1];
                System.arraycopy(this.enlistedList, 0, enlistedResourceArray, 0, this.enlistedList.length);
                enlistedResourceArray[this.enlistedList.length] = enlistedResource;
                this.enlistedList = enlistedResourceArray;
                XAResource[] xAResourceArray = new XAResource[this.enlistedXAList.length + 1];
                System.arraycopy(this.enlistedXAList, 0, xAResourceArray, 0, this.enlistedXAList.length);
                xAResourceArray[this.enlistedXAList.length] = xAResource;
                this.enlistedXAList = xAResourceArray;
            }
        }

        void remove(XAResource xAResource) {
            XAResource[] xAResourceArray;
            int n;
            if (this.xaList != null) {
                if (this.xaList.length == 1 && this.xaList[0] == xAResource) {
                    this.xaList = null;
                } else {
                    n = 0;
                    while (n < this.xaList.length) {
                        if (this.xaList[n] == xAResource) {
                            this.xaList[n] = this.xaList[this.xaList.length - 1];
                            xAResourceArray = new XAResource[this.xaList.length - 1];
                            System.arraycopy(this.xaList, 0, xAResourceArray, 0, this.xaList.length - 1);
                            this.xaList = xAResourceArray;
                        }
                        ++n;
                    }
                }
            }
            if (this.enlistedXAList != null) {
                if (this.enlistedXAList.length == 1 && this.enlistedXAList[0] == xAResource) {
                    try {
                        this.enlistedList[0].delisted();
                    }
                    catch (Exception exception) {}
                    this.enlistedList = null;
                    this.enlistedXAList = null;
                } else {
                    n = 0;
                    while (n < this.enlistedXAList.length) {
                        if (this.enlistedXAList[n] == xAResource) {
                            try {
                                this.enlistedList[n].delisted();
                            }
                            catch (Exception exception) {}
                            this.enlistedList[n] = this.enlistedList[this.enlistedList.length - 1];
                            EnlistedResource[] enlistedResourceArray = new EnlistedResource[this.enlistedList.length - 1];
                            System.arraycopy(this.enlistedList, 0, enlistedResourceArray, 0, this.enlistedList.length - 1);
                            this.enlistedList = enlistedResourceArray;
                            this.enlistedXAList[n] = this.enlistedXAList[this.enlistedXAList.length - 1];
                            xAResourceArray = new XAResource[this.enlistedXAList.length - 1];
                            System.arraycopy(this.enlistedXAList, 0, xAResourceArray, 0, this.enlistedXAList.length - 1);
                            this.enlistedXAList = xAResourceArray;
                        }
                        ++n;
                    }
                }
            }
        }

        void remove(XAResource xAResource, EnlistedResource enlistedResource) throws SystemException {
            if (this.enlistedList != null) {
                if (this.enlistedList.length == 1 && this.enlistedList[0] == enlistedResource) {
                    if (this.enlistedXAList[0] != xAResource) {
                        throw new SystemException("The xa resource <" + xAResource + "> does not match the existing xa resource <" + this.enlistedXAList[0] + "> for the enlisted resource <" + enlistedResource + ">.");
                    }
                    try {
                        this.enlistedList[0].delisted();
                    }
                    catch (Exception exception) {}
                    this.enlistedList = null;
                    this.enlistedXAList = null;
                } else {
                    int n = 0;
                    while (n < this.enlistedList.length) {
                        if (this.enlistedList[n] == enlistedResource) {
                            if (this.enlistedXAList[n] != xAResource) {
                                throw new SystemException("The xa resource <" + xAResource + "> does not match the existing xa resource <" + this.enlistedXAList[n] + "> for the enlisted resource <" + enlistedResource + ">.");
                            }
                            try {
                                this.enlistedList[n].delisted();
                            }
                            catch (Exception exception) {}
                            this.enlistedList[n] = this.enlistedList[this.enlistedList.length - 1];
                            EnlistedResource[] enlistedResourceArray = new EnlistedResource[this.enlistedList.length - 1];
                            System.arraycopy(this.enlistedList, 0, enlistedResourceArray, 0, this.enlistedList.length - 1);
                            this.enlistedList = enlistedResourceArray;
                            this.enlistedXAList[n] = this.enlistedXAList[this.enlistedXAList.length - 1];
                            XAResource[] xAResourceArray = new XAResource[this.enlistedXAList.length - 1];
                            System.arraycopy(this.enlistedXAList, 0, xAResourceArray, 0, this.enlistedXAList.length - 1);
                            this.enlistedXAList = xAResourceArray;
                        }
                        ++n;
                    }
                }
            }
        }
    }
}

