/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.panther.implementations;

import java.io.IOException;
import java.util.Hashtable;
import org.openprivacy.panther.components.ProxyEntry;
import org.openprivacy.panther.components.ProxyException;
import org.openprivacy.panther.implementations.PantherProxyEntry;
import org.openprivacy.panther.implementations.xml.FetchHandler;

public class ProxyEntryManager {
    private Hashtable entries = new Hashtable();
    private static ProxyEntryManager instance = null;

    public ProxyEntry get(String location) throws IOException {
        if (this.entries.containsKey(location)) {
            PantherProxyEntry entry = (PantherProxyEntry)this.entries.get(location);
            this.requireExists(entry);
            return entry;
        }
        FetchHandler fh = new FetchHandler(location);
        if (fh.found()) {
            ProxyEntry entry = fh.getProxyEntry();
            ProxyEntryManager.getInstance().set(location, entry);
            this.requireExists(entry);
            return entry;
        }
        throw new ProxyException("Update just ran, but URL was not in the cache.");
    }

    private void requireExists(ProxyEntry entry) throws IOException {
        if (!entry.getFile().exists()) {
            throw new ProxyException("Entry not present on disk: " + entry.getFile().getAbsolutePath());
        }
    }

    public void set(String location, ProxyEntry entry) {
        this.entries.put(location, entry);
    }

    public static ProxyEntryManager getInstance() {
        if (instance == null) {
            instance = new ProxyEntryManager();
        }
        return instance;
    }
}

