/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.turbine.services.BaseService;
import org.apache.turbine.services.db.PoolBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.pool.ConnectionPool;
import org.apache.turbine.util.db.pool.DBConnection;

public class TurbinePoolBrokerService
extends BaseService
implements PoolBrokerService {
    public static final String DEFAULT = "default";
    private Map pools;

    public void init() {
        this.pools = new HashMap();
        Monitor monitor = new Monitor();
        monitor.setDaemon(true);
        monitor.start();
        this.setInit(true);
    }

    public synchronized void shutdown() {
        if (this.pools != null) {
            Iterator pool = this.pools.values().iterator();
            while (pool.hasNext()) {
                try {
                    ((ConnectionPool)pool.next()).shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public DBConnection getConnection() throws Exception {
        return this.getConnection(DEFAULT);
    }

    public DBConnection getConnection(String name) throws Exception {
        return this.getPool(name).getConnection();
    }

    public DBConnection getConnection(String driver, String url, String username, String password) throws Exception {
        ConnectionPool pool = null;
        pool = (ConnectionPool)this.pools.get((url = url.trim()) + username);
        if (pool == null) {
            this.registerPool(url + username, driver, url, username, password);
            pool = (ConnectionPool)this.pools.get(url + username);
        }
        return pool.getConnection();
    }

    public void releaseConnection(DBConnection dbconn) throws Exception {
        ConnectionPool pool;
        if (dbconn != null && this.pools.containsValue(pool = dbconn.getPool())) {
            pool.releaseConnection(dbconn);
        }
    }

    public void registerPool(String name, String driver, String url, String username, String password) throws Exception {
        this.registerPool(name, driver, url, username, password, TurbineResources.getInt(this.getProperty(name, "maxConnections"), 10), TurbineResources.getLong(this.getProperty(name, "expiryTime"), 3600000L));
    }

    public void registerPool(String name, String driver, String url, String username, String password, int maxCons, long expiryTime) throws Exception {
        if (!this.pools.containsKey(name)) {
            Map map = this.pools;
            synchronized (map) {
                if (!this.pools.containsKey(name)) {
                    ConnectionPool pool = new ConnectionPool(driver, url, username, password, maxCons, expiryTime);
                    this.pools.put(name, pool);
                }
            }
        }
    }

    public DB getDB() throws Exception {
        return this.getDB(DEFAULT);
    }

    public DB getDB(String name) throws Exception {
        return this.getPool(name).getDB();
    }

    private ConnectionPool getPool() throws Exception {
        return this.getPool(DEFAULT);
    }

    private ConnectionPool getPool(String name) throws Exception {
        ConnectionPool pool = (ConnectionPool)this.pools.get(name);
        if (pool == null) {
            this.registerPool(name, TurbinePoolBrokerService.getDatabaseProperty(name, "driver"), TurbinePoolBrokerService.getDatabaseProperty(name, "url"), TurbinePoolBrokerService.getDatabaseProperty(name, "username"), TurbinePoolBrokerService.getDatabaseProperty(name, "password"));
            pool = (ConnectionPool)this.pools.get(name);
        }
        return pool;
    }

    private static final String getDatabaseProperty(String db, String prop) {
        return TurbineResources.getString("database." + db + '.' + prop, "");
    }

    private String getProperty(String db, String prop) {
        return "database." + db + '.' + prop;
    }

    protected class Monitor
    extends Thread {
        public void run() {
            int logInterval = TurbineResources.getInt("database.logInterval", 0);
            StringBuffer buf = new StringBuffer();
            while (logInterval > 0) {
                Iterator poolIter = TurbinePoolBrokerService.this.pools.keySet().iterator();
                while (poolIter.hasNext()) {
                    String poolName = (String)poolIter.next();
                    ConnectionPool pool = (ConnectionPool)TurbinePoolBrokerService.this.pools.get(poolName);
                    buf.setLength(0);
                    buf.append(poolName).append(" (in + out = total): ").append(pool.getNbrAvailable()).append(" + ").append(pool.getNbrCheckedOut()).append(" = ").append(pool.getTotalCount());
                    Log.info("database", buf.toString());
                }
                try {
                    Thread.sleep(logInterval);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
        }

        Monitor() {
        }
    }
}

