/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.cert.EAYDSAPrivateKey;
import COM.claymoresystems.cert.EAYRSAPrivateKey;
import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.crypto.PEMData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;

public class EAYEncryptedPrivateKey {
    private static final String DSA_STRING = "DSA";
    private static final String RSA_STRING = "RSA";

    public static PrivateKey createPrivateKey(BufferedReader bufferedReader, String string, byte[] byArray) throws IOException, IllegalArgumentException {
        byte[] byArray2 = PEMData.readPEMObject(bufferedReader, byArray);
        if (string.equals(DSA_STRING)) {
            return new EAYDSAPrivateKey(byArray2);
        }
        if (string.equals(RSA_STRING)) {
            return new EAYRSAPrivateKey(byArray2);
        }
        throw new InternalError("Couldn't find key type" + string);
    }

    public static void writePrivateKey(PrivateKey privateKey, byte[] byArray, BufferedWriter bufferedWriter) throws IOException {
        String string = privateKey.getAlgorithm();
        byte[] byArray2 = privateKey.getEncoded();
        String string2 = string + " PRIVATE KEY";
        PEMData.writePEMObject(byArray2, byArray, string2, bufferedWriter);
    }

    public static void writePrivateKey(RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, BufferedWriter bufferedWriter) throws IOException {
        String string = rSAPrivateCrtKey.getAlgorithm();
        X509RSAPrivateKey x509RSAPrivateKey = new X509RSAPrivateKey(rSAPrivateCrtKey);
        byte[] byArray2 = x509RSAPrivateKey.getEncoded();
        String string2 = string + " PRIVATE KEY";
        PEMData.writePEMObject(byArray2, byArray, string2, bufferedWriter);
    }
}

