/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.sslg.DistinguishedName;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class X509Name
implements DistinguishedName {
    private static String[][] OIDMAP = new String[][]{{"2.5.4.6", "C"}, {"2.5.4.8", "ST"}, {"2.5.4.7", "L"}, {"2.5.4.9", "STREET"}, {"2.5.4.10", "O"}, {"2.5.4.11", "OU"}, {"2.5.4.3", "CN"}, {"1.2.840.113549.1.9.1", "EmailAddress"}, {"2.5.4.5", "SN"}};
    private byte[] nameDER = null;
    private Vector name = null;
    private String nameString = null;

    public X509Name(byte[] byArray) {
        this.nameDER = byArray;
        this.name = X509Name.rawNameToName(byArray);
    }

    public byte[] getNameDER() {
        return this.nameDER;
    }

    public Vector getName() {
        return this.name;
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nameString == null) {
            int n = 0;
            while (n < this.name.size()) {
                Vector vector = (Vector)this.name.elementAt(n);
                if (n > 0) {
                    stringBuffer.append(",");
                }
                int n2 = 0;
                while (n2 < vector.size()) {
                    String[] stringArray = (String[])vector.elementAt(n2);
                    if (n2 > 0) {
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(stringArray[0] + "=" + stringArray[1]);
                    ++n2;
                }
                ++n;
            }
            this.nameString = stringBuffer.toString();
        }
        return this.nameString;
    }

    private static String lookupOID(String string) {
        int n = 0;
        while (n < OIDMAP.length) {
            if (string.equals(OIDMAP[n][0])) {
                return OIDMAP[n][1];
            }
            ++n;
        }
        return "Unknown Attribute(" + string + ")";
    }

    private static Vector rawNameToName(byte[] byArray) {
        Vector vector = new Vector();
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            ASNObject aSNObject = CertContext.getSpec().getComponent("Name");
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init((InputStream)byteArrayInputStream);
            try {
                aSNObject.accept((ParserVisitor)coderOperations, null);
                Vector vector2 = (Vector)aSNObject.getValue();
                int n = 0;
                while (n < vector2.size()) {
                    Vector vector3 = (Vector)vector2.elementAt(n);
                    Vector<String[]> vector4 = new Vector<String[]>();
                    int n2 = 0;
                    while (n2 < vector3.size()) {
                        Vector vector5 = (Vector)vector3.elementAt(n2);
                        Vector vector6 = (Vector)vector5.elementAt(0);
                        Vector vector7 = (Vector)vector6.elementAt(0);
                        Vector vector8 = (Vector)vector7.elementAt(0);
                        String string = (String)vector8.elementAt(0);
                        String string2 = (String)vector8.elementAt(1);
                        String[] stringArray = new String[]{X509Name.lookupOID(string), string2};
                        vector4.addElement(stringArray);
                        ++n2;
                    }
                    vector.addElement(vector4);
                    ++n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                throw new InternalError(iOException.toString());
            }
        }
        return vector;
    }
}

