/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.EAYDSAPrivateKey;
import COM.claymoresystems.cert.X509DSAPublicKey;
import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.cert.X509RSAPublicKey;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.ptls.LoadProviders;
import cryptix.util.mime.Base64OutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class CertRequest {
    public static KeyPair generateKey(String string, int n, String string2, BufferedWriter bufferedWriter, boolean bl) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        Object object;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
        keyPairGenerator.initialize(n);
        if (string.equals("DSA")) {
            object = (DSAKeyPairGenerator)((Object)keyPairGenerator);
            object.initialize(n, bl, new SecureRandom());
        } else {
            keyPairGenerator.initialize(n);
        }
        object = keyPairGenerator.generateKeyPair();
        Object object2 = string.equals("DSA") ? new EAYDSAPrivateKey((DSAPrivateKey)((KeyPair)object).getPrivate()) : new X509RSAPrivateKey((CryptixRSAPrivateKey)((KeyPair)object).getPrivate());
        EAYEncryptedPrivateKey.writePrivateKey(object2, string2.getBytes(), bufferedWriter);
        return object;
    }

    public static byte[] makeSPKACRequest(KeyPair keyPair) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        Object object2 = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            object2 = new X509DSAPublicKey((DSAPublicKey)object2);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            object2 = new X509RSAPublicKey((CryptixRSAPublicKey)object2);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = object2.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray5);
        DERUtils.encodeIA5String("Challenge", byteArrayOutputStream);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static void main(String[] stringArray) throws IOException, Exception {
        String string;
        String string2 = stringArray[0];
        String string3 = stringArray.length == 2 ? stringArray[1] : "DSA";
        int n = 1024;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string4 = bufferedReader.readLine();
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        KeyPair keyPair = CertRequest.generateKey(string3, n, string4, bufferedWriter, true);
        byte[] byArray = CertRequest.makeSPKACRequest(keyPair);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)byteArrayOutputStream);
        base64OutputStream.write(byArray);
        base64OutputStream.flush();
        base64OutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        System.out.println(string4);
        while ((string = bufferedReader2.readLine()) != null) {
            System.out.println(string);
        }
    }

    static {
        LoadProviders.init();
    }
}

