/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.test;

import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.lang.Parser;
import cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;

public class Main2 {
    private static final boolean CRYPTIX_ASN = false;

    public static void main(String[] stringArray) {
        Object object;
        Parser parser;
        String string = "cryptix.asn";
        String string2 = "Duke.x509";
        String string3 = "Certificate";
        String string4 = "certificateInfo";
        if (stringArray.length != 2) {
            string = "x509useful.asn";
            string2 = "1eecert.x509";
            string3 = "UsefulCertificate";
            string4 = "tbsCertificate";
        } else {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        System.out.println();
        System.out.println("1. Parsing \"" + string + "\"...");
        try {
            parser = new Parser(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("*** \"" + string + "\" not found in work directory...");
            return;
        }
        ASNSpecification aSNSpecification = null;
        try {
            aSNSpecification = parser.Specification(false);
            System.out.println();
            System.out.println("2. Result of compilation: ");
            aSNSpecification.dump();
            System.out.println();
            System.out.println("3. Current symbol table:");
            Parser.dumpSymbolTable();
            System.out.println();
            int n = Parser.countUnresolvedReferences();
            System.out.println("4. Number of unresolved references: " + n);
        }
        catch (ParseException parseException) {
            System.out.println("*** Failed parsing...");
            System.out.println("*** " + parseException.getMessage() + "...");
            parseException.printStackTrace(System.out);
        }
        System.out.println();
        System.out.println("5. Can we access a \"Certificate\" from an x509 struct?");
        ASNObject aSNObject = aSNSpecification.getComponent(string3);
        aSNObject.dump("Certificate --> ");
        System.out.println();
        System.out.println("6. Can we access \"" + string2 + "\" ?");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("*** \"" + string2 + "\" not found in work directory...");
            return;
        }
        System.out.println("Yes...");
        System.out.println();
        System.out.println("7. Can we access the x509 instance present inside?");
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        if (coderOperations == null) {
            return;
        }
        coderOperations.init(fileInputStream);
        try {
            aSNObject.accept(coderOperations, null);
            aSNObject.dump();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        ASNObject aSNObject2 = aSNObject.getComponent(string3 + "." + string4);
        byte[] byArray = null;
        byArray = (byte[])aSNObject2.getValue();
        System.out.println(string3 + " encoding: \"" + Hex.toString((byte[])byArray) + "\"");
        try {
            aSNObject2 = aSNSpecification.getComponent("UsefulTBSCertificate");
            object = new ByteArrayInputStream(byArray);
            coderOperations.init((InputStream)object);
            aSNObject2.dump("UsefulTBSCertificate--> ");
            aSNObject2.accept(coderOperations, null);
            aSNObject2.dump();
            ASNObject aSNObject3 = aSNSpecification.getComponent("UsefulTBSCertificate.issuer");
            byte[] byArray2 = (byte[])aSNObject3.getValue();
            System.out.println("Issuer encoding: " + Hex.toString((byte[])byArray2));
            ASNObject aSNObject4 = aSNSpecification.getComponent("UsefulTBSCertificate.subject");
            byte[] byArray3 = (byte[])aSNObject4.getValue();
            System.out.println("Subject encoding: " + Hex.toString((byte[])byArray3));
            ASNObject aSNObject5 = aSNSpecification.getComponent("UsefulTBSCertificate.extensions");
            Vector vector = (Vector)aSNObject5.getValue();
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                byte[] byArray4 = (byte[])vector2.elementAt(0);
                System.out.println("Extn encoding: " + Hex.toString((byte[])byArray4));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        object = aSNObject.getComponent(string3 + ".signature");
        byArray = (byte[])object.getValue();
        System.out.println("Signature encoding: \"" + Hex.toString((byte[])byArray) + "\"");
        System.out.println();
        System.out.println("Done all tests...");
    }
}

