/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.crypto;

import jxta.security.cipher.Cipher;
import jxta.security.crypto.JxtaCrypto;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.cipher.NullCipher;
import jxta.security.impl.cipher.RC4Cipher;
import jxta.security.impl.hash.MD5Hash;
import jxta.security.impl.hash.NullHash;
import jxta.security.impl.hash.SHA1Hash;
import jxta.security.impl.keyexchange.NullKeyExchange;
import jxta.security.impl.mac.MACAlgorithm;
import jxta.security.impl.mac.NullMAC;
import jxta.security.impl.publickey.NullRSA;
import jxta.security.impl.publickey.RSA;
import jxta.security.impl.publickey.RSAKey;
import jxta.security.impl.signature.NullSignature;
import jxta.security.impl.signature.RSASignature;
import jxta.security.keyexchange.KeyExchange;
import jxta.security.mac.MAC;
import jxta.security.publickey.PublicKeyAlgorithm;
import jxta.security.signature.Signature;

public class JxtaCryptoSuite
implements JxtaCrypto {
    private static byte cryptoProfile = 0;
    private static byte crytoSignatureType = 0;
    private static byte cryptoMacType = 0;
    private Cipher[] cipher = new Cipher[1];
    private Hash[] hash = new Hash[2];
    private KeyExchange keyExchange = null;
    private MAC mac = null;
    private PublicKeyAlgorithm pkAlg = new NullRSA();
    private Signature signature = null;

    public Cipher getJxtaCipher() {
        return this.cipher[0];
    }

    public Cipher getJxtaCipher(byte by) throws CryptoException {
        return this.cipher[0];
    }

    public Hash getJxtaHash() {
        return this.hash[0];
    }

    public Hash getJxtaHash(byte by) throws CryptoException {
        int n = 0;
        while (n < 2) {
            if (this.hash[n].getAlgorithm() == by) {
                return this.hash[n];
            }
            ++n;
        }
        throw new CryptoException(4);
    }

    public MAC getJxtaMAC() {
        return this.mac;
    }

    public KeyExchange getJxtaKeyExchange() {
        return this.keyExchange;
    }

    public PublicKeyAlgorithm getJxtaPublicKeyAlgorithm() {
        return this.pkAlg;
    }

    public Signature getJxtaSignature() {
        return this.signature;
    }

    public JxtaCryptoSuite(byte by, RSAKey rSAKey, byte by2, byte by3) throws CryptoException {
        this.cipher[0] = new NullCipher();
        int n = 0;
        while (n < 2) {
            this.hash[n] = new NullHash();
            ++n;
        }
        this.keyExchange = new NullKeyExchange();
        this.mac = new NullMAC();
        this.signature = new NullSignature();
        cryptoProfile = by;
        if (by != 0) {
            if ((by & 1) != 0) {
                this.cipher[0] = new RC4Cipher();
            }
            if ((by & 2) != 0) {
                this.pkAlg = new RSA(rSAKey);
            }
            if ((by & 4) != 0) {
                this.hash[0] = new SHA1Hash();
            }
            if ((by & 8) != 0) {
                if ((by & 4) != 0) {
                    this.hash[1] = new MD5Hash();
                } else {
                    this.hash[0] = new MD5Hash();
                }
            }
        }
        crytoSignatureType = by2;
        if ((by2 & 1) != 0 || (by2 & 2) != 0) {
            if ((by & 2) == 0) {
                throw new CryptoException(1);
            }
            if ((by & 4) != 0) {
                this.signature = new RSASignature(this.pkAlg, rSAKey, by2, this.getJxtaHash((byte)1));
            } else if ((by & 8) != 0) {
                this.signature = new RSASignature(this.pkAlg, rSAKey, by2, this.getJxtaHash((byte)2));
            } else {
                throw new CryptoException(1);
            }
        }
        cryptoMacType = by3;
        if ((by3 & 2) != 0 || (by3 & 1) != 0) {
            if ((by & 1) == 0) {
                throw new CryptoException(1);
            }
            if ((by & 8) != 0) {
                this.mac = new MACAlgorithm(this.getJxtaCipher((byte)4), 2, this.getJxtaHash((byte)2));
            } else if ((by & 4) != 0) {
                this.mac = new MACAlgorithm(this.getJxtaCipher((byte)4), 1, this.getJxtaHash((byte)1));
            }
        }
    }

    public static byte getProfile() {
        return cryptoProfile;
    }
}

