<?xml version="1.0"?> 

<!--

$Id: unread-articles.xsl,v 1.2 2001/12/16 07:36:55 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:marks="xalan://org.openprivacy.reptile.extensions.Marks"
                xmlns:shown-count="xalan://org.openprivacy.reptile.extensions.ShownCount"
                xmlns:channel="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                xmlns:article-search="xalan://org.openprivacy.reptile.extensions.om.ArticleSearchExtension"
                extension-element-prefixes="marks shown-count channel article-search"
                version="1.0">

    <xsl:preserve-space elements="td"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="skip" select="'urn:quick-channel'"/>

    <xsl:template match="/layout:layout">

        <control:content>
    
            <dc:title>Unread articles</dc:title>
    
            <control:body>

            <table cellpadding="4" width="100%">

            <!--  HTML hack.  For some reason konq needs at least one row. -->
            <tr>

            <td/>

            <td/>

            </tr>

<!--             <xsl:apply-templates select="./layout:layer/layout:content/cl:content-list/cl:channel"/> -->

            <xsl:apply-templates/>
    
            </table>

            </control:body>

            <control:shownCount><xsl:value-of select="shown-count:get()"/></control:shownCount>

        </control:content>

    </xsl:template>

    <xsl:template match="layout:content">

        <!-- ONLY PROCESS THIS INFORMATION IF IT IS INDEXABLE -->

        <xsl:if test="starts-with( @location, $skip ) = false and channel:isSupportedContentType( @contentType )">

            <!-- BEGIN CHANNEL HEADING INFO -->

            <tr>

                <td width="100%" 
                    colspan="2"
                    class="reptile-unread-articles-by-channel">

                    <table width="100%">

                        <td nowrap="nowrap">

                        <b>

                        <!-- FIXME: need to specify contentType here -->

                        <link-producer:link link-name="urn:channel-management/maximize"
                                            title="{channel:getTitle( @location )}"
                                            location="{@location}"/>

                        </b>

                        ( <link-producer:link link-name="urn:subscriptions/layer" name="{./layout:position/@layer}"/> )

                        </td>

                        <td valign="middle" 
                            align="right" 
                            nowrap="true"
                            width="100%">
            
                        Mark channel
                
                        <link-producer:read-marks location="{@location}"
                                                  contentType="{@contentType}"
                                                  name="read"/>
                                        
                        or 
                
                        <link-producer:read-marks location="{@location}"
                                                  contentType="{@contentType}"
                                                  name="unread"/>

                        </td>


                        <td valign="middle">

                        <link-producer:link link-name="urn:view-xml" location="{@location}"/>

                        </td>

                    </table>

                </td>

            </tr>

            <layout:content contentType="{@contentType}" location="{@location}" layer="{./layout:position/@layer}">

                <article-search:byChannelUnreadOnly query="{@location}"/>

            </layout:content>

        </xsl:if>

    </xsl:template>

</xsl:stylesheet>

