<?xml version="1.0"?> 

<!--

$Id: search-weblog-rss.xsl,v 1.2 2002/02/26 09:17:58 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to render reptile search search-results into an RSS 1.0
format compliant to the users local RSS channel.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:search="http://schemas.openprivacy.org/reptile/search"
                xmlns:setting-extension="xalan://org.openprivacy.reptile.extensions.om.SettingExtension"
                extension-element-prefixes="setting-extension"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"
                omit-xml-declaration="yes"/>                

    <xsl:template match="search:search">

        <rdf:RDF>

            <rss:channel>

                <rss:title><xsl:value-of select="setting-extension:value( 'reptile.setting.weblog.title' )"/></rss:title>
                <rss:description><xsl:value-of select="setting-extension:value( 'reptile.setting.weblog.description' )"/></rss:description>

                <rss:image rdf:about="{setting-extension:value( 'reptile.setting.weblog.image.URL' )}">

                    <rss:title><xsl:value-of select="setting-extension:value( 'reptile.setting.weblog.image.title' )"/></rss:title>

                    <rss:link><xsl:value-of select="setting-extension:value( 'reptile.setting.weblog.image.title' )"/></rss:link>
                    
                    <rss:url><xsl:value-of select="setting-extension:value( 'reptile.setting.weblog.image.URL' )"/></rss:url>
                    
                </rss:image>
            
            </rss:channel>
            
            <xsl:apply-templates/>

        </rdf:RDF>

    </xsl:template>

    <xsl:template match="search:entry">

        <rss:item>

            <rss:title><xsl:value-of select="dc:title"/></rss:title>
    
            <rss:link><xsl:value-of select="search:link/@location"/></rss:link>

            <dc:date><xsl:value-of select="search:link/@date-found"/></dc:date>
    
            <rss:description><xsl:value-of select="dc:description"/></rss:description>

        </rss:item>

    </xsl:template>

    <xsl:template match="search:request"/>
    
</xsl:stylesheet>