<?xml version="1.0"?> 

<!--

$Id: rss-1.0.xsl,v 1.5 2001/12/17 10:06:48 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet is designed to reformat RSS as a content list.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:rss="http://purl.org/rss/1.0/"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:valid-item="xalan://org.openprivacy.reptile.extensions.ValidItem"
                extension-element-prefixes="valid-item"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"
                omit-xml-declaration="yes"/>                

    <xsl:template match="/rdf:RDF">

        <cl:content-list>

        <cl:channel>

            <dc:title><xsl:value-of select="rss:channel/rss:title"/></dc:title>

            <dc:description><xsl:value-of select="rss:channel/rss:description"/></dc:description>

            <cl:link><xsl:value-of select="rss:channel/rss:link"/></cl:link>

        </cl:channel>

        <xsl:apply-templates select="./rss:item"/>

        </cl:content-list>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rss:item">
    
        <xsl:if test="valid-item:isValid( ./rss:link, ./rss:title )">

            <cl:entry location="{./rss:link}">
    
                <dc:title><xsl:value-of select="./rss:title"/></dc:title>
        
                <dc:description><xsl:value-of select="./rss:description"/></dc:description>
    
            </cl:entry>

        </xsl:if>

    </xsl:template>

</xsl:stylesheet>





