/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.StringManager;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class ProxyDirContext
implements DirContext {
    public static final String CONTEXT = "context";
    public static final String HOST = "host";
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager((String)"org.apache.naming.resources");
    protected DirContext dirContext;
    protected String hostName;
    protected String contextName;
    protected Hashtable cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 32768;

    public ProxyDirContext(Hashtable env, DirContext dirContext) {
        this.env = env;
        this.dirContext = dirContext;
        if (dirContext instanceof BaseDirContext && ((BaseDirContext)dirContext).isCached()) {
            this.cache = new Hashtable();
            this.cacheTTL = ((BaseDirContext)dirContext).getCacheTTL();
            this.cacheObjectMaxSize = ((BaseDirContext)dirContext).getCacheObjectMaxSize();
        }
        this.hostName = (String)env.get(HOST);
        this.contextName = (String)env.get(CONTEXT);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.dirContext.addToEnvironment(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj, attrs);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name.toString());
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj, attrs);
    }

    protected boolean cacheLoad(CacheEntry entry) {
        if (this.cache == null) {
            return false;
        }
        String name = entry.name;
        if (entry.attributes == null) {
            try {
                Attributes attributes = this.dirContext.getAttributes(entry.name);
                entry.attributes = !(attributes instanceof ResourceAttributes) ? new ResourceAttributes(attributes) : (ResourceAttributes)attributes;
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        if (entry.resource == null && entry.context == null) {
            try {
                Object object = this.dirContext.lookup(name);
                if (object instanceof InputStream) {
                    entry.resource = new Resource((InputStream)object);
                } else if (object instanceof DirContext) {
                    entry.context = (DirContext)object;
                } else {
                    entry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                }
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        if (entry.resource != null && entry.resource.getContent() == null && entry.attributes.getContentLength() >= 0L && entry.attributes.getContentLength() < (long)this.cacheObjectMaxSize) {
            int length = (int)entry.attributes.getContentLength();
            InputStream is = null;
            try {
                try {
                    is = entry.resource.streamContent();
                    int pos = 0;
                    byte[] b = new byte[length];
                    while (pos < length) {
                        int n = is.read(b, pos, length - pos);
                        if (n < 0) break;
                        pos += n;
                    }
                    entry.resource.setContent(b);
                }
                catch (IOException iOException) {
                }
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        entry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        this.cache.put(name, entry);
        return true;
    }

    protected CacheEntry cacheLookup(String name) {
        if (this.cache == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(name);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = name;
            if (!this.cacheLoad(cacheEntry)) {
                return null;
            }
            return cacheEntry;
        }
        if (!this.validate(cacheEntry)) {
            if (!this.revalidate(cacheEntry)) {
                this.cacheUnload(cacheEntry.name);
                return null;
            }
            cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        }
        return cacheEntry;
    }

    protected boolean cacheUnload(String name) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.remove(name) != null;
    }

    public void close() throws NamingException {
        this.dirContext.close();
    }

    public String composeName(String name, String prefix) throws NamingException {
        return String.valueOf(prefix) + "/" + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)name.clone();
        return prefix.addAll(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name));
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name), attrs);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name));
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name), attrs);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    public Attributes getAttributes(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            return entry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), attrIds);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(Name name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name.toString());
        if (entry != null) {
            return entry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), attrIds);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getDocBase() {
        if (this.dirContext instanceof BaseDirContext) {
            return ((BaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.dirContext.getEnvironment();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNameInNamespace() throws NamingException {
        return this.dirContext.getNameInNamespace();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    public DirContext getSchema(String name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    public Object lookup(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        if (object instanceof DirContext) {
            return object;
        }
        if (object instanceof Resource) {
            return object;
        }
        return new Resource(new ByteArrayInputStream(object.toString().getBytes()));
    }

    public Object lookup(Name name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name.toString());
        if (entry != null) {
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        return object;
    }

    public Object lookupLink(String name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mod_op, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mods);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mods);
    }

    protected String parseName(String name) throws NamingException {
        return name;
    }

    protected Name parseName(Name name) throws NamingException {
        return name;
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj, attrs);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name.toString());
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj, attrs);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.dirContext.removeFromEnvironment(propName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.dirContext.rename(this.parseName(oldName), this.parseName(newName));
        this.cacheUnload(oldName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.dirContext.rename(this.parseName(oldName), this.parseName(newName));
        this.cacheUnload(oldName.toString());
    }

    protected boolean revalidate(CacheEntry entry) {
        if (entry.attributes == null) {
            return false;
        }
        long lastModified = entry.attributes.getLastModified();
        long contentLength = entry.attributes.getContentLength();
        if (lastModified <= 0L) {
            return false;
        }
        try {
            Attributes tempAttributes = this.dirContext.getAttributes(entry.name);
            ResourceAttributes attributes = null;
            attributes = !(tempAttributes instanceof ResourceAttributes) ? new ResourceAttributes(tempAttributes) : (ResourceAttributes)tempAttributes;
            long lastModified2 = attributes.getLastModified();
            long contentLength2 = attributes.getContentLength();
            return lastModified == lastModified2 && contentLength == contentLength2;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filter, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes, attributesToReturn);
    }

    public void unbind(String name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name);
    }

    public void unbind(Name name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    protected boolean validate(CacheEntry entry) {
        return entry.resource != null && entry.resource.getContent() != null && System.currentTimeMillis() < entry.timestamp;
    }

    protected class CacheEntry {
        long timestamp = -1L;
        String name = null;
        ResourceAttributes attributes = null;
        Resource resource = null;
        DirContext context = null;

        protected CacheEntry() {
        }

        public void recycle() {
            this.timestamp = -1L;
            this.name = null;
            this.attributes = null;
            this.resource = null;
            this.context = null;
        }

        public String toString() {
            return "Cache entry: " + this.name + "\n" + "Attributes: " + this.attributes + "\n" + "Resource: " + this.resource + "\n" + "Context: " + this.context;
        }
    }
}

