/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.jxta;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.jxta.Message;
import COM.claymoresystems.ptls.jxta.MessageElement;
import COM.claymoresystems.ptls.jxta.MessageElementEnumeration;
import COM.claymoresystems.ptls.jxta.MessageElementEnumerationImpl;
import COM.claymoresystems.ptls.jxta.MessageElementImpl;
import COM.claymoresystems.ptls.jxta.MimeMediaType;
import COM.claymoresystems.ptls.jxta.StringEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MessageImpl
implements Message {
    private Hashtable namespace2elements = new Hashtable();
    Vector order = new Vector();

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, InputStream inputStream, MessageElement messageElement) throws IOException {
        return new MessageElementImpl(string, mimeMediaType, inputStream, -1, messageElement);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, InputStream inputStream, int n, MessageElement messageElement) throws IOException {
        return new MessageElementImpl(string, mimeMediaType, inputStream, n, messageElement);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, byte[] byArray, int n, int n2, MessageElement messageElement) {
        return new MessageElementImpl(string, mimeMediaType, byArray, n, n2, messageElement);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, byte[] byArray, MessageElement messageElement) {
        return new MessageElementImpl(string, mimeMediaType, byArray, 0, byArray.length, messageElement);
    }

    public boolean removeElement(MessageElement messageElement) {
        String string = messageElement.getName();
        if (string == null) {
            throw new RuntimeException("Element has null name");
        }
        return this.removeElement(string) != null;
    }

    public MessageElement removeElement(String string) {
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Hashtable hashtable = (Hashtable)this.namespace2elements.get(string2);
        if (hashtable == null) {
            return null;
        }
        MessageElement messageElement = (MessageElement)hashtable.get(string3);
        if (messageElement == null) {
            return null;
        }
        hashtable.remove(string3);
        this.order.remove(messageElement);
        if (hashtable.size() == 0) {
            this.namespace2elements.remove(string2);
        }
        return messageElement;
    }

    public InputStream pop(String string) {
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        InputStream inputStream = null;
        MessageElement messageElement = this.getElement(string);
        if (messageElement != null) {
            this.removeElement(string);
            inputStream = messageElement.getStream();
        }
        return inputStream;
    }

    public byte[] popBytes(String string) {
        byte[] byArray = null;
        MessageElement messageElement = this.getElement(string);
        if (messageElement != null) {
            byArray = messageElement.getBytesOffset();
            int n = messageElement.getOffset();
            if (n != 0) {
                byte[] byArray2 = byArray;
                byArray = new byte[messageElement.getLength()];
                System.arraycopy(byArray2, messageElement.getOffset(), byArray, 0, messageElement.getLength());
            }
            this.removeElement(messageElement);
        }
        return byArray;
    }

    public void push(String string, InputStream inputStream) throws IOException {
        MessageElement messageElement = this.newMessageElement(string, null, inputStream, null);
        this.addElement(messageElement);
    }

    public void pushBytes(String string, byte[] byArray) {
        this.pushBytes(string, byArray, 0, byArray.length);
    }

    public void pushBytes(String string, byte[] byArray, int n, int n2) {
        MessageElement messageElement = this.newMessageElement(string, null, byArray, n, n2, null);
        this.addElement(messageElement);
    }

    public Enumeration getNamespaces() {
        return this.namespace2elements.keys();
    }

    public boolean hasElement(String string) {
        return this.getElement(string) != null;
    }

    public MessageElement getElement(String string) {
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Hashtable hashtable = (Hashtable)this.namespace2elements.get(string2);
        if (hashtable == null) {
            return null;
        }
        return (MessageElement)hashtable.get(string3);
    }

    public void addElement(MessageElement messageElement) {
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        MessageElement messageElement2 = this.getElement(messageElement.getName());
        if (messageElement2 != null) {
            int n = this.order.indexOf(messageElement2);
            this.order.setElementAt(messageElement, n);
        } else {
            this.order.addElement(messageElement);
        }
        Hashtable<String, MessageElement> hashtable = (Hashtable<String, MessageElement>)this.namespace2elements.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, MessageElement>();
            this.namespace2elements.put(string, hashtable);
        }
        if (SSLDebug.getDebug(128)) {
            System.out.println("AddELement: Namespace = " + string + ", name = " + string2);
        }
        hashtable.put(string2, messageElement);
    }

    public MessageElementEnumeration getElements() {
        return this.getElementsInLifoOrder();
    }

    public MessageElementEnumeration getElementsInFifoOrder() {
        return new MessageElementEnumerationImpl(this.order.elements());
    }

    public MessageElementEnumeration getElementsInLifoOrder() {
        Vector vector = new Vector();
        Enumeration enumeration = this.order.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(0, enumeration.nextElement());
        }
        return new MessageElementEnumerationImpl(vector.elements());
    }

    public StringEnumeration getNames() {
        return new StringEnumeration(new Enumeration(){
            private Enumeration elements;
            {
                this.elements = MessageImpl.this.getElementsInLifoOrder();
            }

            public boolean hasMoreElements() {
                return this.elements.hasMoreElements();
            }

            public Object nextElement() {
                MessageElement messageElement = (MessageElement)this.elements.nextElement();
                return messageElement.getName();
            }
        });
    }

    public MessageElementEnumeration getElements(final String string) {
        return new MessageElementEnumerationImpl(new Enumeration(){
            private Hashtable elementsTable;
            private Enumeration elements;
            {
                this.elementsTable = (Hashtable)MessageImpl.this.namespace2elements.get(string);
                this.elements = this.elementsTable == null ? null : this.elementsTable.elements();
            }

            public boolean hasMoreElements() {
                return this.elements != null && this.elements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.elements == null || !this.elements.hasMoreElements()) {
                    return null;
                }
                return this.elements.nextElement();
            }
        });
    }

    public Object clone() {
        return this.dup();
    }

    public Message dup() {
        MessageImpl messageImpl = new MessageImpl();
        MessageElementEnumeration messageElementEnumeration = this.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            messageImpl.addElement(messageElement);
        }
        return messageImpl;
    }

    public boolean equals(Object object) {
        Message message = (Message)object;
        MessageElementEnumeration messageElementEnumeration = this.getElements();
        MessageElementEnumeration messageElementEnumeration2 = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement;
            if (!messageElementEnumeration2.hasMoreElements()) {
                return false;
            }
            MessageElement messageElement2 = messageElementEnumeration.nextMessageElement();
            if (messageElement2.equals(messageElement = messageElementEnumeration2.nextMessageElement())) continue;
            return false;
        }
        return !messageElementEnumeration2.hasMoreElements();
    }

    public void pushString(String string, String string2) {
        this.pushBytes(string, string2.getBytes());
    }

    public String popString(String string) {
        byte[] byArray = this.popBytes(string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }
}

