/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.demo;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLReHandshakeException;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.demo.Demo;
import COM.claymoresystems.sslg.SSLPolicyInt;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.Vector;

class SSLClient {
    private static String host = "localhost";
    private static int port = 4433;
    private static String keyfile = "client.pem";
    private static String rootfile = "root.pem";
    private static String randomfile = "random.pem";
    private static String password = "password";
    private static LongOpt[] Longopts = new LongOpt[12];
    private static int iterate = 1;
    private static boolean acceptunverified = false;
    private static boolean fakeseed = false;
    private static boolean checkDates = false;
    private static short[] cipherSuites = null;
    private static int delay = 0;

    SSLClient() {
    }

    private static void testConn(SSLContext sSLContext, String string, int n) throws IOException, UnknownHostException {
        try {
            Object object;
            SSLSocket sSLSocket = new SSLSocket(sSLContext, string, n);
            Vector vector = sSLSocket.getCertificateChain();
            int n2 = sSLSocket.getCipherSuite();
            System.out.println("Cipher suite: " + SSLPolicyInt.getCipherSuiteName(n2));
            if (vector != null) {
                System.out.println("Cert chain");
                int n3 = 0;
                while (n3 < vector.size()) {
                    object = (X509Cert)vector.elementAt(n3);
                    System.out.println("Issuer " + ((X509Cert)object).getIssuerName().getNameString());
                    System.out.println("Subject " + ((X509Cert)object).getSubjectName().getNameString());
                    System.out.println("Serial " + ((X509Cert)object).getSerial());
                    System.out.println("Validity " + ((X509Cert)object).getValidityNotBefore() + "-" + ((X509Cert)object).getValidityNotAfter());
                    ++n3;
                }
            }
            System.out.println("-----");
            byte[] byArray = new byte[4096];
            object = new InputStreamReader(sSLSocket.getInputStream());
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(sSLSocket.getOutputStream());
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write("GET / HTTP/1.0\r\n");
            bufferedWriter.write("User-Agent: PureTLS Client demo program\r\n");
            bufferedWriter.write("\r\n\r\n");
            bufferedWriter.flush();
            while (true) {
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        System.out.println(string2);
                    }
                }
                catch (SSLReHandshakeException sSLReHandshakeException) {
                    System.out.println("Renegotiate requested. Renegotiating");
                    sSLSocket.renegotiate();
                    continue;
                }
                break;
            }
            sSLSocket.close();
        }
        catch (SSLAlertException sSLAlertException) {
            sSLAlertException.printStackTrace();
            throw new Error(sSLAlertException.toString());
        }
    }

    private static void usage() {
        System.out.println("SSLClient usage ");
        System.out.println("SSLClient [args]");
        System.out.println("  --host, -h: the host to connect to (default localhost)");
        System.out.println("  --port, -h: the port to connect to (default 4433)");
        System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
        System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
        System.out.println("  --password, -P: the password to use (default password)");
        System.out.println("  --iterate, -i: repeat the test fetch some number of times (default 1");
        System.out.println("    demonstrates session caching");
        System.out.println("  --delay, -D: delay between each repeat (default 0)");
        System.out.println("  --debug, -d: set the debugging flags");
        System.out.println("  --acceptunverified, -u: accept unverifieable certificates");
        System.out.println("  --fakerandom, -f: seed the rng with null data");
        System.out.println("  --ciphersuites, -a: allowed ciphersuites");
        System.out.println("  --checkdates, -c: check dates on certificates");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("SSLClient", stringArray, "h:p:k:r:Ri:d:ufP:a:D:c", Longopts);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    host = new String(getopt.getOptarg());
                    break;
                }
                case 112: {
                    port = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 107: {
                    keyfile = new String(getopt.getOptarg());
                    break;
                }
                case 114: {
                    rootfile = new String(getopt.getOptarg());
                    break;
                }
                case 80: {
                    password = new String(getopt.getOptarg());
                    break;
                }
                case 105: {
                    iterate = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 68: {
                    delay = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 117: {
                    acceptunverified = true;
                    break;
                }
                case 100: {
                    SSLDebug.setDebug(Integer.parseInt(getopt.getOptarg()));
                    break;
                }
                case 102: {
                    fakeseed = true;
                    break;
                }
                case 97: {
                    cipherSuites = Demo.parseCipherSuites(getopt.getOptarg());
                    break;
                }
                case 99: {
                    checkDates = true;
                    break;
                }
                default: {
                    SSLClient.usage();
                    return;
                }
            }
        }
        SSLContext sSLContext = new SSLContext();
        SSLPolicyInt sSLPolicyInt = new SSLPolicyInt();
        if (cipherSuites != null) {
            sSLPolicyInt.setCipherSuites(cipherSuites);
        }
        sSLPolicyInt.acceptUnverifiableCertificates(acceptunverified);
        sSLPolicyInt.checkCertificateDates(checkDates);
        sSLContext.setPolicy(sSLPolicyInt);
        try {
            sSLContext.loadRootCertificates(rootfile);
            sSLContext.loadEAYKeyFile(keyfile, password);
            if (fakeseed) {
                sSLContext.seedRNG(null);
            } else {
                sSLContext.useRandomnessFile(randomfile, password);
            }
            while (iterate-- > 0) {
                SSLClient.testConn(sSLContext, host, port);
                if (iterate <= 1 || delay <= 0) continue;
                Thread.sleep(delay * 1000);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        int n = 0;
        SSLClient.Longopts[n++] = new LongOpt("host", 1, null, 104);
        SSLClient.Longopts[n++] = new LongOpt("port", 1, null, 112);
        SSLClient.Longopts[n++] = new LongOpt("keyfile", 1, null, 107);
        SSLClient.Longopts[n++] = new LongOpt("rootfile", 1, null, 114);
        SSLClient.Longopts[n++] = new LongOpt("iterate", 1, null, 105);
        SSLClient.Longopts[n++] = new LongOpt("password", 1, null, 80);
        SSLClient.Longopts[n++] = new LongOpt("debug", 1, null, 100);
        SSLClient.Longopts[n++] = new LongOpt("acceptunverified", 0, null, 117);
        SSLClient.Longopts[n++] = new LongOpt("fakerandom", 0, null, 102);
        SSLClient.Longopts[n++] = new LongOpt("ciphersuites", 1, null, 97);
        SSLClient.Longopts[n++] = new LongOpt("delay", 1, null, 68);
        SSLClient.Longopts[n++] = new LongOpt("checkdates", 1, null, 99);
    }
}

