/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.util.RFC822Hdr;
import COM.claymoresystems.util.Util;
import cryptix.provider.Cryptix;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Random;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

class PEMData {
    private static Hashtable eay2jce = null;
    private static Hashtable kSize = null;
    private static String encryptionAlg = "DES-EDE3-CBC";

    PEMData() {
    }

    static byte[] readPEMObject(BufferedReader bufferedReader, byte[] byArray) throws IOException {
        byte[] byArray2;
        RFC822Hdr rFC822Hdr = new RFC822Hdr(bufferedReader);
        RFC822Hdr rFC822Hdr2 = null;
        if (rFC822Hdr.getName() != null) {
            if (!rFC822Hdr.getSubfield(0).equals("4")) {
                throw new IOException("Unknown proc type" + rFC822Hdr.getSubfield(0));
            }
            rFC822Hdr2 = new RFC822Hdr(bufferedReader);
            try {
                byte[] byArray3 = WrappedObject.readBlock(bufferedReader);
                String string = rFC822Hdr2.getSubfield(0);
                String string2 = (String)eay2jce.get(string);
                if (string2 == null) {
                    throw new InternalError("Algorithm " + string + " not recognized");
                }
                byte[] byArray4 = new byte[((Integer)kSize.get(string)).intValue()];
                byte[] byArray5 = Hex.fromString((String)rFC822Hdr2.getSubfield(1));
                PEMData.EVP_BytesToKey("MD5", byArray5, byArray, (short)1, byArray4, null);
                RawSecretKey rawSecretKey = new RawSecretKey(string2, byArray4);
                Cipher cipher = Cipher.getInstance((String)string2, (String)"Cryptix");
                ((FeedbackCipher)cipher).setInitializationVector(byArray5);
                cipher.initDecrypt((Key)rawSecretKey);
                byArray2 = cipher.crypt(byArray3);
            }
            catch (KeyException keyException) {
                throw new InternalError(keyException.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError(noSuchAlgorithmException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InternalError(noSuchProviderException.toString());
            }
        } else {
            byArray2 = WrappedObject.readBlock(bufferedReader);
        }
        return byArray2;
    }

    static void writePEMObject(byte[] byArray, byte[] byArray2, String string, BufferedWriter bufferedWriter) throws IOException {
        byte[] byArray3;
        Object object;
        String string2;
        byte[] byArray4 = new byte[8];
        Random random = new Random();
        random.nextBytes(byArray4);
        try {
            Security.addProvider((Provider)new Cryptix());
            string2 = (String)eay2jce.get(encryptionAlg);
            object = new byte[((Integer)kSize.get(encryptionAlg)).intValue()];
            PEMData.EVP_BytesToKey("MD5", byArray4, byArray2, (short)1, object, null);
            Cipher cipher = Cipher.getInstance((String)string2, (String)"Cryptix");
            ((FeedbackCipher)cipher).setInitializationVector(byArray4);
            RawSecretKey rawSecretKey = new RawSecretKey(string2, object);
            cipher.initEncrypt((Key)rawSecretKey);
            byArray3 = cipher.crypt(byArray);
        }
        catch (KeyException keyException) {
            throw new InternalError(keyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(noSuchProviderException.toString());
        }
        string2 = "-----BEGIN " + string + "-----";
        bufferedWriter.write(string2);
        bufferedWriter.newLine();
        bufferedWriter.write("Proc-Type: 4,ENCRYPTED");
        bufferedWriter.newLine();
        object = "DEK-Info: " + encryptionAlg + "," + Hex.toString((byte[])byArray4);
        bufferedWriter.write((String)object);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        WrappedObject.writeObject(byArray3, string, bufferedWriter);
    }

    static void EVP_BytesToKey(String string, byte[] byArray, byte[] byArray2, short s, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = null;
        int n = 0;
        int n2 = byArray3.length;
        int n3 = 0;
        int n4 = 0;
        if (byArray4 != null) {
            n4 = byArray4.length;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            do {
                int n5;
                if (byArray5 != null) {
                    messageDigest.update(byArray5);
                }
                messageDigest.update(byArray2);
                if (byArray != null) {
                    messageDigest.update(byArray);
                }
                byArray5 = messageDigest.digest();
                short s2 = 1;
                while (s2 < s) {
                    messageDigest.update(byArray5);
                    byArray5 = messageDigest.digest();
                    s2 = (short)(s2 + 1);
                }
                int n6 = byArray5.length;
                int n7 = 0;
                if (n2 != 0) {
                    n5 = Util.min(n2, n6);
                    System.arraycopy(byArray5, 0, byArray3, n, n5);
                    n6 -= n5;
                    n7 = n5;
                    n2 -= n5;
                    n += n5;
                }
                if (n6 < 0 || n4 <= 0) continue;
                n5 = Util.min(n4, n6);
                System.arraycopy(byArray5, n7, byArray4, n3, n5);
                n4 -= n5;
                n3 += n5;
            } while (n2 != 0 || n4 != 0);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    static {
        eay2jce = new Hashtable();
        eay2jce.put("DES-EDE3-CBC", "3DES/CBC/PKCS5Padding");
        eay2jce.put("DES-CBC", "DES/CBC/PKCS5Padding");
        kSize = new Hashtable();
        kSize.put("DES-EDE3-CBC", new Integer(24));
        kSize.put("DES-CBC", new Integer(8));
    }
}

