/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.jxtasec;

import jxta.security.cipher.Cipher;
import jxta.security.crypto.JxtaCrypto;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.publickey.RSA;
import jxta.security.impl.publickey.RSAKey;
import jxta.security.impl.random.JRandom;
import jxta.security.publickey.RSAPrivatekeyData;
import jxta.security.publickey.RSAPublickeyData;
import jxta.security.util.URLBase64;

public class JxtaSec1 {
    private boolean debug = false;
    private static JxtaCrypto suite = null;
    private static SecretKey secret = null;
    private static byte[] sessionKey = null;
    private static Cipher rc4 = null;
    private static RSAKey rKey = null;
    private static RSA rsa = null;
    private static RSAPublickeyData ourPublicD = null;
    private static RSAPrivatekeyData ourPrivateD = null;
    private static RSAPublickeyData peerPublicD = null;
    private static boolean initialized = false;
    private static boolean sessionInitialized = false;
    private static JRandom jran = null;
    private static byte profile = (byte)3;
    private static final byte[] estart = new byte[]{58, 101, 61};
    private static final byte[] mstart = new byte[]{109, 61};

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public boolean jxtaSecInit() {
        if (!this.commonInit()) {
            return false;
        }
        if (!this.setRSAAlgorithm()) {
            return false;
        }
        initialized = true;
        return true;
    }

    public boolean jxtaSecInit(Object object, Object object2) {
        if (!this.commonInit()) {
            return false;
        }
        if (!this.setRSAAlgorithm(object, object2)) {
            return false;
        }
        initialized = true;
        return true;
    }

    private boolean commonInit() {
        try {
            jran = new JRandom();
        }
        catch (CryptoException cryptoException) {
            System.out.println("Random init failure" + cryptoException.toString());
            return false;
        }
        try {
            rKey = (RSAKey)KeyBuilder.buildKey((byte)3, (short)512, false);
        }
        catch (CryptoException cryptoException) {
            System.out.println("RSA init failure" + cryptoException.toString());
            return false;
        }
        try {
            suite = new JxtaCryptoSuite(profile, rKey, 0, 0);
        }
        catch (CryptoException cryptoException) {
            System.out.println("Crypto Suite: " + cryptoException.toString());
            return false;
        }
        rc4 = suite.getJxtaCipher();
        try {
            secret = (SecretKey)KeyBuilder.buildKey((byte)8, (short)128, false);
        }
        catch (CryptoException cryptoException) {
            System.out.println("RC4 Key init failed: " + cryptoException.toString());
            return false;
        }
        return true;
    }

    private boolean setRSAAlgorithm() {
        rsa = (RSA)suite.getJxtaPublicKeyAlgorithm();
        try {
            rsa.setPublicKey();
            rsa.setPrivateKey();
            ourPublicD = (RSAPublickeyData)rsa.getPublickey();
            ourPrivateD = (RSAPrivatekeyData)rsa.getPrivatekey();
        }
        catch (CryptoException cryptoException) {
            System.out.println("RSA Key Error: " + cryptoException.toString());
            return false;
        }
        rsa.reset();
        return true;
    }

    private boolean setRSAAlgorithm(Object object, Object object2) {
        rsa = (RSA)suite.getJxtaPublicKeyAlgorithm();
        try {
            rsa.setPublicKey(object);
            rsa.setPrivateKey(object2);
            ourPublicD = (RSAPublickeyData)object;
            ourPrivateD = (RSAPrivatekeyData)object2;
        }
        catch (CryptoException cryptoException) {
            System.out.println("RSA Key Error: " + cryptoException.toString());
            return false;
        }
        rsa.reset();
        return true;
    }

    public byte[] getOurRSAPublicKey() throws CryptoException {
        int n;
        if (!initialized) {
            throw new CryptoException(3);
        }
        byte[] byArray = URLBase64.encode(ourPublicD.getPublicExponent());
        byte[] byArray2 = URLBase64.encode(ourPublicD.getModulus());
        byte[] byArray3 = new byte[byArray.length + byArray2.length + estart.length + mstart.length];
        int n2 = 0;
        while (n2 < mstart.length) {
            byArray3[n2] = mstart[n2];
            ++n2;
        }
        System.arraycopy(byArray2, 0, byArray3, mstart.length, byArray2.length);
        int n3 = n = mstart.length + byArray2.length;
        int n4 = 0;
        while (n4 < estart.length) {
            byArray3[n3++] = estart[n4];
            ++n4;
        }
        System.arraycopy(byArray, 0, byArray3, n += estart.length, byArray.length);
        return byArray3;
    }

    private void setOtherPeerRSAPublicKey(byte[] byArray) throws CryptoException {
        Object object;
        Object object2;
        if (!initialized) {
            throw new CryptoException(3);
        }
        int n = 0;
        while (n < mstart.length) {
            if (byArray[n] != mstart[n]) {
                throw new CryptoException(2);
            }
            ++n;
        }
        int n2 = n;
        int n3 = 0;
        while (n < byArray.length) {
            if (byArray[n] == estart[0]) break;
            ++n;
            ++n3;
        }
        if (n == byArray.length || byArray[n] != estart[0]) {
            throw new CryptoException(2);
        }
        ++n;
        int n4 = 1;
        while (n4 < estart.length && n < byArray.length) {
            if (estart[n4] != byArray[n]) {
                throw new CryptoException(2);
            }
            ++n4;
            ++n;
        }
        if (n == byArray.length) {
            throw new CryptoException(2);
        }
        int n5 = n;
        int n6 = byArray.length - n;
        RSAPublickeyData rSAPublickeyData = new RSAPublickeyData();
        if (this.debug) {
            object2 = new String(byArray, n2, n3);
            object = new String(byArray, n5, n6);
            System.out.println("\n*****************************\n  modulus = " + (String)object2 + "\n exponent = " + (String)object + "\n*****************************");
        }
        object2 = URLBase64.decode(byArray, n2, n3);
        object = URLBase64.decode(byArray, n5, n6);
        rSAPublickeyData.setModulus((byte[])object2);
        rSAPublickeyData.setPublicExponent((byte[])object);
        peerPublicD = rSAPublickeyData;
    }

    public synchronized byte[] getSessionKey(byte[] byArray) throws CryptoException {
        this.setOtherPeerRSAPublicKey(byArray);
        rsa.setPublicKey(peerPublicD);
        sessionKey = new byte[secret.getLength()];
        jran.nextBytes(sessionKey);
        secret.setKey(sessionKey, 0);
        sessionInitialized = true;
        byte[] byArray2 = rsa.Algorithm(sessionKey, 0, sessionKey.length, (byte)1, true);
        rsa.reset();
        byte[] byArray3 = URLBase64.encode(byArray2);
        return byArray3;
    }

    public synchronized void setSessionKey(byte[] byArray) throws CryptoException {
        if (!initialized) {
            throw new CryptoException(3);
        }
        byte[] byArray2 = URLBase64.decode(byArray, 0, byArray.length);
        rsa.setPrivateKey(ourPrivateD);
        sessionKey = rsa.Algorithm(byArray2, 0, byArray2.length, (byte)2, false);
        rsa.reset();
        secret.setKey(sessionKey, 0);
        sessionInitialized = true;
    }

    public byte[] decryptData(byte[] byArray) throws CryptoException {
        if (!sessionInitialized) {
            throw new CryptoException(3);
        }
        byte[] byArray2 = URLBase64.decode(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[byArray2.length];
        rc4.init(secret, (byte)2);
        rc4.doFinal(byArray2, 0, byArray2.length, byArray3, 0);
        return byArray3;
    }

    public byte[] encryptData(byte[] byArray) throws CryptoException {
        if (!sessionInitialized) {
            throw new CryptoException(3);
        }
        byte[] byArray2 = new byte[byArray.length];
        rc4.init(secret, (byte)1);
        rc4.doFinal(byArray, 0, byArray.length, byArray2, 0);
        byte[] byArray3 = URLBase64.encode(byArray2);
        return byArray3;
    }

    public Object getRSAPublicKeyData() throws CryptoException {
        if (!initialized) {
            throw new CryptoException(3);
        }
        return ourPublicD;
    }

    public Object getRSAPrivateKeyData() throws CryptoException {
        if (!initialized) {
            throw new CryptoException(3);
        }
        return ourPrivateD;
    }

    public void reset() {
        rKey = null;
        rsa = null;
        ourPublicD = null;
        ourPrivateD = null;
        peerPublicD = null;
        initialized = false;
        sessionInitialized = false;
        jran = null;
    }
}

