/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.connector.warp.WarpConnection;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;

public class WarpConnector
implements Connector,
Lifecycle,
Runnable {
    private Thread thread = null;
    private ServerSocket server = null;
    private WarpLogger logger = null;
    private Vector applications = new Vector();
    protected int uniqueId = -1;
    private Container container = null;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private int redirectPort = 443;
    private String scheme = "warp";
    private boolean secure = false;
    private Service service = null;
    private String info = null;
    private String address = null;
    private int port = 8008;
    private int acceptCount = 10;
    private String appBase = "webapps";
    private int debug = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean initialized = false;
    private boolean started = false;

    public WarpConnector() {
        this.logger = new WarpLogger(this);
        this.uniqueId = new Random().nextInt();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    protected Context applicationContext(int id) {
        try {
            return (Context)this.applications.elementAt(id);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    protected int applicationId(Context context) {
        int id = this.applications.indexOf(context);
        if (id == -1) {
            this.applications.add(context);
            id = this.applications.indexOf(context);
        }
        return id;
    }

    public Request createRequest() {
        return null;
    }

    public Response createResponse() {
        return null;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            WarpConnector warpConnector = this;
            synchronized (warpConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        if (this.info == null) {
            WarpConnector warpConnector = this;
            synchronized (warpConnector) {
                this.info = String.valueOf(this.getClass().getName()) + "/" + 10 + 0;
            }
        }
        return this.info;
    }

    public int getPort() {
        return this.port;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public Service getService() {
        return this.service;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException("Already initialized");
        }
        this.initialized = true;
        try {
            ServerSocketFactory fact = this.getFactory();
            int port = this.getPort();
            int accc = this.getAcceptCount();
            if (this.getAddress() == null) {
                this.server = fact.createSocket(port, accc);
            } else {
                InetAddress addr = InetAddress.getByName(this.getAddress());
                this.server = fact.createSocket(port, accc, addr);
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Error creating server socket (" + e.getClass().getName() + ")", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        try {
            while (this.isStarted()) {
                Socket sock = this.server.accept();
                InetAddress raddr = sock.getInetAddress();
                InetAddress laddr = sock.getLocalAddress();
                int rport = sock.getPort();
                int lport = sock.getLocalPort();
                this.logger.log("Connection from " + raddr + ":" + rport + " to " + laddr + ":" + lport);
                WarpConnection conn = new WarpConnection();
                conn.setConnector(this);
                conn.setSocket(sock);
                this.addLifecycleListener(conn);
                conn.start();
            }
        }
        catch (IOException e) {
            this.logger.log("Error accepting requests", e);
        }
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public void setAddress(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        this.port = port;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }

    public void setContainer(Container container) {
        this.container = container;
        this.logger.setContainer(container);
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public void setFactory(ServerSocketFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    public void setInfo(String info) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRedirectPort(int redirectPort) {
        if (redirectPort < 1 || redirectPort > 65535) {
            throw new IllegalArgumentException("Invalid port " + redirectPort);
        }
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        if (scheme == null) {
            throw new NullPointerException();
        }
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.started) {
            throw new LifecycleException("Already started");
        }
        if (this.server == null) {
            throw new LifecycleException("Server socket not created");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws LifecycleException {
        block3: {
            if (!this.started) {
                throw new LifecycleException("Not started");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.server == null) break block3;
            try {
                this.server.close();
            }
            catch (IOException e) {
                this.logger.log("Cannot close ServerSocket", e);
            }
        }
    }
}

