/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.test;

import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.lang.Parser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Main {
    public static void main(String[] stringArray) {
        Parser parser;
        stringArray = new String[]{"x509.asn", "1eecert.x509"};
        String string = stringArray[0];
        String string2 = stringArray[1];
        System.out.println();
        System.out.println("1. Parsing \"" + string + "\"...");
        try {
            parser = new Parser(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("*** \"" + string + "\" not found in work directory...");
            return;
        }
        ASNSpecification aSNSpecification = null;
        try {
            aSNSpecification = parser.Specification(false);
            System.out.println();
            System.out.println("2. Result of compilation: ");
            aSNSpecification.dump();
            System.out.println();
            System.out.println("3. Current symbol table:");
            Parser.dumpSymbolTable();
            System.out.println();
            int n = Parser.countUnresolvedReferences();
            System.out.println("4. Number of unresolved references: " + n);
        }
        catch (ParseException parseException) {
            System.out.println("*** Failed parsing...");
            System.out.println("*** " + parseException.getMessage() + "...");
            parseException.printStackTrace(System.out);
        }
        System.out.println();
        System.out.println("5. Can we access a \"Certificate\" from an x509 struct?");
        ASNObject aSNObject = aSNSpecification.getComponent("Certificate");
        aSNObject.dump("Certificate --> ");
        System.out.println();
        System.out.println("6. Can we access \"" + string2 + "\" ?");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("*** \"" + string2 + "\" not found in work directory...");
            return;
        }
        System.out.println("Yes...");
        System.out.println();
        System.out.println("7. Can we access the x509 instance present inside?");
        CoderOperations coderOperations = BaseCoder.getInstance("DER");
        if (coderOperations == null) {
            return;
        }
        coderOperations.init(fileInputStream);
        try {
            aSNObject.accept(coderOperations, null);
            aSNObject.dump();
            System.out.println();
            System.out.println("8. Can we identify its signature algorithm?");
            System.out.println();
            ASNObject aSNObject2 = null;
            ASNObject aSNObject3 = aSNObject.getComponent("Certificate.tbsCertificate");
            aSNObject3.dump("8.1. Certificate.tbsCertificate --> ");
            System.out.println();
            ASNObject aSNObject4 = aSNObject3.getComponent("TBSCertificate.signature");
            aSNObject4.dump("8.2. TBSCertificate.signature --> ");
            System.out.println();
            aSNObject2 = aSNObject4.getComponent("AlgorithmIdentifier.algorithm");
            aSNObject2.dump("8.3. AlgorithmIdentifier.algorithm --> ");
            System.out.println();
            System.out.println("Issuer's signature algorithm OID (#1) is: " + aSNObject2.getValue());
            System.out.println();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        System.out.println();
        System.out.println("Done all tests...");
    }
}

