/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.lang.PackageProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;

public class Tag {
    private static final String NAME = "Tag";
    private static final boolean IN = true;
    private static final boolean OUT = false;
    private static final boolean DEBUG = false;
    private static final int debuglevel = 0;
    private static final PrintWriter err = null;
    private static final boolean TRACE = PackageProperties.isTraceable("Tag");
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCE_OF = 48;
    public static final int SET = 17;
    public static final int SET_OF = 49;
    public static final int PRINT_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int IA5_STRING = 22;
    public static final int UTC_TIME = 23;
    int clazz;
    int value;
    boolean explicit;
    boolean constructed;
    static final boolean tagdbug = false;
    private static String[] tabx = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private static void debug(String string) {
        err.println(">>> Tag: " + string);
    }

    private static void trace(boolean bl, String string) {
        if (TRACE) {
            err.println((bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    private static void trace(String string) {
        if (TRACE) {
            err.println("<=> Tag." + string);
        }
    }

    Tag(int n, int n2, boolean bl, boolean bl2) {
        this.clazz = n;
        this.value = n2;
        this.explicit = bl;
        this.constructed = bl2;
    }

    Tag(int n, int n2, boolean bl) {
        this(n, n2, bl, false);
    }

    Tag(int n, boolean bl) {
        this(0, n, bl);
    }

    public int getClazz() {
        return this.clazz;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tag getExpectedTag(int n, int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4;
        ByteArrayOutputStream byteArrayOutputStream;
        Tag tag;
        block14: {
            Tag tag2;
            block13: {
                Tag tag3;
                block12: {
                    tag = null;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n4 = -1;
                    n3 = -1;
                    try {
                        int n5 = inputStream.read();
                        if (n5 < 0) {
                            tag3 = null;
                            Object var13_9 = null;
                            break block12;
                        }
                        byteArrayOutputStream.write(n5 &= 0xFF);
                        n4 = n5 & 0xC0;
                        boolean bl = (n5 & 0x20) != 0;
                        n3 = n5 & 0x1F;
                        if (n3 == 31) {
                            n3 = 0;
                            n5 = inputStream.read();
                            if (n5 < 0) {
                                tag2 = null;
                                break block13;
                            }
                            n5 &= 0xFF;
                            do {
                                n3 += n5 & 0x80;
                                n5 = inputStream.read();
                                if (n5 < 0) {
                                    Tag tag4 = null;
                                    Object var13_11 = null;
                                    if (!Tag.eval(n4, n, n3, n2)) {
                                        tag = null;
                                        byte[] byArray = byteArrayOutputStream.toByteArray();
                                        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 2048);
                                        pushbackInputStream.unread(byArray);
                                        inputStream = pushbackInputStream;
                                    }
                                    byteArrayOutputStream = null;
                                    return tag4;
                                }
                                byteArrayOutputStream.write(n5 &= 0xFF);
                            } while ((n5 & 0x80) != 0);
                        }
                        tag = new Tag(n4, n3, true, bl);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        if (!Tag.eval(n4, n, n3, n2)) {
                            tag = null;
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 2048);
                            pushbackInputStream.unread(byArray);
                            inputStream = pushbackInputStream;
                        }
                        byteArrayOutputStream = null;
                        throw throwable;
                    }
                }
                if (!Tag.eval(n4, n, n3, n2)) {
                    tag = null;
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 2048);
                    pushbackInputStream.unread(byArray);
                    inputStream = pushbackInputStream;
                }
                byteArrayOutputStream = null;
                return tag3;
            }
            Object var13_10 = null;
            if (!Tag.eval(n4, n, n3, n2)) {
                tag = null;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 2048);
                pushbackInputStream.unread(byArray);
                inputStream = pushbackInputStream;
            }
            byteArrayOutputStream = null;
            return tag2;
        }
        Object var13_12 = null;
        if (!Tag.eval(n4, n, n3, n2)) {
            tag = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, 2048);
            pushbackInputStream.unread(byArray);
            inputStream = pushbackInputStream;
        }
        byteArrayOutputStream = null;
        return tag;
    }

    public static Tag getExpectedTag(int n, InputStream inputStream) throws IOException {
        return Tag.getExpectedTag(0, n, inputStream);
    }

    public static Tag getExpectedTag(Tag tag, InputStream inputStream) throws IOException {
        return Tag.getExpectedTag(tag.getClazz(), tag.getValue(), inputStream);
    }

    public static byte[] getTag(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read();
        if (n == -1) {
            return null;
        }
        byteArrayOutputStream.write(n &= 0xFF);
        boolean bl = false;
        if ((n & 0x1F) == 31) {
            do {
                n = inputStream.read() & 0xFF;
                byteArrayOutputStream.write(n);
            } while ((n & 0x80) != 0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String toHex(int n) {
        int n2 = (n & 0xF0) >>> 4;
        int n3 = n & 0xF;
        String string = tabx[n2] + tabx[n3];
        return string;
    }

    public static Tag decode(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = n & 0xC0;
        boolean bl = (n & 0x20) != 0;
        int n3 = n & 0x1F;
        if (n3 == 31) {
            n3 = 0;
            n = inputStream.read() & 0xFF;
            do {
                n3 += n & 0x80;
            } while (((n = inputStream.read() & 0xFF) & 0x80) != 0);
        }
        Tag tag = new Tag(n2, n3, true, bl);
        return tag;
    }

    public static Tag peek(InputStream inputStream) throws IOException {
        inputStream.mark(Integer.MAX_VALUE);
        Tag tag = null;
        try {
            tag = Tag.decode(inputStream);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            inputStream.reset();
            throw throwable;
        }
        inputStream.reset();
        return tag;
    }

    private static boolean eval(int n, int n2, int n3, int n4) {
        if (n != n2) {
            return false;
        }
        if (n != 0) {
            return n3 == n4;
        }
        if (n4 == 19 || n4 == 22 || n3 == 20) {
            return n3 == 19 || n3 == 22 || n3 == 20;
        }
        return n3 == n4;
    }

    public String toString() {
        String string = "<Tag class=\"";
        switch (this.clazz) {
            case 0: {
                string = string + "UNIVERSAL (0)";
                break;
            }
            case 64: {
                string = string + "APPLICATION (64)";
                break;
            }
            case 128: {
                string = string + "CONTEXT (128)";
                break;
            }
            case 192: {
                string = string + "PRIVATE (192)";
                break;
            }
            default: {
                string = string + "" + this.clazz;
            }
        }
        string = string + "\" value=\"";
        if (this.clazz == 128) {
            string = string + "" + this.value;
        } else {
            switch (this.value) {
                case 1: {
                    string = string + "BOOLEAN (1)";
                    break;
                }
                case 2: {
                    string = string + "INTEGER (2)";
                    break;
                }
                case 3: {
                    string = string + "BIT STRING (3)";
                    break;
                }
                case 4: {
                    string = string + "OCTET STRING (4)";
                    break;
                }
                case 5: {
                    string = string + "NULL (5)";
                    break;
                }
                case 6: {
                    string = string + "OBJECT_IDENTIFIER (6)";
                    break;
                }
                case 16: {
                    string = string + "SEQUENCE (16)";
                    break;
                }
                case 17: {
                    string = string + "SET (17)";
                    break;
                }
                case 19: {
                    string = string + "PrintableString (19)";
                    break;
                }
                case 20: {
                    string = string + "T61String (20)";
                    break;
                }
                case 22: {
                    string = string + "IA5String (22)";
                    break;
                }
                case 23: {
                    string = string + "UTCTime (23)";
                    break;
                }
                default: {
                    string = string + "" + this.value;
                }
            }
        }
        string = string + "\" explicit=\"" + (this.explicit ? "yes" : "no");
        string = string + "\" constructed=\"" + (this.constructed ? "yes" : "no") + "\" />";
        return string;
    }
}

