/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LRUMap
extends HashMap
implements Externalizable {
    private int maximumSize;
    private ArrayList bubbleList;

    public LRUMap() {
        this(100);
    }

    public LRUMap(int n) {
        super(n);
        this.maximumSize = n;
        this.bubbleList = new ArrayList(n);
    }

    public Object removeLRU() {
        int n = this.size();
        Object e = this.bubbleList.remove(n);
        ValuePositionPair valuePositionPair = this.removePair(e);
        return e;
    }

    public Object get(Object object) {
        int n;
        Object e;
        ValuePositionPair valuePositionPair;
        ValuePositionPair valuePositionPair2 = this.getPair(object);
        if (valuePositionPair2 == null) {
            return null;
        }
        int n2 = valuePositionPair2.position;
        if (n2 > 0 && (valuePositionPair = this.getPair(e = this.bubbleList.get(n = n2 - 1))) != null) {
            valuePositionPair.position = n2;
            valuePositionPair2.position = n;
            this.bubbleList.set(n2, e);
            this.bubbleList.set(n, object);
        }
        return valuePositionPair2.value;
    }

    public Object put(Object object, Object object2) {
        int n = this.size();
        ValuePositionPair valuePositionPair = new ValuePositionPair(object2);
        if (n >= this.maximumSize) {
            int n2;
            valuePositionPair.position = n2 = this.maximumSize - 1;
            Object object3 = this.bubbleList.set(n2, object);
            super.remove(object3);
        } else {
            valuePositionPair.position = n;
            this.bubbleList.add(n, object);
        }
        valuePositionPair = this.putPair(object, valuePositionPair);
        return valuePositionPair != null ? valuePositionPair.value : null;
    }

    public Object remove(Object object) {
        ValuePositionPair valuePositionPair = this.removePair(object);
        return valuePositionPair != null ? valuePositionPair.value : null;
    }

    public boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.pairIterator();
        while (iterator.hasNext()) {
            ValuePositionPair valuePositionPair = (ValuePositionPair)iterator.next();
            Object object2 = valuePositionPair.value;
            if (object == object2) {
                return true;
            }
            if (object == null || !object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public Set keySet() {
        return super.keySet();
    }

    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            ValuePositionPair valuePositionPair = (ValuePositionPair)entry.getValue();
            Object object = valuePositionPair.value;
            Entry entry2 = new Entry(k, object);
            hashSet.add(entry2);
        }
        return hashSet;
    }

    public Collection values() {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Iterator iterator = super.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Entry entry2 = new Entry(entry.getKey(), entry.getValue());
            arrayList.add(entry2);
        }
        return arrayList;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.maximumSize = objectInput.readInt();
        int n = objectInput.readInt();
        this.bubbleList = new ArrayList(this.maximumSize);
        int n2 = 0;
        while (n2 < n) {
            this.bubbleList.add("");
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            ValuePositionPair valuePositionPair = (ValuePositionPair)object2;
            int n4 = valuePositionPair.position;
            this.bubbleList.set(n4, valuePositionPair);
            this.putPair(object, valuePositionPair);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.maximumSize);
        objectOutput.writeInt(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            objectOutput.writeObject(e);
            ValuePositionPair valuePositionPair = this.getPair(e);
            objectOutput.writeObject(valuePositionPair);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int n) {
        this.maximumSize = n;
    }

    protected ValuePositionPair getPair(Object object) {
        return (ValuePositionPair)super.get(object);
    }

    protected ValuePositionPair putPair(Object object, ValuePositionPair valuePositionPair) {
        return super.put(object, valuePositionPair);
    }

    protected ValuePositionPair removePair(Object object) {
        return (ValuePositionPair)super.remove(object);
    }

    protected Iterator pairIterator() {
        return super.values().iterator();
    }

    class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            this.value = object;
            LRUMap.this.put(this.key, object);
            return object;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    protected static class ValuePositionPair
    implements Serializable {
        public Object value;
        public int position;

        public ValuePositionPair() {
        }

        public ValuePositionPair(Object object) {
            this.value = object;
        }

        public String toString() {
            return "[ " + this.position + ": " + this.value + " ]";
        }
    }
}

