/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.test.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jxta.impl.index.IndexServiceImpl;
import net.jxta.index.IndexService;

public class IndexServiceTest {
    public static void main(String[] stringArray) throws IOException, IndexService.BadDocumentException, IndexService.BadQueryException, IndexService.IndexException, InterruptedException {
        IndexServiceImpl indexServiceImpl = new IndexServiceImpl();
        IndexService.Index index = indexServiceImpl.getIndex(new File(stringArray[0]));
        int n = 0;
        while (n < 10) {
            IndexServiceTest.test(indexServiceImpl, index, stringArray, 1, stringArray.length - 2, stringArray[stringArray.length - 1]);
            ++n;
        }
        Thread.currentThread();
        Thread.sleep(3600000L);
    }

    static void test(IndexService indexService, IndexService.Index index, String[] stringArray, int n, int n2, String string) throws IOException, IndexService.BadDocumentException, IndexService.BadQueryException, IndexService.IndexException {
        int n3 = n;
        while (n3 < n + n2) {
            System.out.println("\nIndexing " + stringArray[n3]);
            IndexServiceTest.addFile(index, stringArray[n3]);
            System.out.println("Stats:");
            ((IndexServiceImpl)indexService).printStats();
            ++n3;
        }
        String[] stringArray2 = index.query(string);
        System.out.println("Result set: " + stringArray2.length + " items:");
        int n4 = 0;
        while (stringArray2 != null && n4 < stringArray2.length) {
            System.out.println("\t" + n4 + " " + stringArray2[n4]);
            ++n4;
        }
        int n5 = n;
        while (n5 < n + n2) {
            System.out.println("Removing " + stringArray[n5]);
            IndexServiceTest.removeFile(index, stringArray[n5]);
            stringArray2 = index.query(string);
            System.out.println("Result set: " + stringArray2.length + " items:");
            int n6 = 0;
            while (stringArray2 != null && n6 < stringArray2.length) {
                System.out.println("\t" + n6 + " " + stringArray2[n6]);
                ++n6;
            }
            ++n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeFile(IndexService.Index index, String string) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            index.remove(string, fileInputStream);
            Object var5_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addFile(IndexService.Index index, String string) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            index.add(string, fileInputStream);
            System.out.println("Finalizing...");
            Runtime.getRuntime().runFinalization();
            System.out.println("Garbage-collecting...");
            Runtime.getRuntime().gc();
            Object var5_4 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

