/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class PeerGroupFactory {
    private static Class stdPeerGroupClass;
    private static Class platformClass;

    public static void setStdPeerGroupClass(Class clazz) {
        stdPeerGroupClass = clazz;
    }

    public static void setPlatformClass(Class clazz) {
        platformClass = clazz;
    }

    public static PeerGroup newPeerGroup() {
        try {
            return (PeerGroup)stdPeerGroupClass.newInstance();
        }
        catch (Exception exception) {
            throw new JxtaError("No valid Standard PeerGroup class");
        }
    }

    public static PeerGroup newPlatform() {
        PeerGroup peerGroup = null;
        try {
            peerGroup = (PeerGroup)platformClass.newInstance();
        }
        catch (Exception exception) {
            throw new JxtaError("No valid Platform class");
        }
        try {
            peerGroup.init(null, null, null);
        }
        catch (Exception exception) {
            throw new JxtaError("Platform.init failed");
        }
        return peerGroup;
    }

    public static PeerGroup newNetPeerGroup(PeerGroup peerGroup) throws PeerGroupException {
        try {
            ModuleImplAdvertisement moduleImplAdvertisement = peerGroup.getAllPurposePeerGroupImplAdvertisement();
            moduleImplAdvertisement.setModuleSpecID(PeerGroup.refNetPeerGroupSpecID);
            moduleImplAdvertisement.setCode("net.jxta.impl.peergroup.ShadowPeerGroup");
            moduleImplAdvertisement.setDescription("Default NetPeerGroup reference implementation.");
            PeerGroupID peerGroupID = PeerGroupID.defaultNetPeerGroupID;
            PeerGroup peerGroup2 = peerGroup.newGroup(peerGroupID, moduleImplAdvertisement, "NetPeerGroup", "NetPeerGroup by default");
            return peerGroup2;
        }
        catch (Exception exception) {
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public static PeerGroup newNetPeerGroup() throws PeerGroupException {
        try {
            PeerGroupFactory.setPlatformClass(Class.forName("net.jxta.impl.peergroup.Platform"));
            PeerGroupFactory.setStdPeerGroupClass(Class.forName("net.jxta.impl.peergroup.StdPeerGroup"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PeerGroupException("Unable to find class :" + classNotFoundException.getMessage());
        }
        PeerGroup peerGroup = PeerGroupFactory.newPlatform();
        PeerGroup peerGroup2 = PeerGroupFactory.newNetPeerGroup(peerGroup);
        return peerGroup2;
    }
}

