/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.impl.util.PendingAction;
import net.jxta.impl.util.SchedulerPriorityQueue;

public class SchedulerService
implements Runnable {
    volatile boolean done = false;
    SchedulerPriorityQueue heap = new SchedulerPriorityQueue(1024, 2);

    public synchronized Object scheduleAction(Action action, long l) {
        PendingAction pendingAction = new PendingAction(action, System.currentTimeMillis() + l);
        this.heap.put(pendingAction);
        if (this.heap.top() == pendingAction) {
            this.notify();
        }
        return pendingAction;
    }

    public synchronized void cancelAction(Object object) {
        PendingAction pendingAction = (PendingAction)object;
        pendingAction.cancel();
        if (this.heap.top() == pendingAction) {
            this.notify();
        }
    }

    public void run() {
        while (!this.done) {
            PendingAction pendingAction = this.getNextEvent();
            if (pendingAction == null || this.done) break;
            try {
                pendingAction.perform(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private synchronized PendingAction getNextEvent() {
        if (this.done) {
            return null;
        }
        PendingAction pendingAction = (PendingAction)this.heap.top();
        long l = pendingAction == null ? Long.MAX_VALUE : pendingAction.time - System.currentTimeMillis();
        try {
            while (!this.done) {
                if (l > 0L) {
                    this.wait(l);
                }
                if (!this.done) {
                    if (pendingAction != this.heap.top()) {
                        pendingAction = (PendingAction)this.heap.top();
                        l = pendingAction.time - System.currentTimeMillis();
                        continue;
                    }
                    this.heap.pop();
                    return pendingAction;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            this.done = true;
        }
        return null;
    }

    public static interface Action {
        public void perform(SchedulerService var1);
    }
}

