/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RendAddrCompactor
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendAddrCompactor == null ? (class$net$jxta$impl$rendezvous$RendAddrCompactor = RendAddrCompactor.class$("net.jxta.impl.rendezvous.RendAddrCompactor")) : class$net$jxta$impl$rendezvous$RendAddrCompactor).getName());
    private PeerGroup myGroup;
    private EndpointService endpoint;
    private DiscoveryService discovery;
    private RendezVousService rendezvous = null;
    private String localPeerId = null;
    private Vector initialParams = null;
    private Thread myThread = null;
    protected boolean stopping = false;
    private RdvListener rdvListener = null;
    private static final int MaxNbOfRdvs = 3;
    private static final long DiscoveryLongNap = 2400000L;
    private static final long DiscoveryMediumNap = 1200000L;
    private static final long DiscoveryShortNap = 600000L;
    private static final int MaxNbOfConnectThreads = 5;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendAddrCompactor;

    private EndpointAddress mkAddress(String string) {
        try {
            PeerID peerID = (PeerID)IDFactory.fromURL(new URL(string));
            String string2 = "jxta://" + peerID.getUniqueValue().toString();
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string2);
            return endpointAddress;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + string));
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String string, String string2, String string3) {
        EndpointAddress endpointAddress = this.mkAddress(string);
        endpointAddress.setServiceName(string2);
        endpointAddress.setServiceParameter(string3);
        return endpointAddress;
    }

    public RendAddrCompactor(PeerGroup peerGroup, Vector vector) {
        this.myGroup = peerGroup;
        this.initialParams = vector;
        this.endpoint = this.myGroup.getEndpointService();
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.rdvListener = new RdvListener(this);
        RefPeerGroup refPeerGroup = ((RefPeerGroup)this.myGroup).getParentGroup();
        this.discovery = refPeerGroup != null ? refPeerGroup.getDiscoveryService() : this.myGroup.getDiscoveryService();
        this.rendezvous = this.myGroup.getRendezVousService();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Start compacting");
        }
        this.myThread = new Thread((Runnable)this, "RendezvousService:RendezvousCompactor");
        this.myThread.start();
    }

    public void shutdown() {
        this.stopping = true;
        this.myThread.interrupt();
    }

    public void run() {
        try {
            Vector vector = (Vector)this.initialParams.clone();
            RdvMonitor rdvMonitor = new RdvMonitor(this.myGroup, (RendezVousServiceImpl)this.rendezvous);
            this.rendezvous.setMonitor(rdvMonitor);
            RefPeerGroup refPeerGroup = null;
            RefPeerGroup refPeerGroup2 = ((RefPeerGroup)this.myGroup).getParentGroup();
            if (refPeerGroup2 != null) {
                refPeerGroup = refPeerGroup2.getParentGroup();
            }
            if (refPeerGroup == null) {
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        block27: {
                            String string = (String)vector.elementAt(n);
                            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string);
                            try {
                                this.rendezvous.connectToRendezVous(endpointAddress);
                            }
                            catch (Exception exception) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block27;
                                LOG.debug((Object)("Cannot connect to Rendezvous at " + string + ":" + exception));
                            }
                        }
                        ++n;
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Network peergroup Done compacting");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Regular group... Find rendezvous");
            }
            String string = this.myGroup.getPeerGroupID().toString();
            vector = this.searchLocal(string);
            this.connect(vector, 5);
            Object var6_9 = null;
            Enumeration enumeration = null;
            Vector vector2 = null;
            boolean bl = false;
            while (true) {
                if (this.stopping) {
                    return;
                }
                enumeration = this.rendezvous.getConnectedRendezVous();
                if (!enumeration.hasMoreElements()) {
                    vector2 = null;
                } else {
                    vector2 = new Vector();
                    while (enumeration.hasMoreElements()) {
                        try {
                            vector2.addElement(enumeration.nextElement());
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                }
                boolean bl2 = false;
                if (vector2 != null && vector2.size() > 0) {
                    bl2 = true;
                }
                this.searchRemote(string);
                if (bl2 && vector2.size() >= 3) {
                    try {
                        Thread.sleep(2400000L);
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)("Exception " + exception));
                    }
                    continue;
                }
                if (bl2) {
                    try {
                        Thread.sleep(1200000L);
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)("Exception " + exception));
                    }
                    continue;
                }
                try {
                    Thread.sleep(600000L);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("Exception " + exception));
                }
            }
        }
        catch (Throwable throwable) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread: " + Thread.currentThread().getName()), throwable);
            }
            return;
        }
    }

    protected void processRdvAdv(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        Vector vector2 = new Vector();
        Enumeration enumeration = null;
        enumeration = this.rendezvous.getConnectedRendezVous();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                try {
                    vector2.addElement(enumeration.nextElement());
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        if ((enumeration = this.rendezvous.getConnectedPeers()) != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                try {
                    vector2.addElement(enumeration.nextElement());
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            block13: {
                try {
                    RdvAdvertisement rdvAdvertisement = (RdvAdvertisement)vector.elementAt(n);
                    String string = rdvAdvertisement.getPeerID().toString();
                    if (!vector2.contains(string)) {
                        vector3.add(string);
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                    LOG.debug((Object)"processRdvAdv failed ", (Throwable)exception);
                }
            }
            ++n;
        }
        this.connect(vector3, 1);
    }

    private void connect(Vector vector, int n) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        String string = null;
        Stack<EndpointAddress> stack = new Stack<EndpointAddress>();
        int n2 = 0;
        while (n2 < vector.size()) {
            block10: {
                try {
                    string = (String)vector.elementAt(n2);
                    if (!string.equals(this.localPeerId)) {
                        try {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"  Connecting...");
                            }
                            EndpointAddress endpointAddress = this.mkAddress(string);
                            stack.push(endpointAddress);
                        }
                        catch (Exception exception) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Cannot connect to Rendezvous at " + string));
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("  failed with " + exception));
                }
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Thread thread = new Thread((Runnable)new ConnectThread(stack, this.rendezvous, this), "Rendezvous Connect Thread");
            thread.start();
            Thread.currentThread();
            Thread.yield();
            ++n3;
        }
    }

    private void searchRemote(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"searching remote");
        }
        if (string == null) {
            return;
        }
        this.discovery.getRemoteAdvertisements(null, 2, "RdvGroupId", string, 3, this.rdvListener);
    }

    private Vector searchLocal(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"searching local");
        }
        if (string == null) {
            return null;
        }
        Enumeration enumeration = null;
        try {
            enumeration = this.discovery.getLocalAdvertisements(2, "RdvGroupId", string);
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Caught IOException");
            }
            return null;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            try {
                RdvAdvertisement rdvAdvertisement = (RdvAdvertisement)enumeration.nextElement();
                vector.addElement(rdvAdvertisement.getPeerID().toString());
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("Failed with " + exception));
            }
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ RendezVousService access$000(RendAddrCompactor rendAddrCompactor) {
        return rendAddrCompactor.rendezvous;
    }

    static /* synthetic */ Category access$100() {
        return LOG;
    }

    class RdvListener
    implements DiscoveryListener {
        private RendAddrCompactor caller = null;

        public RdvListener(RendAddrCompactor rendAddrCompactor2) {
            this.caller = rendAddrCompactor2;
        }

        public void discoveryEvent(DiscoveryEvent discoveryEvent) {
            DiscoveryResponseMsg discoveryResponseMsg = discoveryEvent.getResponse();
            Enumeration enumeration = discoveryResponseMsg.getResponses();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            boolean bl = false;
            Vector<RdvAdvertisement> vector = new Vector<RdvAdvertisement>();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    RdvAdvertisement rdvAdvertisement = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(string.getBytes()));
                    if (rdvAdvertisement == null) continue;
                    vector.add(rdvAdvertisement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (vector.size() > 0) {
                this.caller.processRdvAdv(vector);
            }
        }
    }

    protected class ConnectThread
    implements Runnable {
        private Stack addrs = null;
        private RendezVousService rdv = null;
        private RendAddrCompactor compactor = null;

        public ConnectThread(Stack stack, RendezVousService rendezVousService, RendAddrCompactor rendAddrCompactor2) {
            this.addrs = stack;
            this.rdv = rendezVousService;
            this.compactor = rendAddrCompactor2;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = RendAddrCompactor.access$000(RendAddrCompactor.this).getConnectedRendezVous();
            var2_2 = 0;
            if (var1_1 != null) {
                try {
                    while (var1_1.hasMoreElements()) {
                        var1_1.nextElement();
                        ++var2_2;
                    }
                }
                catch (Exception var3_3) {
                    // empty catch block
                }
                if (var2_2 >= 3) {
                    return;
                }
            }
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.addrs.size() <= 0) {
                        return;
                    }
                    if (this.compactor.stopping) {
                        return;
                    }
                    try {
                        var3_4 = (EndpointAddress)this.addrs.pop();
                        this.rdv.connectToRendezVous(var3_4);
                    }
                    catch (EmptyStackException var3_5) {
                        return;
                    }
                    catch (Exception var4_7) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var3_6) {
                if (RendAddrCompactor.access$100().isEnabledFor(Priority.FATAL) == false) return;
                RendAddrCompactor.access$100().fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), var3_6);
            }
            ** GOTO lbl-1000
        }
    }
}

