/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.util.JxtaTimer;
import net.jxta.impl.util.JxtaTimerHandler;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.rendezvous.RendezVousMonitor;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RdvMonitor
implements RendezVousMonitor,
JxtaTimerHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RdvMonitor == null ? (class$net$jxta$impl$rendezvous$RdvMonitor = RdvMonitor.class$("net.jxta.impl.rendezvous.RdvMonitor")) : class$net$jxta$impl$rendezvous$RdvMonitor).getName());
    private static final long LeaseMargin = 600000L;
    private static final long LeaseRenewalDelay = 120000L;
    private PeerGroup group = null;
    private String gId = null;
    private DiscoveryService discovery = null;
    private long lease = 0L;
    private JxtaTimer timer = null;
    private Vector rdvs = null;
    private RendezVousServiceImpl rendezvous = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RdvMonitor;

    public RdvMonitor(PeerGroup peerGroup, RendezVousServiceImpl rendezVousServiceImpl) {
        this.group = peerGroup;
        this.gId = peerGroup.getPeerGroupID().toString();
        this.rdvs = new Vector();
        this.timer = null;
        this.rendezvous = rendezVousServiceImpl;
        this.discovery = this.group.getDiscoveryService();
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 120000L);
        }
    }

    public void connected(PeerID peerID, long l) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connected: new connection to a RendezVousService");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   peer = " + peerID.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  lease = " + l));
            }
        }
        this.addRendezVous(peerID.toString(), l);
        this.publishAdv(peerID, l);
    }

    public void disconnected(PeerID peerID) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"disconnected with RendezVousService");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("     peerId = " + peerID.toString()));
            }
        }
    }

    public void discovered(Advertisement advertisement) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"discovered: got new RendezVousService advertisement.");
        }
        if (this.discovery != null) {
            try {
                this.discovery.publish(advertisement, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void signal(JxtaTimer jxtaTimer) {
        if (this.group.isRendezvous()) {
            this.publishAdv(this.group.getPeerID(), 120000L);
        }
        if (this.rdvs == null) {
            return;
        }
        RdV rdV = null;
        int n = 0;
        while (n < this.rdvs.size()) {
            try {
                rdV = (RdV)this.rdvs.elementAt(n);
                if (rdV.lease - System.currentTimeMillis() < 600000L) {
                    this.rendezvous.reconnectToRendezVous(rdV.peer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private synchronized void addRendezVous(String string, long l) {
        RdV rdV = new RdV(string);
        if (this.rdvs.contains(rdV)) {
            try {
                int n = this.rdvs.indexOf(rdV);
                if (n == -1) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"addRendezVous cannot access RdV object");
                    }
                    return;
                }
                rdV = (RdV)this.rdvs.elementAt(n);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("addRendez failed [1] " + exception));
                }
            }
        } else {
            this.rdvs.addElement(rdV);
        }
        long l2 = System.currentTimeMillis();
        if (l < 0L) {
            l = 3600000L;
        }
        rdV.lease = l2 + l;
        if (this.timer == null) {
            this.timer = new JxtaTimer(this, 120000L, true);
        }
    }

    private RdvAdvertisement createRdvAdv(PeerGroupID peerGroupID, PeerID peerID, long l) {
        RdvAdvertisement rdvAdvertisement = null;
        try {
            rdvAdvertisement = (RdvAdvertisement)AdvertisementFactory.newAdvertisement(RdvAdvertisement.getAdvertisementType());
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Advertisement document could not be created");
            }
            return null;
        }
        rdvAdvertisement.setGroupID(peerGroupID);
        rdvAdvertisement.setPeerID(peerID);
        return rdvAdvertisement;
    }

    protected void startRdv() {
        this.publishAdv(this.group.getPeerID(), 120000L);
    }

    private void publishAdv(PeerID peerID, long l) {
        block10: {
            RdvAdvertisement rdvAdvertisement;
            if (LOG.isDebugEnabled()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Publish RdvAdvertisement:");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("        gid = " + this.group.getPeerGroupID().toString()));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("        pid = " + peerID.toString()));
                }
            }
            if ((rdvAdvertisement = this.createRdvAdv(this.group.getPeerGroupID(), peerID, l)) == null) {
                return;
            }
            RefPeerGroup refPeerGroup = ((GenericPeerGroup)this.group).getParentGroup();
            if (refPeerGroup == null) {
                return;
            }
            DiscoveryService discoveryService = refPeerGroup.getDiscoveryService();
            if (discoveryService == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cannot access parent's DiscoveryService Service");
                }
                return;
            }
            try {
                discoveryService.publish(rdvAdvertisement, 2, l, l);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                LOG.warn((Object)"Cannot locally publish advertisement");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RdV {
        protected String peer;
        protected long lease;

        public RdV(String string) {
            this.peer = string;
            this.lease = 0L;
        }

        public boolean equals(Object object) {
            RdV rdV = (RdV)object;
            return rdV.peer.equals(this.peer);
        }
    }
}

