/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.MessageSender;
import net.jxta.impl.relay.RelayServer;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RelayClientMessageSender
implements MessageSender {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$RelayClientMessageSender == null ? (class$net$jxta$impl$relay$RelayClientMessageSender = RelayClientMessageSender.class$("net.jxta.impl.relay.RelayClientMessageSender")) : class$net$jxta$impl$relay$RelayClientMessageSender).getName());
    RelayServer relayServer = null;
    private EndpointAddress localAddress = null;
    static /* synthetic */ Class class$net$jxta$impl$relay$RelayClientMessageSender;

    public RelayClientMessageSender(RelayServer relayServer, EndpointAddress endpointAddress) {
        this.relayServer = relayServer;
        this.localAddress = endpointAddress;
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Getting messenger for EndpointAddress: " + endpointAddress));
        }
        String string = RelayClientMessageSender.getPeerIdFromEndpointAddress(endpointAddress);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Getting messenger for Peer: " + string));
        }
        if (!this.relayServer.hasLease(string)) {
            throw new IOException("Destination peer has no lease");
        }
        return new RelayClientMessenger(this.relayServer, this.localAddress, endpointAddress);
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    public void init(EndpointService endpointService) {
    }

    public String getProtocolName() {
        return "http";
    }

    public boolean ping(EndpointAddress endpointAddress) {
        String string;
        boolean bl;
        block3: {
            bl = false;
            string = null;
            try {
                string = RelayClientMessageSender.getPeerIdFromEndpointAddress(endpointAddress);
                bl = this.relayServer.hasLease(string);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)("EndpointAddress malformed: " + endpointAddress));
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Ping for " + string + " is " + bl));
        }
        return bl;
    }

    private static String getPeerIdFromEndpointAddress(EndpointAddress endpointAddress) throws IOException {
        String string = endpointAddress.getProtocolAddress().substring("JxtaHttpClient".length());
        return string;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class RelayClientMessenger
    implements EndpointMessenger {
        RelayServer svr = null;
        EndpointAddress localAddress = null;
        EndpointAddress destAddress = null;
        String clientPeerId = null;
        BoundedQueue queue = null;

        public RelayClientMessenger(RelayServer relayServer, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) throws IOException {
            this.svr = relayServer;
            this.destAddress = endpointAddress2;
            this.localAddress = endpointAddress;
            this.clientPeerId = RelayClientMessageSender.getPeerIdFromEndpointAddress(endpointAddress2);
            this.queue = relayServer.getOutboundMessageQueueByPeerId(this.clientPeerId);
        }

        public void sendMessage(Message message) throws IOException {
            block6: {
                if (this.svr.hasLease(this.clientPeerId)) {
                    try {
                        this.addressMessage(message);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"enqueing message");
                        }
                        this.queue.enqueue(message, -2L);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"done enqueueing message");
                        }
                        break block6;
                    }
                    catch (InterruptedException interruptedException) {
                        if (LOG.isEnabledFor(Priority.INFO)) {
                            LOG.info((Object)"Message send interrupted; message thrown away");
                        }
                        break block6;
                    }
                }
                throw new IOException("Client peer no longer has a lease");
            }
        }

        public void close() {
        }

        private void addressMessage(Message message) {
            message.setDestinationAddress(this.destAddress);
            message.setSourceAddress(this.localAddress);
        }
    }
}

