/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointService;
import net.jxta.impl.endpoint.servlethttp.MessageReceiver;
import net.jxta.impl.relay.RelayLease;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class AbstractRelayClient
implements MessageReceiver {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$AbstractRelayClient == null ? (class$net$jxta$impl$relay$AbstractRelayClient = AbstractRelayClient.class$("net.jxta.impl.relay.AbstractRelayClient")) : class$net$jxta$impl$relay$AbstractRelayClient).getName());
    protected static Timer timer = new Timer(true);
    private static final int LEASE_RETRY_INTERVAL = 300000;
    private static final int LEASE_RENEWAL_DIV = 5;
    protected RelayLease lease = null;
    private TimerTask leaseRenewalTask = null;
    private boolean noLease = true;
    static /* synthetic */ Class class$net$jxta$impl$relay$AbstractRelayClient;

    public abstract boolean obtainLease();

    public abstract boolean renewLease();

    protected void recordLease(String string, String string2, int n) {
        this.lease = new RelayLease(string, string2, n);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Recorded lease; relayPeerId, leaseId, leaseLength==" + string + "," + string2 + "," + n));
        }
        this.leaseMode(n);
        this.onLeaseObtained();
    }

    public boolean isLeaseValid() {
        RelayLease relayLease = this.lease;
        if (relayLease == null) {
            return false;
        }
        return relayLease.isValid();
    }

    protected String getLeaseId() {
        RelayLease relayLease = this.lease;
        if (relayLease == null || !relayLease.isValid()) {
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("returning lease id = " + this.lease.getLeaseId()));
        }
        return relayLease.getLeaseId();
    }

    protected void nullifyLease() {
        this.lease = null;
    }

    protected abstract void onLeaseObtained();

    public void start() throws IOException {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"start");
        }
        this.noLease = false;
        this.lostLease();
    }

    public void lostLease() {
        if (this.noLease) {
            return;
        }
        this.noLeaseMode(true);
    }

    protected synchronized void noLeaseMode(boolean bl) {
        if (this.noLease) {
            return;
        }
        if (this.leaseRenewalTask != null) {
            this.leaseRenewalTask.cancel();
        }
        this.leaseRenewalTask = new LeaseRenewalTask();
        this.nullifyLease();
        this.noLease = true;
        timer.schedule(this.leaseRenewalTask, bl ? 0L : 300000L, 300000L);
    }

    protected synchronized void leaseMode(int n) {
        this.noLease = false;
        if (this.leaseRenewalTask != null) {
            this.leaseRenewalTask.cancel();
        }
        this.leaseRenewalTask = new LeaseRenewalTask();
        timer.schedule(this.leaseRenewalTask, n * 4 / 5, (long)(n / 5 / 2));
    }

    public void stop() throws InterruptedException {
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"stop");
        }
        timer.cancel();
        this.nullifyLease();
    }

    public abstract void init(PeerGroup var1, EndpointService var2, TransportAdvertisement var3) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LeaseRenewalTask
    extends TimerTask {
        LeaseRenewalTask() {
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("LeaseRenewalTask: trying to renew lease: " + AbstractRelayClient.this.getLeaseId()));
            }
            if (AbstractRelayClient.this.isLeaseValid()) {
                AbstractRelayClient.this.renewLease();
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  Lease is not valid; obtaining new lease");
                }
                AbstractRelayClient.this.noLeaseMode(false);
                AbstractRelayClient.this.obtainLease();
            }
        }
    }
}

