/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PipeAdvertisement;

public class PipeAdv
extends PipeAdvertisement {
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public PipeAdv() {
    }

    public PipeAdv(PipeID pipeID) {
        this.setPipeID(pipeID);
        this.setType("JxtaUnicast");
    }

    public PipeAdv(PipeID pipeID, String string) {
        this.setPipeID(pipeID);
        this.setName(string);
        this.setType("JxtaUnicast");
    }

    public PipeAdv(Element element) {
        this.initialize(element);
    }

    private void initialize(Element element) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = PipeAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        if (!textElement.getName().equals(PipeAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a '" + textElement.getName() + "'. Should be : " + PipeAdvertisement.getAdvertisementType());
        }
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (textElement2.getName().equals("Id")) {
                try {
                    URL uRL = new URL(textElement2.getTextValue());
                    this.setPipeID(IDFactory.fromURL(uRL));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (textElement2.getName().equals("Name")) {
                this.setName(textElement2.getTextValue());
                continue;
            }
            if (!textElement2.getName().equals("Type")) continue;
            this.setType(textElement2.getTextValue());
        }
        if (this.getPipeID().equals(ID.nullID)) {
            throw new IllegalArgumentException("Bad pipe ID in advertisement");
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, PipeAdvertisement.getAdvertisementType());
        if (this.getPipeID().equals(ID.nullID)) {
            throw new IllegalStateException("Pipe has no assigned ID");
        }
        TextElement textElement = structuredTextDocument.createElement("Id", this.getPipeID().toString());
        structuredTextDocument.appendChild(textElement);
        textElement = structuredTextDocument.createElement("Type", this.getType());
        structuredTextDocument.appendChild(textElement);
        if (this.getName() != null) {
            textElement = structuredTextDocument.createElement("Name", this.getName());
            structuredTextDocument.appendChild(textElement);
        }
        return structuredTextDocument;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PipeAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PipeAdv();
        }

        public Advertisement newInstance(Element element) {
            return new PipeAdv(element);
        }
    }
}

