/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.TransportAdvertisement;

public class HTTPAdv
extends TransportAdvertisement {
    private String proxy = null;
    private Vector routers = null;
    private String server = null;
    private String port = null;
    private String interfaceAddress = null;
    private String configMode = null;
    private static final String ProtocolTag = "Protocol";
    private static final String RouterTag = "Router";
    private static final String ProxyTag = "Proxy";
    private static final String ServerTag = "Server";
    private static final String PortTag = "Port";
    private static final String IntfAddrTag = "InterfaceAddress";
    private static final String ConfModeTag = "ConfigMode";
    private boolean proxyEnabled = true;
    private boolean routerEnabled = true;
    private boolean serverEnabled = true;
    private static final String RouterOffTag = "RouterOff";
    private static final String ProxyOffTag = "ProxyOff";
    private static final String ServerOffTag = "ServerOff";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public static String getAdvertisementType() {
        return "jxta:HTTPTransportAdvertisement";
    }

    public HTTPAdv() {
    }

    public HTTPAdv(Element element) {
        this.initialize(element);
    }

    public void initialize(Element element) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = HTTPAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        String string = textElement.getName();
        if (!string.equals(HTTPAdv.getAdvertisementType()) && !string.equals(TransportAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string2 = textElement2.getName();
            String string3 = null;
            if (string2.equals(RouterOffTag)) {
                this.routerEnabled = false;
                continue;
            }
            if (string2.equals(ProxyOffTag)) {
                this.proxyEnabled = false;
                continue;
            }
            if (string2.equals(ServerOffTag)) {
                this.serverEnabled = false;
                continue;
            }
            try {
                string3 = textElement2.getTextValue();
            }
            catch (Exception exception) {
                continue;
            }
            if (string2.equals(ProtocolTag)) {
                this.setProtocol(string3);
                continue;
            }
            if (string2.equals(IntfAddrTag)) {
                this.setInterfaceAddress(string3);
                continue;
            }
            if (string2.equals(ConfModeTag)) {
                this.setConfigMode(string3);
                continue;
            }
            if (string2.equals(PortTag)) {
                this.setPort(string3);
                continue;
            }
            if (string2.equals(RouterTag)) {
                if (this.routers == null) {
                    this.routers = new Vector();
                }
                this.routers.addElement(string3);
                continue;
            }
            if (string2.equals(ProxyTag)) {
                this.proxy = string3;
                continue;
            }
            if (!string2.equals(ServerTag)) continue;
            this.server = string3;
        }
        if (this.proxy == null) {
            this.proxyEnabled = false;
        }
        if (this.server == null) {
            this.serverEnabled = false;
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        TextElement textElement;
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, TransportAdvertisement.getAdvertisementType());
        if (structuredTextDocument instanceof Attributable) {
            ((Attributable)((Object)structuredTextDocument)).addAttribute("type", HTTPAdv.getAdvertisementType());
        }
        TextElement textElement2 = structuredTextDocument.createElement(ProtocolTag, this.getProtocol());
        structuredTextDocument.appendChild((Element)textElement2);
        TextElement textElement3 = structuredTextDocument.createElement(IntfAddrTag, this.getInterfaceAddress());
        structuredTextDocument.appendChild((Element)textElement3);
        TextElement textElement4 = structuredTextDocument.createElement(ConfModeTag, this.getConfigMode());
        structuredTextDocument.appendChild((Element)textElement4);
        TextElement textElement5 = structuredTextDocument.createElement(PortTag, this.getPort());
        structuredTextDocument.appendChild((Element)textElement5);
        if (this.routers != null) {
            Enumeration enumeration = this.routers.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                textElement = structuredTextDocument.createElement(RouterTag, string);
                structuredTextDocument.appendChild((Element)textElement);
            }
        }
        if (!this.routerEnabled) {
            textElement = structuredTextDocument.createElement(RouterOffTag);
            structuredTextDocument.appendChild((Element)textElement);
        }
        if (this.proxy != null) {
            textElement = structuredTextDocument.createElement(ProxyTag, this.proxy);
            structuredTextDocument.appendChild((Element)textElement);
            if (!this.proxyEnabled) {
                textElement = structuredTextDocument.createElement(ProxyOffTag);
                structuredTextDocument.appendChild((Element)textElement);
            }
        }
        if (this.server != null) {
            textElement = structuredTextDocument.createElement(ServerTag, this.server);
            structuredTextDocument.appendChild((Element)textElement);
            if (!this.serverEnabled) {
                textElement = structuredTextDocument.createElement(ServerOffTag);
                structuredTextDocument.appendChild((Element)textElement);
            }
        }
        return structuredTextDocument;
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String string) {
        this.interfaceAddress = string;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String string) {
        this.configMode = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Vector getRouters() {
        return this.routers;
    }

    public String getServer() {
        return this.server;
    }

    public boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    public boolean getRouterEnabled() {
        return this.routerEnabled;
    }

    public boolean getServerEnabled() {
        return this.serverEnabled;
    }

    public void setProxy(String string) {
        this.proxy = string;
        if (string == null) {
            this.proxyEnabled = false;
        }
    }

    public void setRouters(Vector vector) {
        this.routers = vector;
    }

    public void setServer(String string) {
        this.server = string;
        if (string == null) {
            this.serverEnabled = false;
        }
    }

    public void setProxyEnabled(boolean bl) {
        this.proxyEnabled = bl;
    }

    public void setRouterEnabled(boolean bl) {
        this.routerEnabled = bl;
    }

    public void setServerEnabled(boolean bl) {
        this.serverEnabled = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return HTTPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new HTTPAdv();
        }

        public Advertisement newInstance(Element element) {
            return new HTTPAdv(element);
        }
    }
}

