/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class StdPeerGroupParamAdv
extends Advertisement {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$StdPeerGroupParamAdv == null ? (class$net$jxta$impl$peergroup$StdPeerGroupParamAdv = StdPeerGroupParamAdv.class$("net.jxta.impl.peergroup.StdPeerGroupParamAdv")) : class$net$jxta$impl$peergroup$StdPeerGroupParamAdv).getName());
    private static final String paramTag = "Parm";
    private static final String protoTag = "Proto";
    private static final String appTag = "App";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String msidTag = "MSID";
    private static final String miaTag = ModuleImplAdvertisement.getAdvertisementType();
    private Hashtable servicesTable = null;
    private Hashtable protosTable = null;
    private Hashtable appsTable = null;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$StdPeerGroupParamAdv;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ID getID() {
        return null;
    }

    public StdPeerGroupParamAdv() {
        this.servicesTable = new Hashtable();
        this.protosTable = new Hashtable();
        this.appsTable = new Hashtable();
    }

    public StdPeerGroupParamAdv(Element element) throws PeerGroupException {
        try {
            this.initialize(element);
        }
        catch (Exception exception) {
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public Hashtable getServices() {
        return this.servicesTable;
    }

    public Hashtable getProtos() {
        return this.protosTable;
    }

    public Hashtable getApps() {
        return this.appsTable;
    }

    public void setServices(Hashtable hashtable) {
        this.servicesTable = hashtable == null ? new Hashtable() : hashtable;
    }

    public void setProtos(Hashtable hashtable) {
        this.protosTable = hashtable == null ? new Hashtable() : hashtable;
    }

    public void setApps(Hashtable hashtable) {
        this.appsTable = hashtable == null ? new Hashtable() : hashtable;
    }

    public void initialize(Element element) throws Exception {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = StdPeerGroupParamAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        if (!textElement.getName().equals(paramTag)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.servicesTable = new Hashtable();
        this.protosTable = new Hashtable();
        this.appsTable = new Hashtable();
        int n = 0;
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            Hashtable hashtable;
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string = textElement2.getName();
            if (string.equals(svcTag)) {
                hashtable = this.servicesTable;
            } else if (string.equals(appTag)) {
                hashtable = this.appsTable;
            } else {
                if (!string.equals(protoTag)) continue;
                hashtable = this.protosTable;
            }
            ModuleSpecID moduleSpecID = null;
            ModuleClassID moduleClassID = null;
            ModuleImplAdvertisement moduleImplAdvertisement = null;
            try {
                if (textElement2.getTextValue() != null) {
                    moduleSpecID = (ModuleSpecID)IDFactory.fromURL(new URL(textElement2.getTextValue()));
                }
                object = textElement2.getChildren();
                while (object.hasMoreElements()) {
                    TextElement textElement3 = (TextElement)object.nextElement();
                    if (textElement3.getName().equals(mcidTag)) {
                        moduleClassID = (ModuleClassID)IDFactory.fromURL(new URL(textElement3.getTextValue()));
                        continue;
                    }
                    if (textElement3.getName().equals(msidTag)) {
                        moduleSpecID = (ModuleSpecID)IDFactory.fromURL(new URL(textElement3.getTextValue()));
                        continue;
                    }
                    if (!textElement3.getName().equals(miaTag)) continue;
                    moduleImplAdvertisement = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(textElement3);
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Broken entry; skipping", (Throwable)exception);
                continue;
            }
            if (moduleImplAdvertisement == null && moduleSpecID == null) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Insufficent entry; skipping");
                continue;
            }
            if (moduleImplAdvertisement == null) {
                object = moduleSpecID;
            } else {
                moduleSpecID = moduleImplAdvertisement.getModuleSpecID();
                object = moduleImplAdvertisement;
            }
            if (moduleClassID == null) {
                moduleClassID = moduleSpecID.getBaseClass();
            }
            if (hashtable == this.appsTable && n++ != 0) {
                moduleClassID = IDFactory.newModuleClassID(moduleClassID);
            }
            hashtable.put(moduleClassID, object);
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, paramTag);
        }
        catch (Throwable throwable) {
            return null;
        }
        this.outputModules(structuredTextDocument, this.servicesTable, svcTag, mimeMediaType);
        this.outputModules(structuredTextDocument, this.protosTable, protoTag, mimeMediaType);
        this.outputModules(structuredTextDocument, this.appsTable, appTag, mimeMediaType);
        return structuredTextDocument;
    }

    private void outputModules(StructuredTextDocument structuredTextDocument, Hashtable hashtable, String string, MimeMediaType mimeMediaType) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            TextElement textElement;
            TextElement textElement2;
            ModuleClassID moduleClassID = (ModuleClassID)enumeration.nextElement();
            Object v = hashtable.get(moduleClassID);
            if (v instanceof Advertisement) {
                textElement2 = structuredTextDocument.createElement(string);
                structuredTextDocument.appendChild(textElement2);
                if (hashtable != this.appsTable && !moduleClassID.equals(moduleClassID.getBaseClass())) {
                    textElement = structuredTextDocument.createElement(mcidTag, moduleClassID.toString());
                    textElement2.appendChild(textElement);
                }
                textElement = (StructuredTextDocument)((Advertisement)v).getDocument(mimeMediaType);
                StructuredDocumentUtils.copyElements(structuredTextDocument, textElement2, textElement);
                continue;
            }
            if (v instanceof ModuleSpecID) {
                if (hashtable == this.appsTable || moduleClassID.equals(moduleClassID.getBaseClass())) {
                    textElement2 = structuredTextDocument.createElement(string, ((ModuleSpecID)v).toString());
                    structuredTextDocument.appendChild(textElement2);
                    continue;
                }
                textElement2 = structuredTextDocument.createElement(string);
                structuredTextDocument.appendChild(textElement2);
                textElement = structuredTextDocument.createElement(mcidTag, moduleClassID.toString());
                textElement2.appendChild(textElement);
                textElement = structuredTextDocument.createElement(msidTag, ((ModuleSpecID)v).toString());
                textElement2.appendChild(textElement);
                continue;
            }
            if (!LOG.isEnabledFor(Priority.WARN)) continue;
            LOG.warn((Object)"unsupported class in modules table");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

