/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class StdPeerGroup
extends GenericPeerGroup {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$StdPeerGroup == null ? (class$net$jxta$impl$peergroup$StdPeerGroup = StdPeerGroup.class$("net.jxta.impl.peergroup.StdPeerGroup")) : class$net$jxta$impl$peergroup$StdPeerGroup).getName());
    private boolean initialized = false;
    private Hashtable applications = new Hashtable();
    private Hashtable protocols = new Hashtable();
    public static final StructuredTextDocument stdCompatStatement;
    public static final String stdUri = "http://www.jxta.org/download/jxta.jar";
    public static final String stdProvider = "sun.com";
    private ModuleImplAdvertisement allPurposeImplAdv = null;
    Vector disabledModules = new Vector();
    static /* synthetic */ Class class$net$jxta$impl$peergroup$StdPeerGroup;

    private static StructuredTextDocument mkCS() {
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Comp");
            TextElement textElement = structuredTextDocument.createElement("Efmt", "JDK1.4");
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement("Bind", "V1.0 Ref Impl");
            structuredTextDocument.appendChild((Element)textElement);
            return structuredTextDocument;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Cannot create essential StructuredTextDocument.", (Throwable)exception);
            }
            throw new RuntimeException("Cannot create essential StructuredTextDocument.");
        }
    }

    protected ModuleImplAdvertisement mkImplAdvBuiltin(ModuleSpecID moduleSpecID, String string, String string2) {
        ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        moduleImplAdvertisement.setModuleSpecID(moduleSpecID);
        moduleImplAdvertisement.setCompat(stdCompatStatement);
        moduleImplAdvertisement.setCode(string);
        moduleImplAdvertisement.setUri(stdUri);
        moduleImplAdvertisement.setProvider(stdProvider);
        moduleImplAdvertisement.setDescription(string2);
        return moduleImplAdvertisement;
    }

    public boolean compatible(Element element) {
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        try {
            ((StructuredTextDocument)element).sendToWriter(stringWriter2);
            stdCompatStatement.sendToWriter(stringWriter);
        }
        catch (Exception exception) {
            return false;
        }
        return stringWriter2.toString().equals(stringWriter.toString());
    }

    protected void loadAllModules(Hashtable hashtable, ModuleClassID moduleClassID) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ModuleClassID moduleClassID2 = (ModuleClassID)enumeration.nextElement();
            Object v = hashtable.get(moduleClassID2);
            if (moduleClassID != null && !moduleClassID.equals(moduleClassID2)) continue;
            if (this.disabledModules.contains(moduleClassID2)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("disabled by configuration: " + moduleClassID2.toString() + "."));
                }
                hashtable.remove(moduleClassID2);
                if (moduleClassID == null) continue;
                break;
            }
            if (v instanceof Module) {
                if (moduleClassID == null) continue;
                break;
            }
            try {
                Module module = null;
                if (v instanceof ModuleImplAdvertisement) {
                    module = this.loadModule(moduleClassID2, (ModuleImplAdvertisement)v);
                } else if (v instanceof ModuleSpecID) {
                    module = this.loadModule(moduleClassID2, (ModuleSpecID)v, 1);
                } else {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("skipping: " + moduleClassID2.toString() + " (Unsupported descriptor)."));
                    }
                    hashtable.remove(moduleClassID2);
                    if (moduleClassID == null) continue;
                    break;
                }
                hashtable.put(moduleClassID2, module);
                if (v instanceof ModuleClassID) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("loaded: " + module.getClass().getName()));
                    }
                } else if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("loaded: " + ((ModuleImplAdvertisement)v).getDescription()));
                }
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Could not load module: ", (Throwable)exception);
                }
                if (v instanceof ModuleClassID) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("skipped: " + moduleClassID2.toString() + " (" + exception.getMessage() + ")."));
                    }
                } else if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("skipped: " + ((ModuleImplAdvertisement)v).getDescription() + " (" + exception.getMessage() + ")."));
                }
                hashtable.remove(moduleClassID2);
            }
            if (moduleClassID != null) break;
        }
    }

    public int startApp(String[] stringArray) {
        super.startApp(stringArray);
        this.loadAllModules(this.applications, null);
        int n = 0;
        Enumeration enumeration = this.applications.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Module module = (Module)this.applications.get(k);
            int n2 = module.startApp(stringArray);
            if (n2 != 0) {
                this.applications.remove(k);
            } else {
                this.applications.put(k, module);
            }
            n += n2;
        }
        return n;
    }

    public void stopApp() {
        Module module;
        Enumeration enumeration = this.applications.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                module = null;
                try {
                    module = (Module)enumeration.nextElement();
                    module.stopApp();
                }
                catch (Exception exception) {
                    if (module == null || !LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)("Failed to stop application: " + module.getClass().getName()));
                }
            }
        }
        this.applications = null;
        enumeration = this.protocols.elements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                module = null;
                try {
                    module = (Module)enumeration.nextElement();
                    module.stopApp();
                }
                catch (Exception exception) {
                    if (module == null || !LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)("Failed to stop application: " + module.getClass().getName()));
                }
            }
        }
        this.protocols = null;
        super.stopApp();
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        block17: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
            if (this.initialized) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"You cannot initialize a PeerGroup more than once !");
                }
                return;
            }
            this.initialized = true;
            super.init(peerGroup, iD, moduleImplAdvertisement);
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)this.getConfigAdvertisement();
            if (peerAdvertisement != null) {
                object6 = peerAdvertisement.getServiceParams();
                object5 = ((Hashtable)object6).keys();
                while (object5.hasMoreElements()) {
                    object4 = (ID)object5.nextElement();
                    object3 = (TextElement)((Hashtable)object6).get(object4);
                    if (!object3.getChildren("isOff").hasMoreElements()) continue;
                    this.disabledModules.addElement(object4);
                }
                peerAdvertisement = null;
                object6 = null;
            }
            object6 = new StdPeerGroupParamAdv(moduleImplAdvertisement.getParam());
            this.applications = ((StdPeerGroupParamAdv)object6).getApps();
            object5 = ((StdPeerGroupParamAdv)object6).getServices();
            this.protocols = ((StdPeerGroupParamAdv)object6).getProtos();
            this.loadAllModules((Hashtable)object5, PeerGroup.endpointClassID);
            object4 = (Module)((Hashtable)object5).get(PeerGroup.endpointClassID);
            if (object4 != null) {
                this.addService(PeerGroup.endpointClassID, (Service)object4);
                object4.startApp(null);
                ((Hashtable)object5).remove(PeerGroup.endpointClassID);
                this.loadAllModules(this.protocols, null);
                object3 = this.protocols.elements();
                while (object3.hasMoreElements()) {
                    object2 = (Module)object3.nextElement();
                }
            } else {
                if (peerGroup != null) {
                    this.addService(PeerGroup.endpointClassID, peerGroup.getEndpointService());
                    object3 = this.getPeerAdvertisement();
                    object2 = peerGroup.getPeerAdvertisement();
                    ((PeerAdvertisement)object3).putServiceParam(PeerGroup.endpointClassID, ((PeerAdvertisement)object2).getServiceParam(PeerGroup.endpointClassID));
                }
                this.protocols.clear();
            }
            this.loadAllModules((Hashtable)object5, null);
            object2 = ((Hashtable)object5).keys();
            while (object2.hasMoreElements()) {
                object = (ModuleClassID)object2.nextElement();
                object3 = (Module)((Hashtable)object5).get(object);
                if (object3 instanceof Service) {
                    this.addService((ID)object, (Service)object3);
                    continue;
                }
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)("Suspicious service: " + ((ID)object).toString()));
                LOG.warn((Object)"is not an instance of Service.");
                LOG.warn((Object)"It will not be registered as a service.");
            }
            try {
                this.checkServices();
            }
            catch (Exception exception) {
                throw new PeerGroupException(exception.getMessage());
            }
            object = ((Hashtable)object5).elements();
            while (object.hasMoreElements()) {
                object3 = (Module)object.nextElement();
                object3.startApp(null);
            }
            object = this.protocols.elements();
            while (object.hasMoreElements()) {
                object3 = (Module)object.nextElement();
                object3.startApp(null);
            }
            DiscoveryService discoveryService = this.getDiscoveryService();
            if (discoveryService != null) {
                try {
                    discoveryService.publish(discoveryService.getImplAdvertisement(), 2, 1471228928L, 1209600000L);
                    discoveryService.publish(moduleImplAdvertisement, 2, 1471228928L, 1209600000L);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block17;
                    LOG.warn((Object)"Failed to publish Impl adv within group.");
                }
            }
        }
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        if (this.allPurposeImplAdv != null) {
            return (ModuleImplAdvertisement)this.allPurposeImplAdv.clone();
        }
        RefPeerGroup refPeerGroup = this;
        while (refPeerGroup.getParentGroup() != null) {
            refPeerGroup = refPeerGroup.getParentGroup();
        }
        ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)refPeerGroup.getImplAdvertisement();
        moduleImplAdvertisement.setModuleSpecID(PeerGroup.allPurposePeerGroupSpecID);
        moduleImplAdvertisement.setDescription("General Purpose Peer Group Implementation");
        moduleImplAdvertisement.setCode((class$net$jxta$impl$peergroup$StdPeerGroup == null ? (class$net$jxta$impl$peergroup$StdPeerGroup = StdPeerGroup.class$("net.jxta.impl.peergroup.StdPeerGroup")) : class$net$jxta$impl$peergroup$StdPeerGroup).getName());
        TextElement textElement = (TextElement)((Object)moduleImplAdvertisement.getParam());
        StdPeerGroupParamAdv stdPeerGroupParamAdv = new StdPeerGroupParamAdv(textElement);
        stdPeerGroupParamAdv.setProtos(null);
        Hashtable hashtable = stdPeerGroupParamAdv.getServices();
        hashtable.remove(PeerGroup.endpointClassID);
        stdPeerGroupParamAdv.setServices(hashtable);
        ModuleImplAdvertisement moduleImplAdvertisement2 = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        moduleImplAdvertisement2.setModuleSpecID(PeerGroup.refShellSpecID);
        moduleImplAdvertisement2.setCompat(moduleImplAdvertisement.getCompat());
        moduleImplAdvertisement2.setUri(moduleImplAdvertisement.getUri());
        moduleImplAdvertisement2.setProvider(moduleImplAdvertisement.getProvider());
        moduleImplAdvertisement2.setDescription("JXTA Shell reference implementation");
        moduleImplAdvertisement2.setCode("net.jxta.impl.shell.bin.Shell.Shell");
        Hashtable<ModuleClassID, ModuleImplAdvertisement> hashtable2 = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        hashtable2.put(PeerGroup.applicationClassID, moduleImplAdvertisement2);
        stdPeerGroupParamAdv.setApps(hashtable2);
        textElement = (TextElement)((Object)stdPeerGroupParamAdv.getDocument(new MimeMediaType("text", "xml")));
        moduleImplAdvertisement.setParam(textElement);
        this.allPurposeImplAdv = moduleImplAdvertisement;
        return moduleImplAdvertisement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            PeerGroupFactory.setStdPeerGroupClass(Class.forName("net.jxta.impl.peergroup.StdPeerGroup"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stdCompatStatement = StdPeerGroup.mkCS();
    }
}

