/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.peer.PeerInfoServiceInterface;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.PeerInfoQueryMsg;
import net.jxta.impl.protocol.PeerInfoResponseMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.util.EndpointServiceStatsFilter;
import net.jxta.peer.PeerInfoEvent;
import net.jxta.peer.PeerInfoListener;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerInfoQueryMessage;
import net.jxta.protocol.PeerInfoResponseMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PeerInfoServiceImpl
implements PeerInfoService,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peer$PeerInfoServiceImpl == null ? (class$net$jxta$impl$peer$PeerInfoServiceImpl = PeerInfoServiceImpl.class$("net.jxta.impl.peer.PeerInfoServiceImpl")) : class$net$jxta$impl$peer$PeerInfoServiceImpl).getName());
    private static final String dirname = "PeerInfoService";
    private long startTime = 0L;
    private volatile int qid = 0;
    private Cm cm = null;
    private ResolverService resolver = null;
    private RefPeerGroup pg = null;
    private EndpointService endpoint = null;
    private EndpointServiceStatsFilter incomingStats = null;
    private EndpointServiceStatsFilter outgoingStats = null;
    private ID localPeerId = null;
    private Vector listeners = new Vector();
    private Hashtable listenerTable = new Hashtable();
    private ModuleImplAdvertisement implAdvertisement = null;
    private String handlerName = null;
    static /* synthetic */ Class class$net$jxta$impl$peer$PeerInfoServiceImpl;

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
    }

    public Service getInterface() {
        return new PeerInfoServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.incomingStats = new EndpointServiceStatsFilter();
        this.outgoingStats = new EndpointServiceStatsFilter();
        this.pg = (RefPeerGroup)peerGroup;
        this.endpoint = this.pg.getEndpointService();
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.localPeerId = this.pg.getPeerID();
        this.handlerName = iD.toString();
        this.startTime = System.currentTimeMillis();
    }

    public PeerInfoResponseMessage getPeerInfoService() {
        Object object;
        Object object2;
        int n = (int)(System.currentTimeMillis() / 1000L);
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        Enumeration enumeration = this.incomingStats.getChannelNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            hashtable.put(object2, new Long(this.incomingStats.getTrafficOnChannel((String)object2)));
        }
        object2 = new Hashtable();
        Enumeration enumeration2 = this.outgoingStats.getChannelNames();
        while (enumeration2.hasMoreElements()) {
            object = (String)enumeration2.nextElement();
            ((Hashtable)object2).put(object, new Long(this.outgoingStats.getTrafficOnChannel((String)object)));
        }
        object = new PeerInfoResponseMsg(this.localPeerId, this.localPeerId, (long)n - this.startTime, n, this.incomingStats.getLastMessageTime(), this.outgoingStats.getLastMessageTime(), hashtable, (Hashtable)object2);
        return object;
    }

    public int getRemotePeerInfo(ID iD) {
        if (this.resolver == null) {
            return this.qid++;
        }
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), PeerInfoQueryMessage.getMessageType());
        Element element = null;
        element = structuredTextDocument.createElement((Object)"sourcePid", this.localPeerId);
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement((Object)"targetPid", iD);
        structuredTextDocument.appendChild(element);
        ResolverQuery resolverQuery = null;
        String string = this.docToString(structuredTextDocument);
        PeerInfoServiceImpl peerInfoServiceImpl = this;
        synchronized (peerInfoServiceImpl) {
            resolverQuery = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId.toString(), string, this.qid++);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending query " + resolverQuery.getQueryId() + " from " + Integer.toHexString(this.localPeerId.hashCode()) + " to " + (iD == null ? "null" : Integer.toHexString(iD.hashCode()))));
        }
        this.resolver.sendQuery(iD.toString(), resolverQuery);
        return resolverQuery.getQueryId();
    }

    public void getRemotePeerInfo(ID iD, PeerInfoListener peerInfoListener) {
        if (this.resolver == null) {
            return;
        }
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), PeerInfoQueryMessage.getMessageType());
        Element element = null;
        element = structuredTextDocument.createElement((Object)"sourcePid", this.localPeerId);
        structuredTextDocument.appendChild(element);
        element = structuredTextDocument.createElement((Object)"targetPid", iD);
        structuredTextDocument.appendChild(element);
        ResolverQuery resolverQuery = null;
        String string = this.docToString(structuredTextDocument);
        PeerInfoServiceImpl peerInfoServiceImpl = this;
        synchronized (peerInfoServiceImpl) {
            resolverQuery = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId.toString(), string, this.qid++);
        }
        if (peerInfoListener != null) {
            this.listenerTable.put(new Integer(resolverQuery.getQueryId()), peerInfoListener);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending query " + resolverQuery.getQueryId() + " from " + this.localPeerId + " to " + iD));
        }
        this.resolver.sendQuery(iD.toString(), resolverQuery);
    }

    /*
     * Unable to fully structure code
     */
    public Enumeration getLocalPeerInfo(ID var1_1) throws IOException {
        var2_2 = new Vector<Object>();
        if (this.cm == null) {
            return var2_2.elements();
        }
        if (var1_1 == null) {
            var3_3 = this.cm.getFileNames("PeerInfoService");
            var4_6 = 0;
            while (var4_6 < var3_3.length) {
                block19: {
                    var5_8 = null;
                    var6_10 = null;
                    try {
                        var5_8 = this.cm.getInputStream("PeerInfoService", var3_3[var4_6]);
                        var6_10 = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), var5_8);
                        var2_2.addElement(var6_10);
                        var9_12 = null;
                        ** if (var5_8 == null) goto lbl-1000
                    }
                    catch (Throwable var8_14) {
                        var9_12 = null;
                        if (var5_8 != null) {
                            try {
                                var5_8.close();
                            }
                            catch (IOException var10_13) {
                                // empty catch block
                            }
                        }
                        throw var8_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var5_8.close();
                        }
                        catch (IOException var10_13) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block19;
                        catch (Exception var7_11) {
                            if (PeerInfoServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                                PeerInfoServiceImpl.LOG.debug((Object)var7_11);
                            }
                            var9_12 = null;
                            if (var5_8 != null) {
                                try {
                                    var5_8.close();
                                }
                                catch (IOException var10_13) {}
                            }
                        }
                    }
                }
                ++var4_6;
            }
        } else {
            try {
                var3_4 = var1_1.getUniqueValue().toString();
                if (PeerInfoServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                    PeerInfoServiceImpl.LOG.debug((Object)("restoring " + var3_4 + " from " + "PeerInfoService"));
                }
                var4_7 = null;
                var4_7 = this.cm.restore("PeerInfoService", var3_4);
                var5_9 = new PeerInfoResponseMsg(var4_7);
                var2_2.addElement(var5_9);
            }
            catch (Exception var3_5) {
                // empty catch block
            }
        }
        return var2_2.elements();
    }

    public PeerGroup getGroup() {
        return this.pg;
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg resolverQueryMsg) throws NoResponseException {
        Object object;
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), new ByteArrayInputStream(resolverQueryMsg.getQuery().getBytes()));
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"PeerInfoService.processQuery got a bad adv", (Throwable)exception);
            }
            return null;
        }
        PeerInfoQueryMsg peerInfoQueryMsg = new PeerInfoQueryMsg(structuredTextDocument);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processing query " + resolverQueryMsg.getQueryId() + " at peer " + this.localPeerId + " from " + peerInfoQueryMsg.getSourcePid() + " to " + peerInfoQueryMsg.getTargetPid()));
        }
        if (this.localPeerId.equals(peerInfoQueryMsg.getTargetPid())) {
            Object object2;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("responding to query " + resolverQueryMsg.getQueryId()));
            }
            object = new PeerInfoResponseMsg();
            ((PeerInfoResponseMessage)object).setSourcePid(peerInfoQueryMsg.getSourcePid());
            ((PeerInfoResponseMessage)object).setTargetPid(this.localPeerId);
            long l = System.currentTimeMillis();
            ((PeerInfoResponseMessage)object).setUptime(l - this.startTime);
            ((PeerInfoResponseMessage)object).setTimestamp(l);
            ((PeerInfoResponseMessage)object).setLastIncomingMessageTime(this.incomingStats.getLastMessageTime());
            ((PeerInfoResponseMessage)object).setLastOutgoingMessageTime(this.outgoingStats.getLastMessageTime());
            Enumeration enumeration = this.incomingStats.getChannelNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                long l2 = this.incomingStats.getTrafficOnChannel((String)object2);
                ((PeerInfoResponseMessage)object).setIncomingTrafficElement((String)object2, l2);
            }
            object2 = this.outgoingStats.getChannelNames();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                long l3 = this.outgoingStats.getTrafficOnChannel(string);
                ((PeerInfoResponseMessage)object).setOutgoingTrafficElement(string, l3);
            }
            structuredTextDocument = (StructuredTextDocument)((PeerInfoResponseMessage)object).getDocument(new MimeMediaType("text/xml"));
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("forwarding query " + resolverQueryMsg.getQueryId()));
            }
            try {
                structuredTextDocument = (StructuredTextDocument)((PeerInfoQueryMessage)peerInfoQueryMsg).getDocument(new MimeMediaType("text/xml"));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Failure in gettting pip query", (Throwable)exception);
                }
                return null;
            }
        }
        object = null;
        object = new ResolverResponse(this.handlerName, "JXTACRED", resolverQueryMsg.getQueryId(), this.docToString(structuredTextDocument));
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sending response to " + ((ResolverResponseMsg)object).getQueryId()));
        }
        return object;
    }

    public void processResponse(ResolverResponseMsg resolverResponseMsg) {
        Object object;
        if (this.cm == null) {
            return;
        }
        PeerInfoResponseMsg peerInfoResponseMsg = null;
        try {
            object = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), new ByteArrayInputStream(resolverResponseMsg.getResponse().getBytes()));
            peerInfoResponseMsg = new PeerInfoResponseMsg((Element)object);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"PeerInfoService.processResponse got a bad adv", (Throwable)exception);
            }
            return;
        }
        object = new PeerInfoEvent(this, peerInfoResponseMsg, resolverResponseMsg.getQueryId());
        PeerInfoListener peerInfoListener = (PeerInfoListener)this.listenerTable.get(new Integer(resolverResponseMsg.getQueryId()));
        if (peerInfoListener != null) {
            peerInfoListener.peerInfoResponse((PeerInfoEvent)object);
        }
        int n = 0;
        while (n < this.listeners.size()) {
            peerInfoListener = (PeerInfoListener)this.listeners.elementAt(n);
            peerInfoListener.peerInfoResponse((PeerInfoEvent)object);
            ++n;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processing response " + resolverResponseMsg.getQueryId() + " at peer " + Integer.toHexString(this.localPeerId.hashCode()) + " from " + Integer.toHexString(peerInfoResponseMsg.getSourcePid().hashCode()) + " to " + Integer.toHexString(peerInfoResponseMsg.getTargetPid().hashCode())));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("publishing response " + resolverResponseMsg.getQueryId()));
        }
        try {
            StructuredDocument structuredDocument = (StructuredDocument)((PeerInfoResponseMessage)peerInfoResponseMsg).getDocument(new MimeMediaType("text/xml"));
            String string = peerInfoResponseMsg.getTargetPid().getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("publishing response " + resolverResponseMsg.getQueryId() + " in " + string));
            }
            this.cm.save(dirname, string, structuredDocument);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)exception);
            }
            return;
        }
    }

    public void flushAdvertisements(ID iD) throws IOException {
        if (this.cm == null) {
            return;
        }
        if (iD != null) {
            String string = iD.getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing advertisements for peer " + Integer.toHexString(iD.hashCode()) + " fn " + string));
            }
            this.cm.remove(dirname, string);
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"flushing all advertisements");
            }
            String[] stringArray = this.cm.getFileNames(dirname);
            int n = 0;
            while (n < stringArray.length) {
                this.cm.remove(dirname, stringArray[n]);
                ++n;
            }
        }
    }

    public synchronized void addPeerInfoListener(PeerInfoListener peerInfoListener) {
        this.listeners.addElement(peerInfoListener);
    }

    public synchronized boolean removePeerInfoListener(PeerInfoListener peerInfoListener) {
        return this.listeners.removeElement(peerInfoListener);
    }

    private String docToString(StructuredTextDocument structuredTextDocument) {
        StringWriter stringWriter = new StringWriter();
        try {
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"docToString failed", (Throwable)exception);
            }
            return "";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

