/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PasswdMembershipService
extends MembershipService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$membership$PasswdMembershipService == null ? (class$net$jxta$impl$membership$PasswdMembershipService = PasswdMembershipService.class$("net.jxta.impl.membership.PasswdMembershipService")) : class$net$jxta$impl$membership$PasswdMembershipService).getName());
    public static final ModuleSpecID passwordMembershipSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000050206");
    private PeerGroup peergroup = null;
    private Vector principals = null;
    private Vector authCredentials = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable logins = null;
    static /* synthetic */ Class class$net$jxta$impl$membership$PasswdMembershipService;

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.peergroup = peerGroup;
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        PeerGroupAdvertisement peerGroupAdvertisement = peerGroup.getPeerGroupAdvertisement();
        TextElement textElement = (TextElement)((Object)peerGroupAdvertisement.getServiceParam(iD));
        this.logins = new Hashtable();
        if (null == textElement) {
            throw new PeerGroupException("parameters for group passwords missing");
        }
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            String string;
            int n;
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (!textElement2.getName().equals("login") || -1 == (n = (string = textElement2.getTextValue()).indexOf(58))) continue;
            String string2 = string.substring(0, n).trim();
            int n2 = string.indexOf(58, n + 1);
            String string3 = string.substring(n + 1, n2);
            LOG.info((Object)("Adding login : '" + string2 + "' with encoded password : '" + string3 + "'"));
            this.logins.put(string2, string3);
        }
        this.resign();
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getPeerGroup() {
        return this.peergroup;
    }

    public Authenticator apply(AuthenticationCredential authenticationCredential) throws PeerGroupException, ProtocolNotSupportedException {
        String string = authenticationCredential.getMethod();
        if (null != string && !"PasswdAuthentication".equals(string)) {
            throw new ProtocolNotSupportedException("Authentication method not recognized");
        }
        return new PasswdAuthenticator(this, authenticationCredential);
    }

    public synchronized Enumeration getCurrentCredentials() throws PeerGroupException {
        return this.principals.elements();
    }

    public synchronized Enumeration getAuthCredentials() throws PeerGroupException {
        return this.authCredentials.elements();
    }

    public synchronized Credential join(Authenticator authenticator) throws PeerGroupException {
        if (!(authenticator instanceof PasswdAuthenticator)) {
            throw new ClassCastException("This is not my authenticator!");
        }
        if (!authenticator.isReadyForJoin()) {
            throw new PeerGroupException("Not Ready to join!");
        }
        if (!this.checkPasswd(((PasswdAuthenticator)authenticator).getAuth1Identity(), ((PasswdAuthenticator)authenticator).getAuth2_Password())) {
            throw new PeerGroupException("Incorrect Password!");
        }
        PasswdCredential passwdCredential = new PasswdCredential(this, ((PasswdAuthenticator)authenticator).getAuth1Identity(), "blah");
        this.principals.addElement(passwdCredential);
        this.authCredentials.addElement(authenticator.getAuthenticationCredential());
        return passwdCredential;
    }

    public synchronized void resign() throws PeerGroupException {
        this.principals = new Vector();
        this.authCredentials = new Vector();
        this.principals.addElement(new PasswdCredential(this, "nobody", "blah"));
    }

    public Credential makeCredential(Element element) throws PeerGroupException, Exception {
        Object object = element.getKey();
        if (!"PasswdCredential".equals(object)) {
            throw new PeerGroupException("Element does not contain a recognized credential format");
        }
        Enumeration enumeration = element.getChildren("PeerGroupID");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerGroupID Element");
        }
        PeerGroupID peerGroupID = (PeerGroupID)IDFactory.fromURL(new URL((String)((Element)enumeration.nextElement()).getValue()));
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra PeerGroupID Elements");
        }
        enumeration = element.getChildren("PeerID");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        PeerID peerID = (PeerID)IDFactory.fromURL(new URL((String)((Element)enumeration.nextElement()).getValue()));
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra PeerID Elements");
        }
        enumeration = element.getChildren("Identity");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing PeerID Element");
        }
        String string = (String)((Element)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra Identity Elements");
        }
        enumeration = element.getChildren("ReallyInsecureSignature");
        if (!enumeration.hasMoreElements()) {
            throw new RuntimeException("Missing 'ReallyInsecureSignature' Element");
        }
        String string2 = (String)((Element)enumeration.nextElement()).getValue();
        if (enumeration.hasMoreElements()) {
            throw new RuntimeException("Extra 'ReallyInsecureSignature' Elements");
        }
        return new PasswdCredential(this, peerGroupID, peerID, string, string2);
    }

    private boolean checkPasswd(String string, String string2) {
        String string3;
        if (!this.logins.containsKey(string)) {
            return false;
        }
        String string4 = PasswdMembershipService.makePsswd(string2);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Password '" + string2 + "' encodes as: '" + string4 + "'"));
        }
        if ((string3 = (String)this.logins.get(string)).equals("")) {
            return true;
        }
        boolean bl = string4.equals(string3);
        return bl;
    }

    public static String makePsswd(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            char c = Character.toUpperCase(stringBuffer.charAt(n));
            int n2 = "DQKWHRTENOGXCVYSFJPILZABMU".indexOf(c);
            if (-1 != n2) {
                stringBuffer.setCharAt(n, (char)(65 + n2));
            }
            --n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class IdMaker {
        IdMaker() {
        }

        static ID mkID(String string) {
            try {
                return IDFactory.fromURL(new URL("urn", "", "jxta:uuid-" + string));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnknownServiceException unknownServiceException) {
                // empty catch block
            }
            throw new JxtaError("Hardcoded Spec and Class IDs are malformed.");
        }
    }

    public class PasswdAuthenticator
    implements Authenticator {
        MembershipService source;
        AuthenticationCredential application;
        String whoami = null;
        String password = null;

        PasswdAuthenticator(MembershipService membershipService, AuthenticationCredential authenticationCredential) {
            this.source = membershipService;
            this.application = authenticationCredential;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public synchronized boolean isReadyForJoin() {
            return null != this.password && null != this.whoami;
        }

        public String getMethodName() {
            return "PasswdAuthentication";
        }

        public void setAuth1Identity(String string) {
            this.whoami = string;
        }

        public String getAuth1Identity() {
            return this.whoami;
        }

        public void setAuth2_Password(String string) {
            this.password = string;
        }

        private String getAuth2_Password() {
            return this.password;
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.application;
        }
    }

    private class PasswdCredential
    implements Credential {
        PasswdMembershipService source;
        String whoami;
        ID peerid;
        String signedPeerID;

        protected PasswdCredential(PasswdMembershipService passwdMembershipService2, String string, String string2) {
            this.source = passwdMembershipService2;
            this.whoami = string;
            this.peerid = passwdMembershipService2.getPeerGroup().getPeerID();
            this.signedPeerID = string2;
        }

        protected PasswdCredential(PasswdMembershipService passwdMembershipService2, PeerGroupID peerGroupID, PeerID peerID, String string, String string2) throws PeerGroupException {
            this.source = passwdMembershipService2;
            if (!passwdMembershipService2.getPeerGroup().getPeerGroupID().equals(peerGroupID)) {
                throw new PeerGroupException("Cannot credential for a different peer group.");
            }
            this.whoami = string;
            this.peerid = peerID;
            this.signedPeerID = string2;
        }

        public MembershipService getSourceService() {
            return this.source;
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return this.peerid;
        }

        public StructuredDocument getDocument(MimeMediaType mimeMediaType) throws Exception {
            StructuredDocument structuredDocument = StructuredDocumentFactory.newStructuredDocument(mimeMediaType, "PasswdCredential");
            Element element = structuredDocument.createElement("PeerGroupID", PasswdMembershipService.this.peergroup.getPeerGroupID().toString());
            structuredDocument.appendChild(element);
            element = structuredDocument.createElement("PeerID", PasswdMembershipService.this.peergroup.getPeerID().toString());
            structuredDocument.appendChild(element);
            element = structuredDocument.createElement("Identity", this.whoami);
            structuredDocument.appendChild(element);
            element = structuredDocument.createElement("ReallyInsecureSignature", this.signedPeerID);
            structuredDocument.appendChild(element);
            return structuredDocument;
        }

        public String getIdentity() {
            return this.whoami;
        }
    }
}

