/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.math.BigInteger;
import jxta.security.hash.Hash;
import jxta.security.impl.hash.MD5Hash;
import net.jxta.impl.index.BloomFilterProperties;

public class BloomFilter {
    private static final int INT_MASK = 255;
    Hash hash;
    int hashLength;
    int capacityFactor = 8;
    boolean DEBUGFLAG = false;
    BloomFilterProperties bfProperties;

    public BloomFilter(int n) {
        this.bfProperties = new BloomFilterProperties();
        this.bfProperties.setLength(n * this.capacityFactor);
        this.hash = new MD5Hash();
        this.hashLength = this.hash.getDigestLength();
    }

    public BloomFilter(BloomFilterProperties bloomFilterProperties) {
        this.bfProperties = bloomFilterProperties;
        if (this.bfProperties == null) {
            this.bfProperties = new BloomFilterProperties();
        }
        this.hash = new MD5Hash();
        this.hashLength = this.hash.getDigestLength();
    }

    public int getBitsPerEntry() {
        return this.bfProperties.nFunctionsPerEntry;
    }

    public int getLength() {
        return this.bfProperties.length;
    }

    public int[] getBitPositions(String string) {
        int[] nArray = new int[this.bfProperties.nFunctionsPerEntry];
        byte[] byArray = new byte[this.hashLength];
        byte[] byArray2 = string.getBytes();
        this.hash.doFinal(byArray2, 0, byArray2.length, byArray, 0);
        this.debug("key = " + string + "\n" + "digest=" + new BigInteger(1, byArray).toString(16));
        int n = 0;
        int n2 = 0;
        while (n2 < this.bfProperties.nFunctionsPerEntry) {
            nArray[n2] = this.getBitPosition(byArray, n);
            n += this.bfProperties.nBitsPerFunction;
            this.debug("Position" + n2 + "=" + nArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public BloomFilterProperties getProperties() {
        return this.bfProperties;
    }

    private int getBitPosition(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = (n + this.bfProperties.nBitsPerFunction - 1) / 8;
        int n5 = (n + this.bfProperties.nBitsPerFunction - 1) % 8;
        int n6 = (byArray[n2] & 0xFF) >>> n3;
        int n7 = 1;
        int n8 = n2 + 1;
        while (n8 < n4) {
            n6 += (byArray[n8] & 0xFF) << n7 * 8 - n3;
            ++n8;
            ++n7;
        }
        return (n6 += (byArray[n4] & 255 >>> 8 - (n5 + 1) & 0xFF) << (n4 - n2) * 8 - n3) % this.bfProperties.length;
    }

    public void debug(String string) {
        if (this.DEBUGFLAG) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(8334);
        BloomFilter bloomFilter = new BloomFilter(100);
        int[] nArray = bloomFilter.getBitPositions("Sherif");
    }
}

