/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Arrays;
import java.util.zip.CRC32;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.CodatID;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.ModuleSpecID;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.PeerID;
import net.jxta.impl.id.UUID.PipeID;

public class ID
implements Cloneable {
    static final int IdByteArraySize = 64;
    static final int uuidSize = 16;
    static final int flagsSize = 1;
    static final int flagsIdTypeOffset = 0;
    static final byte flagCodatID = 1;
    static final byte flagPeerGroupID = 2;
    static final byte flagPeerID = 3;
    static final byte flagPipeID = 4;
    static final byte flagModuleClassID = 5;
    static final byte flagModuleSpecID = 6;
    static final int flagsOffset = 63;
    private static final Object[][] wellKnownIDs = new Object[][]{{net.jxta.peergroup.PeerGroupID.worldPeerGroupID, PeerGroupID.worldPeerGroupID}, {net.jxta.peergroup.PeerGroupID.defaultNetPeerGroupID, PeerGroupID.defaultNetPeerGroupID}};
    protected byte[] bytes = new byte[64];
    public static final Instantiator INSTANTIATOR = new Instantiator();

    static net.jxta.id.ID translateFromWellKnown(net.jxta.id.ID iD) {
        int n = 0;
        while (n < wellKnownIDs.length) {
            net.jxta.id.ID iD2 = (net.jxta.id.ID)wellKnownIDs[n][0];
            if (iD2.equals(iD)) {
                return (net.jxta.id.ID)wellKnownIDs[n][1];
            }
            ++n;
        }
        return iD;
    }

    static net.jxta.id.ID translateToWellKnown(net.jxta.id.ID iD) {
        int n = 0;
        while (n < wellKnownIDs.length) {
            net.jxta.id.ID iD2 = (net.jxta.id.ID)wellKnownIDs[n][1];
            if (iD2.equals(iD)) {
                return (net.jxta.id.ID)wellKnownIDs[n][0];
            }
            ++n;
        }
        return iD;
    }

    ID() {
        this.bytes[63] = 0;
    }

    protected Object clone() {
        ID iD = new ID();
        iD.bytes = (byte[])this.bytes.clone();
        return iD;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ID) {
            return Arrays.equals(this.bytes, ((ID)object).bytes);
        }
        return false;
    }

    public int hashCode() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.bytes, 0, this.bytes.length);
        return (int)cRC32.getValue();
    }

    public String toString() {
        return this.getURL().toString();
    }

    public String getIDFormat() {
        return INSTANTIATOR.getSupportedIDFormat();
    }

    private String toHexDigits(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(cArray[by >>> 4 & 0xF]);
        stringBuffer.append(cArray[by & 0xF]);
        return stringBuffer.toString();
    }

    Object getUniqueValue() {
        StringBuffer stringBuffer = new StringBuffer(INSTANTIATOR.getSupportedIDFormat() + "-");
        int n = 62;
        while (n > 0) {
            if (0 != this.bytes[n]) break;
            --n;
        }
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(this.toHexDigits(this.bytes[n2]).toUpperCase());
            ++n2;
        }
        stringBuffer.append(this.toHexDigits(this.bytes[63]).toUpperCase());
        return stringBuffer.toString();
    }

    URL getURL() {
        URL uRL = null;
        try {
            uRL = new URL("urn", "", "jxta:" + this.getUniqueValue().toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("URL Handler for 'urn' could not be found. Check your classpath for sun.net.www.protocol.urn.Handler");
        }
        return uRL;
    }

    void longIntoBytes(int n, long l) {
        int n2 = 0;
        while (n2 < 8) {
            this.bytes[n2 + n] = (byte)(l >> (int)((long)(7 - n2) * 8L));
            ++n2;
        }
    }

    long bytesIntoLong(int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < 8) {
            l |= (long)(this.bytes[n2 + n] & 0xFF) << (int)((long)(7 - n2) * 8L);
            ++n2;
        }
        return l;
    }

    static final class Instantiator
    implements IDFactory.Instantiator {
        static final String UUIDEncoded = "uuid";

        Instantiator() {
        }

        public String getSupportedIDFormat() {
            return UUIDEncoded;
        }

        public net.jxta.id.ID fromURL(URL uRL) throws MalformedURLException, UnknownServiceException {
            net.jxta.id.ID iD = null;
            ID iD2 = new ID();
            if (!"urn".equalsIgnoreCase(uRL.getProtocol())) {
                throw new UnknownServiceException("URI protocol type was not as expected.");
            }
            String string = uRL.getFile();
            int n = string.indexOf(58);
            if (-1 == n) {
                throw new UnknownServiceException("URN namespace was missing.");
            }
            if (!"jxta".equalsIgnoreCase(string.substring(0, n))) {
                throw new UnknownServiceException("URN namespace was not as expected.");
            }
            int n2 = (string = string.substring(n + 1)).indexOf(45);
            if (-1 == n2) {
                throw new UnknownServiceException("URN Encodingtype was missing.");
            }
            if (!string.substring(0, n2).equals(UUIDEncoded)) {
                throw new UnknownServiceException("JXTA id format was not as expected.");
            }
            if (0 != (string = string.substring(n2 + 1)).length() % 2) {
                throw new MalformedURLException("URN contains an odd number of chars");
            }
            if (string.length() < 2) {
                throw new MalformedURLException("URN does not contain enough chars");
            }
            if (64 < string.length() % 2) {
                throw new MalformedURLException("URN contains too many chars");
            }
            try {
                int n3 = 0;
                while (n3 < string.length() / 2 - 1) {
                    int n4 = n3 * 2;
                    String string2 = string.substring(n4, n4 + 2);
                    iD2.bytes[n3] = (byte)Integer.parseInt(string2, 16);
                    ++n3;
                }
                iD2.bytes[63] = (byte)Integer.parseInt(string.substring(string.length() - 2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Invalid Character in jxta URI");
            }
            switch (iD2.bytes[63]) {
                case 1: {
                    iD = new CodatID(iD2);
                    break;
                }
                case 2: {
                    iD = new PeerGroupID(iD2);
                    if (!PeerGroupID.worldPeerGroupID.equals(iD)) break;
                    iD = net.jxta.peergroup.PeerGroupID.worldPeerGroupID;
                    break;
                }
                case 3: {
                    iD = new PeerID(iD2);
                    break;
                }
                case 4: {
                    iD = new PipeID(iD2);
                    break;
                }
                case 5: {
                    iD = new ModuleClassID(iD2);
                    break;
                }
                case 6: {
                    iD = new ModuleSpecID(iD2);
                    break;
                }
                default: {
                    throw new MalformedURLException("jxta ID type not recognized");
                }
            }
            return iD;
        }

        public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID peerGroupID) {
            PeerGroupID peerGroupID2 = (PeerGroupID)ID.translateFromWellKnown(peerGroupID);
            return new CodatID(peerGroupID2);
        }

        public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID peerGroupID, InputStream inputStream) throws IOException {
            PeerGroupID peerGroupID2 = (PeerGroupID)ID.translateFromWellKnown(peerGroupID);
            return new CodatID(peerGroupID2, inputStream);
        }

        public net.jxta.peer.PeerID newPeerID(net.jxta.peergroup.PeerGroupID peerGroupID) {
            PeerGroupID peerGroupID2 = (PeerGroupID)ID.translateFromWellKnown(peerGroupID);
            return new PeerID(peerGroupID2);
        }

        public net.jxta.peergroup.PeerGroupID newPeerGroupID() {
            return new PeerGroupID();
        }

        public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID peerGroupID) {
            PeerGroupID peerGroupID2 = (PeerGroupID)ID.translateFromWellKnown(peerGroupID);
            return new PipeID(peerGroupID2);
        }

        public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID peerGroupID, byte[] byArray) {
            PeerGroupID peerGroupID2 = (PeerGroupID)ID.translateFromWellKnown(peerGroupID);
            return new PipeID(peerGroupID2, byArray);
        }

        public net.jxta.platform.ModuleClassID newModuleClassID() {
            return new ModuleClassID();
        }

        public net.jxta.platform.ModuleClassID newModuleClassID(net.jxta.platform.ModuleClassID moduleClassID) {
            return new ModuleClassID(moduleClassID);
        }

        public net.jxta.platform.ModuleSpecID newModuleSpecID(net.jxta.platform.ModuleClassID moduleClassID) {
            return new ModuleSpecID(moduleClassID);
        }
    }
}

