/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.HandshakeInProgressException;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsMessage;
import net.jxta.impl.endpoint.tls.TlsMessenger;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsTransport
implements EndpointProtocol,
EndpointListener,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport).getName());
    protected String localPeerAddr = null;
    protected String localTlsPeerAddr = null;
    protected String localPeerId = null;
    protected String localPeerUID = null;
    private EndpointService endpoint = null;
    private PeerGroup group = null;
    private static final String tlsSName = "TlsTransport";
    private static String tlsSParam = null;
    private String localPeerAdv = null;
    private static String tlsPName = "jxtatls";
    private TlsManager manager = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsTransport;

    public boolean allowOverLoad() {
        return true;
    }

    public int startApp(String[] stringArray) {
        return 1;
    }

    public void stopApp() {
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        block5: {
            this.group = peerGroup;
            this.endpoint = peerGroup.getEndpointService();
            this.localPeerId = peerGroup.getPeerID().toString();
            this.localPeerUID = peerGroup.getPeerID().getUniqueValue().toString();
            this.localPeerAddr = "jxta://" + peerGroup.getPeerID().getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("localPeerId = " + this.localPeerId));
            }
            tlsSParam = peerGroup.getPeerGroupID().getUniqueValue().toString();
            this.localTlsPeerAddr = tlsPName + "://" + peerGroup.getPeerID().getUniqueValue().toString() + "/" + tlsSName + "/" + tlsSParam;
            try {
                this.endpoint.addListener(tlsSName + tlsSParam, this);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"TLS could not register...as good as dead");
                }
                if (!LOG.isEnabledFor(Priority.ERROR)) break block5;
                LOG.error((Object)exception);
            }
        }
        this.manager = new TlsManager(this);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TLS Transport is now initialized");
        }
        this.endpoint.addEndpointProtocol(this);
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return false;
    }

    public EndpointAddress getPublicAddress() {
        return this.endpoint.newEndpointAddress(this.localTlsPeerAddr);
    }

    public String getProtocolName() {
        return tlsPName;
    }

    public static String getSupportedProtocolName() {
        return "jxtatls";
    }

    public PeerGroup getPeerGroup() {
        return this.group;
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    public void close() {
        this.endpoint.removeListener(tlsSName + tlsSParam, this);
    }

    public boolean ping(EndpointAddress endpointAddress) {
        return true;
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processIncomingMessage starts");
            }
            try {
                this.manager.processIncomingMessage(message, endpointAddress, endpointAddress2);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                LOG.debug((Object)"Error processing incoming message", (Throwable)iOException);
            }
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsTransport: getMessanger for " + endpointAddress.toString()));
        }
        String string = endpointAddress.getProtocolAddress();
        String string2 = "jxta://" + string;
        if (string.equals(this.localPeerUID)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.endpoint, this.endpoint.newEndpointAddress(this.localPeerAddr), endpointAddress);
        }
        TlsConn tlsConn = null;
        try {
            tlsConn = this.manager.getTlsConn(this.endpoint.newEndpointAddress(string2));
        }
        catch (HandshakeInProgressException handshakeInProgressException) {
            throw new IOException("Cannot get TlsConn: " + handshakeInProgressException.getMessage());
        }
        if (tlsConn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Cannot get a TLS connection");
            }
            throw new IOException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"TlsTransport: TlsMessanger with TlsConn DONE");
        }
        return new TlsMessenger(endpointAddress, tlsConn, this);
    }

    public void sendToRemoteTls(EndpointAddress endpointAddress, Message message) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsTransport: sendToRemoteTLS, dest peer= " + endpointAddress.toString()));
        }
        EndpointAddress endpointAddress2 = this.endpoint.newEndpointAddress(endpointAddress.toString());
        endpointAddress2.setServiceName(tlsSName);
        endpointAddress2.setServiceParameter(tlsSParam);
        EndpointMessenger endpointMessenger = this.endpoint.getMessenger(endpointAddress2);
        if (endpointMessenger == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"getMessenger: no raw messenger");
            }
            throw new IOException("No raw messenger in getMessenger()");
        }
        endpointMessenger.sendMessage(message);
    }

    public void processReceivedMessage(Message message) {
        block13: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processReceivedMessage starts");
            }
            InputStream inputStream = null;
            String string = null;
            String string2 = null;
            EndpointAddress endpointAddress = null;
            EndpointAddress endpointAddress2 = null;
            TlsMessage tlsMessage = null;
            MessageElement messageElement = message.getElement("JxtaTls");
            try {
                if (messageElement == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"processReceivedMessage: no TLS header - discard message");
                    }
                    return;
                }
                inputStream = messageElement.getStream();
                if (inputStream == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"processReceivedMessage: invalid TLS header - discard message");
                    }
                    return;
                }
                tlsMessage = new TlsMessage(inputStream);
                endpointAddress = this.endpoint.newEndpointAddress(tlsMessage.getSrcAddress());
                endpointAddress2 = this.endpoint.newEndpointAddress(tlsMessage.getDestAddress());
                string = endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress();
                string2 = endpointAddress2.getProtocolName() + "://" + endpointAddress2.getProtocolAddress();
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("     srcPeer= " + string));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("    destPeer= " + string2));
                }
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Bad TLS header or bad message. Message dropped.");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("exception: " + exception));
                }
                return;
            }
            try {
                message.setSourceAddress(endpointAddress);
                message.setDestinationAddress(endpointAddress2);
                this.endpoint.demux(message);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                LOG.debug((Object)"Error while demuxing an incoming message", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

