/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender;
import net.jxta.impl.endpoint.servlethttp.HttpRelayClientMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpServerMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.JettyHttpServer;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.relay.RelayClientMessageSender;
import net.jxta.impl.relay.RelayServer;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ServletHttpTransport
implements EndpointProtocol,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport == null ? (class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.ServletHttpTransport")) : class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport).getName());
    private HttpClientMessageSender httpClientSender = null;
    private RelayClientMessageSender relayClientSender = null;
    private EndpointAddress localAddress = null;
    private static String protocolName = "http";
    protected static final String MAGIC_WORD = "JxtaHttpClient";
    private static final String MSG_RECEIVER_RELATIVE_URI = "/";
    private static final String RELAY_RELATIVE_URI = "/relay";
    private static int minThreads = 10;
    private static int maxThreads = 100;
    private static int maxThreadIdleTime = 120000;
    private static int maxReqReadTime = 60000;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        try {
            Object object;
            Enumeration enumeration;
            Properties properties = this.getJxtaProperties();
            this.initFromProperties(properties);
            ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
            Element element = moduleImplAdvertisement.getParam();
            if (element != null && (enumeration = element.getChildren("Proto")).hasMoreElements()) {
                object = (TextElement)enumeration.nextElement();
                protocolName = object.getTextValue();
            }
            if ((enumeration = (element = peerAdvertisement.getServiceParam(iD)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                element = (Element)enumeration.nextElement();
            } else {
                enumeration = element.getChildren(HTTPAdv.getAdvertisementType());
                if (enumeration.hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                }
            }
            object = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)element);
            EndpointService endpointService = peerGroup.getEndpointService();
            InetAddress inetAddress = this.computeInterface((HTTPAdv)object);
            this.localAddress = this.computeEndpointAddress(endpointService, (HTTPAdv)object, peerGroup.getPeerID().getUniqueValue().toString());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Local address = " + this.localAddress));
            }
            this.configureProxyServer((HTTPAdv)object);
            this.configureHttpClientSender(this.localAddress, (HTTPAdv)object);
            if (((HTTPAdv)object).getRouterEnabled()) {
                this.configureRelayClients(peerGroup, endpointService, (HTTPAdv)object);
            }
            if (((HTTPAdv)object).getServerEnabled()) {
                this.configureServer((HTTPAdv)object, peerGroup, inetAddress, endpointService, properties);
            }
            endpointService.addEndpointProtocol(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Not initialized: " + exception));
            }
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        if (this.isRelayClientAddress(endpointAddress)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Returned relay client messenger");
            }
            return this.relayClientSender.getMessenger(endpointAddress);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Returning normal http client messenger");
        }
        return this.httpClientSender.getMessenger(endpointAddress);
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    public void close() {
    }

    public String getProtocolName() {
        return ServletHttpTransport.getSupportedProtocolName();
    }

    public static String getSupportedProtocolName() {
        return protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.localAddress;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean ping(EndpointAddress endpointAddress) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Trying to ping " + endpointAddress));
        }
        if (this.isRelayClientAddress(endpointAddress)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  Using relay client sender to ping " + endpointAddress));
            }
            return this.relayClientSender.ping(endpointAddress);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  Using http client sender to ping " + endpointAddress));
        }
        return this.httpClientSender.ping(endpointAddress);
    }

    private EndpointAddress computeEndpointAddress(EndpointService endpointService, HTTPAdv hTTPAdv, String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"computeEndpointAddress()");
        }
        if (hTTPAdv.getServerEnabled()) {
            return endpointService.newEndpointAddress(protocolName + "://" + hTTPAdv.getServer());
        }
        String string2 = string;
        return endpointService.newEndpointAddress(protocolName + "://" + MAGIC_WORD + string2);
    }

    private void configureHttpClientSender(EndpointAddress endpointAddress, HTTPAdv hTTPAdv) {
        String string = null;
        if (hTTPAdv.getProxyEnabled()) {
            string = hTTPAdv.getProxy();
        }
        this.httpClientSender = new HttpClientMessageSender(endpointAddress);
    }

    private void configureRelayClients(PeerGroup peerGroup, EndpointService endpointService, HTTPAdv hTTPAdv) {
        Vector vector = hTTPAdv.getRouters();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    URL uRL = new URL("http://" + string + RELAY_RELATIVE_URI);
                    HttpRelayClientMessageReceiver httpRelayClientMessageReceiver = new HttpRelayClientMessageReceiver(uRL);
                    httpRelayClientMessageReceiver.init(peerGroup, endpointService, hTTPAdv);
                    httpRelayClientMessageReceiver.start();
                }
                catch (MalformedURLException malformedURLException) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) continue;
                    LOG.error((Object)("Invalid relay server specified: " + string));
                }
                catch (IOException iOException) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) continue;
                    LOG.error((Object)("Problem starting relay client: " + string + " Exception = " + iOException));
                }
            }
        }
    }

    private InetAddress computeInterface(HTTPAdv hTTPAdv) throws UnknownHostException {
        String string = hTTPAdv.getInterfaceAddress();
        if (string == null) {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return inetAddress;
    }

    private void configureServer(HTTPAdv hTTPAdv, PeerGroup peerGroup, InetAddress inetAddress, EndpointService endpointService, Properties properties) {
        block2: {
            try {
                String string = hTTPAdv.getServer();
                int n = Integer.parseInt(hTTPAdv.getPort());
                JettyHttpServer jettyHttpServer = new JettyHttpServer();
                jettyHttpServer.init(inetAddress, n, endpointService, minThreads, maxThreads, maxThreadIdleTime, maxReqReadTime);
                jettyHttpServer.addServlet(MSG_RECEIVER_RELATIVE_URI, (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageReceiverServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet).getName());
                HttpServerMessageReceiver httpServerMessageReceiver = new HttpServerMessageReceiver(jettyHttpServer);
                httpServerMessageReceiver.init(peerGroup, endpointService, hTTPAdv);
                httpServerMessageReceiver.start();
                RelayServer relayServer = new RelayServer(endpointService, properties);
                jettyHttpServer.setContextAttribute("relayServer", relayServer);
                jettyHttpServer.addServlet(RELAY_RELATIVE_URI, (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet).getName());
                this.relayClientSender = new RelayClientMessageSender(relayServer, this.localAddress);
                jettyHttpServer.start();
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)("Error starting HTTP server: " + iOException));
            }
        }
    }

    private void configureProxyServer(HTTPAdv hTTPAdv) {
        if (hTTPAdv.getProxyEnabled()) {
            String string = hTTPAdv.getProxy();
            if (string != null) {
                String string2 = string;
                String string3 = "8080";
                int n = string.lastIndexOf(58);
                if (-1 != n) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Configuring HTTP proxy server");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("  host: " + string2));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("  port: " + string3));
                }
                Properties properties = System.getProperties();
                ((Hashtable)properties).put("http.proxyHost", string2);
                ((Hashtable)properties).put("http.proxyPort", string3);
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Configuration error: proxy server turned on, but no proxy server specified");
            }
        }
    }

    private boolean isRelayClientAddress(EndpointAddress endpointAddress) {
        return endpointAddress.getProtocolAddress().indexOf(MAGIC_WORD) != -1;
    }

    private Properties getJxtaProperties() {
        InputStream inputStream;
        Properties properties;
        block9: {
            properties = null;
            inputStream = null;
            try {
                inputStream = new FileInputStream("jxta.properties");
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Read jxta.properties from present working directory");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                inputStream = classLoader.getResourceAsStream("jxta.properties");
                if (inputStream == null || !LOG.isEnabledFor(Priority.INFO)) break block9;
                LOG.info((Object)"Read jxta.properties from classpath");
            }
        }
        if (inputStream != null) {
            try {
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Error reading jxta.properties");
                }
                properties = null;
            }
        } else if (LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"jxta.properties cannot be found");
        }
        return properties;
    }

    private void initFromProperties(Properties properties) {
        block23: {
            if (properties != null) {
                String string;
                block22: {
                    String string2;
                    block21: {
                        String string3;
                        block20: {
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Using jxta.properties to configure HTTP server");
                            }
                            String string4 = properties.getProperty("HttpServer.MinThreads");
                            string3 = properties.getProperty("HttpServer.MaxThreads");
                            string2 = properties.getProperty("HttpServer.MaxRequestReadTime");
                            string = properties.getProperty("HttpServer.MaxThreadIdleTime");
                            try {
                                if (string4 != null) {
                                    minThreads = Integer.parseInt(string4);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!LOG.isEnabledFor(Priority.INFO)) break block20;
                                LOG.info((Object)"Invalid HttpServer.MinThreads value; using default");
                            }
                        }
                        try {
                            if (string3 != null) {
                                maxThreads = Integer.parseInt(string3);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!LOG.isEnabledFor(Priority.INFO)) break block21;
                            LOG.info((Object)"Invalid HttpServer.MaxThreads value; using default");
                        }
                    }
                    try {
                        if (string2 != null) {
                            maxReqReadTime = Integer.parseInt(string2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!LOG.isEnabledFor(Priority.INFO)) break block22;
                        LOG.info((Object)"Invalid HttpServer.MaxReqReadTime value; using default");
                    }
                }
                try {
                    if (string != null) {
                        maxThreadIdleTime = Integer.parseInt(string);
                    }
                    break block23;
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Invalid HttpServer.MaxThreadIdleTime value; using default");
                    }
                    break block23;
                }
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"jxta.properties not found: using default values");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("minThreads = " + minThreads));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxThreads = " + maxThreads));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxReqReadTime = " + maxReqReadTime));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxThreadIdleTime = " + maxThreadIdleTime));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

