/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpMessageReceiverServlet
extends HttpServlet {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet = HttpMessageReceiverServlet.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageReceiverServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet).getName());
    private EndpointService endpoint = null;
    private static final int MAX_POST_CONTENT_LEN = 0xA00000;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.endpoint = (EndpointService)this.getServletContext().getAttribute("endpoint");
            if (this.endpoint == null) {
                throw new ServletException("Servlet Context did not contain 'endpoint'");
            }
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("'endpoint' attribute was not of the proper type in the Servlet Context");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getRequestURI();
        if (string.equals("/ping")) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  responding with 200 to ping request");
            }
            httpServletResponse.setStatus(200);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.validateMessage(httpServletRequest, httpServletResponse)) {
            String string = httpServletRequest.getRequestURI();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("POSTed message is valid; uri=" + string));
            }
            if (string.equals("/")) {
                this.processMessage(httpServletRequest, httpServletResponse);
            }
        }
    }

    private boolean validateMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n = httpServletRequest.getContentLength();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("HTTP POST received, Content-Length = " + n));
        }
        if (n <= 0 || n > 0xA00000) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Rejected HTTP POST request; too long, not declared, or zero length; length=" + httpServletRequest.getContentLength()));
            }
            httpServletResponse.sendError(403, "Content-Length too long or not declared, or zero; max allowed is 10485760");
            return false;
        }
        return true;
    }

    private void processMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing posted message");
        }
        int n = httpServletRequest.getContentLength();
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Constructing MessageImpl and calling EndpointService.demux()");
            }
            Message message = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage((InputStream)servletInputStream, message);
            this.endpoint.demux(message);
            Thread.yield();
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Malformed JXTA message, responding with BAD_REQUEST: " + iOException));
            }
            httpServletResponse.sendError(400, "Message was not a valid JXTA message");
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)" Sending OK in response to HTTP POST");
        }
        httpServletResponse.setStatus(200);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

