/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpClient;
import net.jxta.impl.endpoint.http.HttpMessage;
import net.jxta.impl.endpoint.http.HttpNonBlockingMessenger;
import net.jxta.impl.endpoint.http.HttpServer;
import net.jxta.impl.endpoint.http.HttpServerMessenger;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpTransport
implements EndpointProtocol,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpTransport == null ? (class$net$jxta$impl$endpoint$http$HttpTransport = HttpTransport.class$("net.jxta.impl.endpoint.http.HttpTransport")) : class$net$jxta$impl$endpoint$http$HttpTransport).getName());
    static final boolean useBlockingSend = true;
    static final String Register = "reg";
    static final String Receive = "rec";
    static final String BlockingReceive = "blk";
    static final String Send = "snd";
    static final String Ping = "ack";
    static final Cm cm = new Cm("HttpTransport", false);
    static final HttpMessage PingOk = new HttpMessage("Jxta Ping OK");
    static final int LingerDelay = 30000;
    static final int SocketTimeout = 30000;
    static final String MagicWord = "JxtaHttpClient";
    static final int PollingSend = 1;
    static final int BlockingSend = 2;
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private ThreadGroup myThreadGroup = null;
    private String interfaceAddress = null;
    private InetAddress usingInterface = null;
    private String serverName = null;
    private int serverSocketPort = -1;
    HttpServer server = null;
    String localClientId = null;
    private Vector routers = null;
    private String proxyName = null;
    private URL proxyHost = null;
    private HttpClient pollingThread = null;
    private Hashtable servers = new Hashtable();
    private EndpointAddress publicAddress = null;
    private EndpointAddress publicServerAddress = null;
    private EndpointAddress publicClientAddress = null;
    String HttpSpool;
    String protocolName = "http";
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpTransport;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeEndpointProtocol(this);
        this.stopPolling();
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        try {
            Object object;
            block46: {
                Object object2;
                Enumeration enumeration;
                this.group = peerGroup;
                this.endpoint = peerGroup.getEndpointService();
                ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
                PeerAdvertisement peerAdvertisement = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
                Element element = moduleImplAdvertisement.getParam();
                if (element != null && (enumeration = element.getChildren("Proto")).hasMoreElements()) {
                    object2 = (TextElement)enumeration.nextElement();
                    this.protocolName = object2.getTextValue();
                }
                if ((enumeration = element.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                    element = (Element)enumeration.nextElement();
                } else {
                    enumeration = element.getChildren(HTTPAdv.getAdvertisementType());
                    if (enumeration.hasMoreElements()) {
                        element = (Element)enumeration.nextElement();
                    }
                }
                object2 = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)element);
                this.interfaceAddress = ((HTTPAdv)object2).getInterfaceAddress();
                if (((HTTPAdv)object2).getRouterEnabled()) {
                    this.routers = ((HTTPAdv)object2).getRouters();
                }
                if (((HTTPAdv)object2).getProxyEnabled()) {
                    this.proxyName = ((HTTPAdv)object2).getProxy();
                }
                if (((HTTPAdv)object2).getServerEnabled()) {
                    this.serverName = ((HTTPAdv)object2).getServer();
                    try {
                        this.serverSocketPort = Integer.parseInt(((HTTPAdv)object2).getPort());
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.ERROR)) break block46;
                        LOG.error((Object)"Bad ServerPort from advertisement");
                    }
                }
            }
            if (this.routers == null) {
                if (this.proxyName != null && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"This system does not use an external router; ignoring proxy settings.");
                }
                this.proxyName = null;
            } else {
                if (this.serverName != null && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"This system needs an external router. It cannot be a routing server.");
                }
                this.serverName = null;
            }
            if (this.interfaceAddress == null) {
                this.interfaceAddress = InetAddress.getLocalHost().getHostAddress();
            }
            this.usingInterface = InetAddress.getByName(this.interfaceAddress);
            this.endpoint = peerGroup.getEndpointService();
            this.localClientId = peerGroup.getPeerID().getUniqueValue().toString();
            if (this.serverName != null) {
                this.publicAddress = this.publicServerAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + this.serverName);
            } else {
                this.publicAddress = this.publicClientAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + MagicWord + this.localClientId);
                if (null != this.proxyName) {
                    try {
                        object = this.proxyName;
                        int n = 8080;
                        int n2 = this.proxyName.lastIndexOf(58);
                        if (-1 != n2) {
                            object = this.proxyName.substring(0, n2);
                            n = Integer.parseInt(this.proxyName.substring(n2 + 1));
                        }
                        this.proxyHost = new URL("http", (String)object, n, "/");
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"proxy name was not valid");
                        }
                        this.proxyHost = null;
                    }
                }
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Configuring HTTP Transport");
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Public address : " + this.publicAddress));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Using interface : " + this.usingInterface.getHostAddress()));
            }
            if (null != this.serverName) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"HTTP in server mode. ");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP server name: " + (this.serverName == null ? "(none)" : this.serverName)));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Server port:" + (this.serverSocketPort < 0 ? "(none)" : Integer.toString(this.serverSocketPort))));
                }
            } else {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"HTTP in client mode. (blocking)");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP routers: " + (this.routers == null ? "(none)" : this.routers.toString())));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP proxy: " + (this.proxyHost == null ? "(none)" : this.proxyHost.toString())));
                }
            }
            this.myThreadGroup = new ThreadGroup("HttpTransport " + this.usingInterface.getHostAddress());
            this.HttpSpool = "httpspool_" + this.usingInterface.getHostAddress() + (this.serverSocketPort < 0 ? "" : "_" + Integer.toString(this.serverSocketPort));
            if (!this.initDir(this.HttpSpool)) {
                return;
            }
            this.cleanupAllClients();
            if (this.serverName != null) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Starting server : " + this.serverName));
                }
                this.server = new HttpServer(this.myThreadGroup, this, this.usingInterface, this.serverSocketPort);
                this.server.start();
            } else if (this.routers != null) {
                object = this.routers.elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Starting client connection with " + string));
                    }
                    this.registerWithRemote(string);
                    ServerConnection serverConnection = new ServerConnection(this.myThreadGroup, this, string, this.localClientId);
                    serverConnection.start();
                }
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"There are no HTTP routers defined, no communication will occurr until some are defined.");
            }
            this.endpoint.addEndpointProtocol(this);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Not initialized: " + exception.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Initialization exception", (Throwable)exception);
            }
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"FIXME: there may be threads that need killing.");
            }
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public int getPort() {
        return this.serverSocketPort;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return true;
    }

    public synchronized String getProxy() {
        return this.proxyName;
    }

    public synchronized Vector getRouters() {
        return this.routers;
    }

    public synchronized String getServer() {
        return this.serverName;
    }

    public synchronized boolean doesPropagate() {
        return false;
    }

    private String getHttpHeader(String string) {
        int n = string.indexOf("\r\n\r\n") + 4;
        int n2 = string.indexOf("\n\n") + 2;
        int n3 = Math.min(n = n < 4 ? Integer.MAX_VALUE : n, n2 = n2 < 2 ? Integer.MAX_VALUE : n2);
        if (Integer.MAX_VALUE != n3) {
            return string.substring(0, n3);
        }
        return null;
    }

    public void runReceive(Socket socket) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = socket.getInputStream();
            if (null == inputStream) {
                HttpTransport.closeSocket(socket, inputStream, outputStream);
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Could not get input stream from socket");
                }
                return;
            }
            HttpMessage httpMessage = null;
            String string = this.getResult(inputStream, false);
            if (string == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"null message - discard");
                }
                HttpTransport.closeSocket(socket, inputStream, outputStream);
                return;
            }
            String string2 = this.getHttpHeader(string);
            int n2 = string2.indexOf(" ");
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, string2.indexOf(" HTTP"));
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Incoming client request : " + string3 + " " + string4));
            }
            if (string3.equals("GET")) {
                n = 0;
                String string5 = null;
                n2 = string4.indexOf("/reg/");
                if (n2 >= 0) {
                    string5 = Register;
                    n = n2;
                }
                if ((n2 = string4.indexOf("/rec/")) >= 0) {
                    string5 = Receive;
                    n = n2;
                }
                if ((n2 = string4.indexOf("/blk/")) >= 0) {
                    string5 = BlockingReceive;
                    n = n2;
                }
                if ((n2 = string4.indexOf("/snd/")) >= 0) {
                    string5 = Send;
                    n = n2;
                }
                if ((n2 = string4.indexOf("/ack/")) >= 0) {
                    string5 = Ping;
                    n = n2;
                }
                if (string5 == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Unrecognized command in request");
                    }
                    HttpTransport.closeSocket(socket, inputStream, outputStream);
                    return;
                }
                String string6 = string4.substring(n + 5);
                if (string6.indexOf("/") >= 0) {
                    string6 = string6.substring(0, string6.length() - 1);
                }
                if (string5.equals(Register)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Registering remote peer");
                    }
                    httpMessage = this.register(string6);
                }
                if (string5.equals(Receive)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Remote peer polls messages");
                    }
                    httpMessage = this.processOutgoing(string6, false, socket, inputStream);
                }
                if (string5.equals(BlockingReceive)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Remote peer polls messages - blocking");
                    }
                    httpMessage = this.processOutgoing(string6, true, socket, inputStream);
                }
                if (string5.equals(Ping)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Processing ping");
                    }
                    httpMessage = this.processPing();
                }
            }
            if (string3.equals("PUT") || string3.equals("POST")) {
                n = string.indexOf("<HTML>\n", string2.length());
                int n3 = string.lastIndexOf("\n</HTML>\n");
                if (n < 0 || n3 <= 0) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Invalid message len=" + string.length() + " indexFirst=" + n + " indexLast=" + n3));
                    }
                    HttpTransport.closeSocket(socket, inputStream, outputStream);
                    return;
                }
                string = string.substring(n + "<HTML>\n".length(), n3);
                httpMessage = this.processIncoming(string);
            }
            if (httpMessage != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Sending response for : " + string3 + " " + string4));
                }
                if (null == (outputStream = socket.getOutputStream())) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"HTTP: outputstream is null, message discarded");
                    }
                    HttpTransport.closeSocket(socket, inputStream, outputStream);
                    return;
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Still need response for " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort()));
                }
                return;
            }
            byte[] byArray = httpMessage.getBytes();
            Vector<byte[]> vector = new Vector<byte[]>();
            vector.addElement(byArray);
            HttpTransport.sendResponse(outputStream, vector, byArray.length);
            HttpTransport.closeSocket(socket, inputStream, outputStream);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("runReceive : Aborting connection to  " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort()), (Throwable)exception);
            }
            HttpTransport.closeSocket(socket, inputStream, outputStream);
        }
    }

    public boolean sendHttpPUT(URL uRL, Enumeration enumeration, long l) throws IOException {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Client PUT  to " + uRL));
        }
        if (null == (socket = this.openSocket(uRL))) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"failed to open socket. Message not sent.");
            }
            return false;
        }
        String string = uRL.getHost();
        int n = uRL.getPort();
        n = -1 == n ? 80 : n;
        String string2 = "POST " + uRL + " HTTP/1.1\r\n" + "Host: " + string + ":" + n + "\r\n" + "Content-Type: " + "application/octet-stream\r\n" + "Content-Length: " + (l + 16L) + "\r\n" + "User-Agent: Jxta1.0\r\n\r\n";
        try {
            block9: {
                try {
                    Object object;
                    outputStream = socket.getOutputStream();
                    inputStream = socket.getInputStream();
                    outputStream.write(string2.getBytes());
                    outputStream.write("<HTML>\n".getBytes());
                    while (enumeration.hasMoreElements()) {
                        object = (byte[])enumeration.nextElement();
                        outputStream.write((byte[])object);
                    }
                    outputStream.write("\n</HTML>\n".getBytes());
                    outputStream.flush();
                    object = this.getResult(inputStream, true);
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    LOG.debug((Object)"Client PUT Message sent");
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendHttpPUT failed", (Throwable)exception);
                    }
                    boolean bl = false;
                    Object var14_13 = null;
                    HttpTransport.closeSocket(socket, inputStream, outputStream);
                    return bl;
                }
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            HttpTransport.closeSocket(socket, inputStream, outputStream);
            throw throwable;
        }
        HttpTransport.closeSocket(socket, inputStream, outputStream);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendHttpGET(URL uRL, int n, boolean bl) throws IOException {
        String string;
        OutputStream outputStream;
        InputStream inputStream;
        Socket socket;
        block18: {
            String string2;
            block17: {
                socket = null;
                inputStream = null;
                outputStream = null;
                string = null;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Client " + (n == 2 ? "blocking" : "nonblocking") + " GET (" + (bl ? "with" : "w/o") + " reply) to " + uRL));
                }
                try {
                    try {
                        socket = this.openSocket(uRL);
                        if (null == socket) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Client GET failed to open socket. Message not sent.");
                            }
                            string2 = null;
                            Object var16_11 = null;
                            break block17;
                        }
                        outputStream = socket.getOutputStream();
                        inputStream = socket.getInputStream();
                        String string3 = uRL.getHost();
                        int n2 = uRL.getPort();
                        n2 = -1 == n2 ? 80 : n2;
                        String string4 = "GET " + uRL + " HTTP/1.1\r\n" + "Host: " + string3 + ":" + n2 + "\r\n" + "User-Agent: Jxta1.0\r\n" + "Content-Length: 0\r\n\r\n";
                        outputStream.write(string4.getBytes());
                        outputStream.flush();
                        if (bl) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Client GET Message sent, " + (n == 2 ? "blocking" : "polling") + " for reply"));
                            } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Client GET Message sent, no reply wanted");
                            }
                        }
                        if (!bl) break block18;
                        String string5 = this.getResult(inputStream, n == 2);
                        if (string5 != null) {
                            String string6 = this.getHttpHeader(string5);
                            int n3 = string5.indexOf("<HTML>\n", string6.length());
                            int n4 = string5.lastIndexOf("</HTML>");
                            if (n3 >= 0 && n4 > 0) {
                                string = string5.substring(n3 + 7, n4);
                                break block18;
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Client GET got invalid reply");
                            }
                            break block18;
                        }
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Client GET wanted reply, but didn't get one");
                        }
                        break block18;
                    }
                    catch (Exception exception) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("HttpGet to '" + uRL + "' failed "), (Throwable)exception);
                        }
                        Object var16_13 = null;
                        HttpTransport.closeSocket(socket, inputStream, outputStream);
                        return string;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    HttpTransport.closeSocket(socket, inputStream, outputStream);
                    throw throwable;
                }
            }
            HttpTransport.closeSocket(socket, inputStream, outputStream);
            return string2;
        }
        Object var16_12 = null;
        HttpTransport.closeSocket(socket, inputStream, outputStream);
        return string;
    }

    private Socket openSocket(URL uRL) {
        Socket socket;
        block19: {
            Object object;
            int n;
            String string;
            block18: {
                socket = null;
                string = null;
                n = -1;
                try {
                    object = null;
                    String string2 = null;
                    if (this.proxyHost != null) {
                        string = this.proxyHost.getHost();
                        n = this.proxyHost.getPort();
                        string2 = "n/a";
                        object = "n/a";
                    } else {
                        string = uRL.getHost();
                        n = uRL.getPort();
                        n = -1 == n ? 80 : n;
                        String string3 = uRL.getFile();
                        int n2 = string3.indexOf(47, 1);
                        string2 = string3.substring(1, n2);
                        n2 = string3.indexOf("//", n2 + 1);
                        int n3 = string3.indexOf("/", n2 + 2);
                        object = -1 == n2 || -1 == n3 ? "n/a" : string3.substring(n2 + 2, n3);
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("openSocket to " + string + ":" + n + " (cmd='" + string2 + "' clientId='" + (String)object + "')"));
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block18;
                    LOG.warn((Object)"openSocket URL processing failed. ", (Throwable)exception);
                }
            }
            object = null;
            try {
                object = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("cannot resolve (DNS) " + string));
                }
                return null;
            }
            if (object == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("host name '" + string + "' resolved to localhost"));
                }
                return null;
            }
            try {
                socket = new Socket((InetAddress)object, n, this.usingInterface, 0);
            }
            catch (ConnectException connectException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Connect to " + ((InetAddress)object).getHostAddress() + ":" + n + " on interface " + this.usingInterface.getHostAddress() + " failed : " + connectException.toString()));
                }
                return null;
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Connect to " + ((InetAddress)object).getHostAddress() + ":" + n + " on interface " + this.usingInterface.getHostAddress() + " failed : " + exception.toString()));
                }
                return null;
            }
            try {
                socket.setSoLinger(true, 30000);
                socket.setSoTimeout(30000);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block19;
                LOG.debug((Object)"setting socket options failed ", (Throwable)exception);
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Connected to " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + " on interface " + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort()));
        }
        return socket;
    }

    private HttpMessage register(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Registering client " + string));
        }
        if (this.initDir(this.HttpSpool + File.separatorChar + string)) {
            this.cleanupClient(string);
            return HttpMessage.OKMESSAGE;
        }
        return HttpMessage.FAILEDMESSAGE;
    }

    private synchronized void recordConnection(String string, ServerConnection serverConnection) {
        block2: {
            try {
                this.servers.put(string, serverConnection);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)"recordConnection failed", (Throwable)exception);
            }
        }
    }

    private synchronized void forgetConnection(String string) {
        block2: {
            try {
                this.servers.remove(string);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)"forgetConnection failed", (Throwable)exception);
            }
        }
    }

    private synchronized boolean connectedServer(String string) {
        Object var2_2 = null;
        var2_2 = this.servers.get(string);
        return var2_2 != null;
    }

    static boolean sendResponse(OutputStream outputStream, Vector vector, long l) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendResponse starts");
        }
        if (l < 0L) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"len must be >=0");
            }
            throw new IllegalArgumentException("len must be >=0");
        }
        if (l != 0L && vector == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"buffers cannot be null for non-zero len response");
            }
            throw new IllegalArgumentException("buffers cannot be null for non-zero len response");
        }
        if (null == outputStream) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"outputstream cannot be null");
            }
            throw new IllegalArgumentException("outputstream cannot be null");
        }
        if (null == vector) {
            vector = new Vector<byte[]>(1);
        }
        try {
            int n = (int)l;
            if (l > 0L) {
                n += 16;
                vector.insertElementAt("<HTML>\n".getBytes(), 0);
                vector.addElement("\n</HTML>\n".getBytes());
            }
            String string = "HTTP/1.0 200 OK\r\nContent-type: application/octet-stream\r\nContent-length: " + Integer.toString(n) + "\r\n" + "\r\n";
            vector.insertElementAt(string.getBytes(), 0);
            int n2 = 0;
            while (n2 < vector.size()) {
                outputStream.write((byte[])vector.elementAt(n2));
                ++n2;
            }
            outputStream.flush();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Finished response");
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendResponse exception ", (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    static void closeSocket(Socket socket, InputStream inputStream, OutputStream outputStream) {
        block11: {
            block10: {
                block9: {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                            LOG.debug((Object)"closeSocket [1] failed.", (Throwable)exception);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                        LOG.debug((Object)"closeSocket [2] failed.", (Throwable)exception);
                    }
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                    LOG.debug((Object)"closeSokcet [3] failed.", (Throwable)exception);
                }
            }
        }
    }

    private HttpMessage processOutgoing(String string, boolean bl, Socket socket, InputStream inputStream) {
        byte[] byArray;
        HttpServer.ClientConnection clientConnection;
        OutputStream outputStream;
        block17: {
            String string2;
            String string3;
            outputStream = null;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processOutgoing for client " + string));
            }
            try {
                outputStream = socket.getOutputStream();
            }
            catch (IOException iOException) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"couldnt get outputstream for response");
                }
                return null;
            }
            clientConnection = null;
            if (!bl) {
                clientConnection = this.server.getClientConnection(string);
                if (null != clientConnection) {
                    clientConnection.close();
                    clientConnection = null;
                }
            } else {
                this.server.addClientConnection(string, socket, inputStream, outputStream);
            }
            if ((string3 = cm.getOldestFile(string2 = this.HttpSpool + File.separatorChar + string)) == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No messages for client");
                }
                if (!bl) {
                    return HttpMessage.EMPTYMESSAGE;
                }
                return null;
            }
            byArray = new HttpMessage(string2, string3).getBytes();
            try {
                cm.remove(string2, string3);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block17;
                LOG.warn((Object)("failed to remove cm file : " + string2 + File.separatorChar + string3));
            }
        }
        try {
            clientConnection = this.server.getClientConnection(string);
            if (clientConnection != null) {
                Vector<byte[]> vector = new Vector<byte[]>(1);
                vector.addElement(byArray);
                clientConnection.sendToClient(vector, byArray.length);
            } else {
                Vector<byte[]> vector = new Vector<byte[]>();
                vector.addElement(byArray);
                HttpTransport.sendResponse(outputStream, vector, byArray.length);
                HttpTransport.closeSocket(socket, inputStream, outputStream);
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"couldnt send reply?");
            }
            return null;
        }
        return null;
    }

    private HttpMessage processIncoming(String string) {
        try {
            byte[] byArray = string.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Message message = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).readMessage(byteArrayInputStream, message);
            this.endpoint.demux(message);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"failure processing incoming", (Throwable)exception);
            }
            return HttpMessage.FAILEDMESSAGE;
        }
        return HttpMessage.OKMESSAGE;
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        String string = endpointAddress.getProtocolAddress();
        if (string.length() > MagicWord.length() && string.substring(0, MagicWord.length()).equals(MagicWord)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   getting a server messenger");
            }
            return new HttpServerMessenger(endpointAddress, this);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"    getting a client messenger");
        }
        return new HttpNonBlockingMessenger(endpointAddress, this);
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    private void startPolling() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"startPolling");
        }
        if (this.pollingThread != null) {
            this.pollingThread.setPolling(true);
            return;
        }
        this.publicAddress = this.publicClientAddress;
        this.pollingThread = new HttpClient(this.myThreadGroup, this);
        this.pollingThread.start();
    }

    private void stopPolling() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"stopPolling");
        }
        if (this.pollingThread == null) {
            return;
        }
        this.pollingThread.endPolling();
        this.pollingThread = null;
        this.publicAddress = this.publicServerAddress;
    }

    boolean pollRemote(URL uRL, int n) {
        HttpMessage httpMessage = null;
        byte[] byArray = null;
        String string = null;
        try {
            string = this.sendHttpGET(uRL, n, true);
            if (string == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll (no reponse)");
                }
                return false;
            }
            httpMessage = new HttpMessage(string);
            if (3 == httpMessage.getCode()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll(by server code)");
                }
                return false;
            }
            byArray = httpMessage.getData();
            if (byArray == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll(empty msg body)");
                }
                return false;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Message message = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).readMessage(byteArrayInputStream, message);
            this.endpoint.demux(message);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   polled one message");
            }
            return true;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"pollRemote failed", (Throwable)exception);
            }
            return false;
        }
    }

    private boolean registerWithRemote(String string) {
        block9: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Register with Remote : " + string));
            }
            try {
                URL uRL;
                String string2;
                String string3 = string;
                int n = 80;
                int n2 = string.lastIndexOf(58);
                if (-1 != n2) {
                    string3 = string.substring(0, n2);
                    n = Integer.parseInt(string.substring(n2 + 1));
                }
                if ((string2 = this.sendHttpGET(uRL = new URL("http", string3, n, "/reg/" + this.localClientId + "/"), 1, true)) != null) {
                    int n3 = new HttpMessage(string2).getCode();
                    if (1 == n3) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"register with remote succeeded");
                        }
                        return true;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("register with remote failed with code : " + n3));
                    }
                    break block9;
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"register with remote got no response");
                }
                return true;
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                LOG.debug((Object)"register with remote failed for some reason", (Throwable)iOException);
            }
        }
        return false;
    }

    private String getResult(InputStream inputStream, boolean bl) {
        String string = "";
        byte[] byArray = null;
        if (!bl) {
            try {
                int n = 0;
                while (true) {
                    int n2 = inputStream.available();
                    if (inputStream.available() == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"getResult:EOF before we found the message end");
                        }
                        return null;
                    }
                    if (inputStream.available() == 0) {
                        try {
                            if (++n > 8) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)("getResult:Retry count exceeded. Had " + string.length() + " bytes"));
                                }
                                return null;
                            }
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"getResult:Thread interrupted, giving up");
                            }
                            Thread.interrupted();
                            return null;
                        }
                    }
                    byArray = new byte[n2];
                    int n3 = inputStream.read(byArray);
                    if (n3 == 0) continue;
                    n = 0;
                    if ((string = string + new String(byArray, 0, n3)).startsWith("GET") || string.lastIndexOf("</HTML>") >= 0) break;
                }
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"getResult:caught exception, giving up.", (Throwable)exception);
                }
                return null;
            }
        }
        try {
            boolean bl2 = false;
            byArray = new byte[4096];
            while (true) {
                int n = 0;
                try {
                    n = inputStream.read(byArray);
                }
                catch (InterruptedIOException interruptedIOException) {
                    n = interruptedIOException.bytesTransferred;
                }
                if (n == 0) {
                    if (!bl2) continue;
                    break;
                }
                if (n == -1) break;
                string = string + new String(byArray, 0, n);
                bl2 = true;
            }
            if (0 == string.length()) {
                string = null;
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getResult: caught exception, giving up.", (Throwable)exception);
            }
            return null;
        }
        return string;
    }

    public boolean ping(EndpointAddress endpointAddress) {
        if (endpointAddress == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"ping: address is null");
            }
            return false;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Pinging " + endpointAddress));
        }
        if (this.serverName != null) {
            try {
                if (-1 == endpointAddress.getProtocolAddress().indexOf(MagicWord)) {
                    return false;
                }
                String string = this.HttpSpool + File.separatorChar + endpointAddress.getProtocolAddress().substring(MagicWord.length());
                boolean bl = cm.isFolder(string);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("ping returns " + bl));
                }
                return bl;
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"ping [1] failed, returning false", (Throwable)exception);
                }
                return false;
            }
        }
        try {
            String string = endpointAddress.getProtocolAddress();
            if (string.startsWith(MagicWord)) {
                return false;
            }
            return this.checkServer(string);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"ping [2] failed, returning false", (Throwable)exception);
            }
            return false;
        }
    }

    private synchronized boolean checkServer(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("checkServer " + string));
        }
        if (this.connectedServer(string)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  connected server " + string));
            }
            return true;
        }
        if (null != this.pollingThread && this.pollingThread.isPollingHttp(string)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  polling server " + string));
            }
            return true;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  no connection with " + string));
        }
        return false;
    }

    private HttpMessage processPing() {
        return PingOk;
    }

    private boolean initDir(String string) {
        try {
            cm.createFolder(string);
            return true;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("cannot create spool folder: " + string));
            }
            return false;
        }
    }

    private void cleanupAllClients() {
        String[] stringArray;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"cleanupAllClients starts");
        }
        if ((stringArray = cm.getFileNames(this.HttpSpool)) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   no client folders");
            }
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (cm.isFolder(this.HttpSpool + File.separatorChar + stringArray[n])) {
                this.cleanupClient(stringArray[n]);
            }
            ++n;
        }
    }

    private void cleanupClient(String string) {
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("cleanupClient " + string));
            }
            try {
                String string2 = this.HttpSpool + File.separatorChar + string;
                cm.cleanupFolder(string2);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("cleanup failed for " + string));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ServerConnection
    extends Thread {
        private static final int PollingDelay = 20000;
        private static final int MAXFAILURES = 2;
        private long lastReceivedMsg = 0L;
        private long lastFailure = 0L;
        private int failureMode = 0;
        private URL remoteUrl = null;
        private HttpTransport tp = null;
        private String routerName = null;

        public ServerConnection(ThreadGroup threadGroup, HttpTransport httpTransport, String string, String string2) {
            super(threadGroup, null, "Server Connection to " + string);
            this.tp = httpTransport;
            this.routerName = string;
            try {
                String string3 = string;
                int n = 80;
                int n2 = string.lastIndexOf(58);
                if (-1 != n2) {
                    string3 = string.substring(0, n2);
                    n = Integer.parseInt(string.substring(n2 + 1));
                }
                this.remoteUrl = new URL("http", string3, n, "/blk/" + string2 + "/");
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Invalid server or client id");
            }
        }

        public void run() {
            block10: {
                this.tp.recordConnection(this.routerName, this);
                try {
                    while (true) {
                        if (!this.tp.pollRemote(this.remoteUrl, 2)) {
                            long l = System.currentTimeMillis();
                            if (this.lastFailure == 0L) {
                                this.lastFailure = l;
                                continue;
                            }
                            if (l - this.lastFailure > 20000L) {
                                this.failureMode = 0;
                                this.lastFailure = l;
                                continue;
                            }
                            if (this.failureMode >= 2) {
                                if (LOG.isEnabledFor(Priority.INFO)) {
                                    LOG.info((Object)"HttpTransport reverting to polling mode--too many failures");
                                }
                                break;
                            }
                            ++this.failureMode;
                            try {
                                Thread.sleep(20000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.interrupted();
                            }
                            this.lastFailure = System.currentTimeMillis();
                            continue;
                        }
                        this.failureMode = 0;
                        this.lastReceivedMsg = System.currentTimeMillis();
                    }
                    this.tp.startPolling();
                    this.tp.pollingThread.addPollingHttp(this.routerName);
                    this.tp.forgetConnection(this.routerName);
                }
                catch (Throwable throwable) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) break block10;
                    LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), throwable);
                }
            }
        }
    }
}

