/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpServerMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpServerMessenger == null ? (class$net$jxta$impl$endpoint$http$HttpServerMessenger = HttpServerMessenger.class$("net.jxta.impl.endpoint.http.HttpServerMessenger")) : class$net$jxta$impl$endpoint$http$HttpServerMessenger).getName());
    private EndpointAddress srcAddress = null;
    private EndpointAddress dstAddress = null;
    private HttpTransport proto = null;
    private String clientId = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpServerMessenger;

    public HttpServerMessenger(EndpointAddress endpointAddress, HttpTransport httpTransport) throws IOException {
        if (endpointAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"destination address is null");
            }
            throw new IllegalArgumentException("destination address is null");
        }
        this.proto = httpTransport;
        this.dstAddress = (EndpointAddress)endpointAddress.clone();
        this.srcAddress = this.proto.getPublicAddress();
        this.clientId = endpointAddress.getProtocolAddress().substring("JxtaHttpClient".length());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Creating object for:");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("    client = " + this.clientId));
        }
    }

    public void sendMessage(Message message) throws IOException {
        message.setSourceAddress(this.srcAddress);
        message.setDestinationAddress(this.dstAddress);
        Vector<byte[]> vector = new Vector<byte[]>();
        int n = 0;
        try {
            byte[] byArray;
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).writeMessage(byteArrayOutputStream, message);
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            while ((n2 = byteArrayInputStream.read(byArray = new byte[4096])) != -1) {
                if (n2 == 0) continue;
                if (n2 < 4096) {
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray3, 0, n2);
                    byArray = byArray3;
                }
                n += byArray.length;
                vector.addElement(byArray);
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HTTP - send - cannot read outgoing message", (Throwable)exception);
            }
            throw new IOException("HTTP - send - cannot read outgoing message");
        }
        this.proto.server.sendMessageToClient(this.clientId, vector, n);
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

