/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpMessage {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpMessage == null ? (class$net$jxta$impl$endpoint$http$HttpMessage = HttpMessage.class$("net.jxta.impl.endpoint.http.HttpMessage")) : class$net$jxta$impl$endpoint$http$HttpMessage).getName());
    private String dn;
    private String fn;
    private String doc;
    public static final String CodeTag = "Code";
    public static final String ContentTag = "Msg";
    public static final int Ok = 1;
    public static final int Failed = 2;
    public static final int Empty = 3;
    public static final int Content = 4;
    public static final HttpMessage OKMESSAGE = new HttpMessage(1);
    public static final HttpMessage FAILEDMESSAGE = new HttpMessage(2);
    public static final HttpMessage EMPTYMESSAGE = new HttpMessage(3);
    private static final long MessageLifeTime = 300000L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpMessage;

    public HttpMessage(int n) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = "<Code>" + Integer.toString(n) + "</" + CodeTag + ">";
    }

    public HttpMessage(String string) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = string;
    }

    public HttpMessage(int n, String string) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        String string2 = "<Code>" + Integer.toString(n) + "</" + CodeTag + ">" + "<" + ContentTag + ">\n";
        String string3 = "</Msg>";
        this.doc = string2 + string + string3;
    }

    public HttpMessage(byte[] byArray) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = new String(byArray);
    }

    public HttpMessage(String string, String string2) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.dn = string;
        this.fn = string2;
    }

    public HttpMessage(String string, String string2, int n, Vector vector) {
        this(string, string2, n, HttpMessage.combineBuffers(vector));
    }

    public HttpMessage(String string, String string2, Vector vector) {
        this(string, string2, HttpMessage.combineBuffers(vector));
    }

    private static InputStream combineBuffers(Vector vector) {
        Vector<ByteArrayInputStream> vector2 = new Vector<ByteArrayInputStream>(vector.size());
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(new ByteArrayInputStream((byte[])vector.elementAt(n)));
            ++n;
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(vector2.elements());
        return sequenceInputStream;
    }

    public HttpMessage(String string, String string2, byte[] byArray) {
        this(string, string2, 4, new ByteArrayInputStream(byArray));
    }

    public HttpMessage(String string, String string2, InputStream inputStream) {
        this(string, string2, 4, inputStream);
    }

    public HttpMessage(String string, String string2, int n, InputStream inputStream) {
        block2: {
            this(string, string2);
            String string3 = "<Code>" + Integer.toString(n) + "</" + CodeTag + ">" + "<" + ContentTag + ">\n";
            String string4 = "</Msg>";
            Vector<InputStream> vector = new Vector<InputStream>();
            vector.addElement(new ByteArrayInputStream(string3.getBytes()));
            vector.addElement(inputStream);
            vector.addElement(new ByteArrayInputStream(string4.getBytes()));
            SequenceInputStream sequenceInputStream = new SequenceInputStream(vector.elements());
            try {
                HttpTransport.cm.saveBytes(string, string2, sequenceInputStream, 300000L, 300000L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)"failed to seve to cm", (Throwable)exception);
            }
        }
    }

    public byte[] getBytes() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)exception);
                }
                return null;
            }
        }
        return this.doc.getBytes();
    }

    public byte[] getData() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)exception);
                }
                return null;
            }
        }
        int n = this.doc.indexOf("<Msg>");
        int n2 = this.doc.lastIndexOf("</Msg>");
        if (n == -1 || n2 == -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("invalid message " + n + " " + n2));
            }
            return null;
        }
        return this.doc.substring(n + ContentTag.length() + 3, n2).getBytes();
    }

    public int getCode() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)exception);
                }
                return -1;
            }
        }
        int n = this.doc.indexOf("<Code>");
        int n2 = this.doc.indexOf("</Code>");
        if (n == -1 || n2 == -1) {
            return -1;
        }
        String string = this.doc.substring(n + CodeTag.length() + 2, n2).trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

