/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.beep.BeepSession;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.ByteDataStream;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.lib.Reply;

public class BeepNonBlockingMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger = BeepNonBlockingMessenger.class$("net.jxta.impl.endpoint.beep.BeepNonBlockingMessenger")) : class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger).getName());
    private BeepSession session;
    private Channel channel;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger;

    public BeepNonBlockingMessenger(BeepSession beepSession) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Constructor");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   dest addr = " + beepSession.getDestEndpoint()));
        }
        this.session = beepSession;
        this.channel = beepSession.getNewChannel();
    }

    public void sendMessage(Message message) throws IOException {
        if (!this.session.isActive()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Session was closed with " + this.session.getDestEndpoint()));
            }
            throw new IOException("Session was closed with " + this.session.getDestEndpoint());
        }
        try {
            message.setDestinationAddress(this.session.getDestEndpoint());
            message.setSourceAddress(this.session.getSrcEndpoint());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessage");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   from = " + this.session.getSrcEndpoint()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("     to = " + this.session.getDestEndpoint()));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(byteArrayOutputStream, message);
            Reply reply = new Reply();
            ByteDataStream byteDataStream = new ByteDataStream(byteArrayOutputStream.toByteArray());
            this.channel.sendMSG((DataStream)byteDataStream, (ReplyListener)reply);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"message sent, waiting for reply.");
            }
            DataStream dataStream = reply.getNextReply().getDataStream();
            InputStream inputStream = dataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            while (!dataStream.isComplete() || inputStream.available() > 0) {
                int n = inputStream.read();
                if (-1 == n) continue;
                byteArrayOutputStream2.write((byte)n);
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"message sent, got reply.");
            }
            if (!byteArrayOutputStream2.toString().equals("OK") && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Bad reply");
            }
        }
        catch (BEEPError bEEPError) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error sending request (" + bEEPError.getCode() + ": " + bEEPError.getMessage() + ")"));
            }
            return;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error sending request (" + exception.getMessage() + ")"));
            }
            return;
        }
        this.session.updateLastUsed();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"message sent OK");
        }
    }

    public void close() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("close for " + this.session.getDestEndpoint()));
        }
        this.session.releaseChannel(this.channel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

