/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.PlainTextDocument;
import net.jxta.impl.document.TextElementCommon;

public class PlainTextElement
extends TextElementCommon
implements Attributable {
    protected PlainTextDocument doc;
    protected Element parent;
    protected final String name;
    protected final String val;
    private Vector children = new Vector();
    private HashMap attributes = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$document$PlainTextElement;

    protected PlainTextElement(PlainTextDocument plainTextDocument, String string) {
        this(plainTextDocument, string, null);
    }

    protected PlainTextElement(PlainTextDocument plainTextDocument, String string, String string2) {
        this.doc = plainTextDocument;
        this.name = string;
        this.val = string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlainTextElement)) {
            return false;
        }
        PlainTextElement plainTextElement = (PlainTextElement)object;
        if (this.doc != plainTextElement.doc) {
            return false;
        }
        if (!this.getName().equals(plainTextElement.getName())) {
            return false;
        }
        String string = this.getTextValue();
        String string2 = plainTextElement.getTextValue();
        if (null == string && null == string2) {
            return true;
        }
        if (null == string || null == string2) {
            return false;
        }
        return string.equals(string2);
    }

    public StructuredDocument getRoot() {
        return this.doc;
    }

    public Element getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public String getName() {
        return this.name;
    }

    public String getTextValue() {
        return this.val;
    }

    public void appendChild(TextElement textElement) {
        if (!(class$net$jxta$impl$document$PlainTextElement == null ? (class$net$jxta$impl$document$PlainTextElement = PlainTextElement.class$("net.jxta.impl.document.PlainTextElement")) : class$net$jxta$impl$document$PlainTextElement).isInstance(textElement)) {
            throw new IllegalArgumentException("element type not supported.");
        }
        PlainTextElement plainTextElement = (PlainTextElement)textElement;
        if (plainTextElement.doc != this.doc) {
            throw new IllegalArgumentException("Wrong Document");
        }
        plainTextElement.parent = this;
        this.children.addElement(plainTextElement);
    }

    public Enumeration getChildren(String string) {
        Vector<TextElement> vector = new Vector<TextElement>();
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TextElement textElement = (TextElement)enumeration.nextElement();
            if (!string.equals(textElement.getName())) continue;
            vector.addElement(textElement);
        }
        return vector.elements();
    }

    protected void printNice(Writer writer, int n, boolean bl) {
        try {
            Object object;
            int n2 = 0;
            while (n2 < n) {
                writer.write("\t");
                ++n2;
            }
            writer.write(this.name);
            Enumeration enumeration = this.getAttributes();
            if (enumeration.hasMoreElements()) {
                writer.write("(");
                while (enumeration.hasMoreElements()) {
                    object = (Attribute)enumeration.nextElement();
                    writer.write(((Attribute)object).getName() + "=\"" + ((Attribute)object).getValue() + "\" ");
                }
                writer.write(")");
            }
            writer.write(" : ");
            if (null != this.val) {
                writer.write(this.val + "\n");
            } else {
                writer.write("\n");
            }
            if (bl) {
                object = this.getChildren();
                while (object.hasMoreElements()) {
                    ((PlainTextElement)object.nextElement()).printNice(writer, n + 1, bl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String addAttribute(String string, String string2) {
        String string3 = (String)this.attributes.remove(string);
        this.attributes.put(string, string2);
        return string3;
    }

    public String addAttribute(Attribute attribute) {
        return this.addAttribute(attribute.getName(), attribute.getValue());
    }

    public Enumeration getAttributes() {
        Vector<Attribute> vector = new Vector<Attribute>();
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Attribute attribute = new Attribute(this, (String)entry.getKey(), (String)entry.getValue());
            vector.addElement(attribute);
        }
        return vector.elements();
    }

    public Attribute getAttribute(String string) {
        String string2 = (String)this.attributes.get(string);
        if (null == string2) {
            return null;
        }
        return new Attribute(this, string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

