/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.ProviderException;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.impl.document.PlainTextElement;
import net.jxta.impl.document.TextDocumentCommon;

public class PlainTextDocument
extends PlainTextElement
implements TextDocumentCommon {
    public static final Instantiator INSTANTIATOR = new Instantiator();
    private MimeMediaType mimeType = null;
    static /* synthetic */ Class class$java$lang$String;

    public PlainTextDocument(MimeMediaType mimeMediaType, String string) {
        super(null, string);
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeMediaType;
    }

    public PlainTextDocument(MimeMediaType mimeMediaType, String string, String string2) {
        super(null, string, string2);
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeMediaType;
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public String getRootType() {
        return this.name;
    }

    public Element createElement(Object object) {
        return this.createElement(object, null);
    }

    public Element createElement(Object object, Object object2) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = PlainTextDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(object.getClass())) {
            throw new ClassCastException(object.getClass().getName() + " not supported by createElement.");
        }
        if (null != object2 && !(class$java$lang$String == null ? (class$java$lang$String = PlainTextDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(object2.getClass())) {
            throw new ClassCastException(object2.getClass().getName() + " not supported by createElement.");
        }
        return new PlainTextElement(this, (String)object, (String)object2);
    }

    public TextElement createElement(String string) {
        return new PlainTextElement(this, string);
    }

    public TextElement createElement(String string, String string2) {
        return new PlainTextElement(this, string, string2);
    }

    public InputStream getStream() {
        StringWriter stringWriter = new StringWriter();
        this.printNice(stringWriter, 0, true);
        return new ByteArrayInputStream(stringWriter.toString().getBytes());
    }

    public void sendToStream(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.sendToWriter(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public Reader getReader() {
        StringWriter stringWriter = new StringWriter();
        this.printNice(stringWriter, 0, true);
        return new StringReader(stringWriter.toString());
    }

    public void sendToWriter(Writer writer) throws IOException {
        this.printNice(writer, 0, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Instantiator
    implements StructuredDocumentFactory.Instantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{new MimeMediaType("Text", "Plain")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("txt", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("text", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("txt", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, String string) {
            return new PlainTextDocument(mimeMediaType, string);
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, String string, String string2) {
            return new PlainTextDocument(mimeMediaType, string, string2);
        }

        public StructuredDocument newInstance(MimeMediaType mimeMediaType, InputStream inputStream) throws IOException {
            throw new ProviderException("PlainTextDocument does not support input");
        }
    }
}

